/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.unsafe;

import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.AlwaysSharedCopyTracker;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.UnsafeIoApi;
import kotlinx.io._UtilKt;
import kotlinx.io.unsafe.BufferIterationContext;
import kotlinx.io.unsafe.SegmentReadContext;
import kotlinx.io.unsafe.SegmentWriteContext;
import kotlinx.io.unsafe.UnsafeBufferOperationsKt;
import org.jetbrains.annotations.NotNull;

@UnsafeIoApi
@SourceDebugExtension(value={"SMAP\nUnsafeBufferOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Buffer.kt\nkotlinx/io/BufferKt\n*L\n1#1,568:1\n38#2:569\n1#3:570\n659#4,25:571\n*S KotlinDebug\n*F\n+ 1 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n*L\n43#1:569\n352#1:571,25\n*E\n"})
public final class UnsafeBufferOperations {
    @NotNull
    public static final UnsafeBufferOperations INSTANCE = new UnsafeBufferOperations();

    private UnsafeBufferOperations() {
    }

    public final int getMaxSafeWriteCapacity() {
        return 8192;
    }

    public final void moveToTail(@NotNull Buffer buffer, @NotNull byte[] bytes2, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        int size$iv = bytes2.length;
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        Segment segment = Segment.Companion.new$kotlinx_io_core(bytes2, startIndex, endIndex, AlwaysSharedCopyTracker.INSTANCE, false);
        Segment tail = buffer.getTail();
        if (tail == null) {
            buffer.setHead(segment);
            buffer.setTail(segment);
        } else {
            buffer.setTail(tail.push$kotlinx_io_core(segment));
        }
        buffer.setSizeMut(buffer.getSizeMut() + (long)(endIndex - startIndex));
    }

    public static /* synthetic */ void moveToTail$default(UnsafeBufferOperations unsafeBufferOperations, Buffer buffer, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = byArray.length;
        }
        unsafeBufferOperations.moveToTail(buffer, byArray, n, n2);
    }

    public final int readFromHead(@NotNull Buffer buffer, @NotNull Function3<? super byte[], ? super Integer, ? super Integer, Integer> readAction) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(readAction, (String)"readAction");
        boolean $i$f$readFromHead = false;
        if (!(!buffer.exhausted())) {
            boolean $i$a$-require-UnsafeBufferOperations$readFromHead$22 = false;
            String $i$a$-require-UnsafeBufferOperations$readFromHead$22 = "Buffer is empty";
            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$22.toString());
        }
        Segment segment = buffer.getHead();
        Intrinsics.checkNotNull((Object)segment);
        Segment head = segment;
        int bytesRead = ((Number)readAction.invoke((Object)head.dataAsByteArray(true), (Object)head.getPos(), (Object)head.getLimit())).intValue();
        if (bytesRead != 0) {
            if (bytesRead < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (bytesRead > head.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            buffer.skip(bytesRead);
        }
        return bytesRead;
    }

    public final int readFromHead(@NotNull Buffer buffer, @NotNull Function2<? super SegmentReadContext, ? super Segment, Integer> readAction) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(readAction, (String)"readAction");
        boolean $i$f$readFromHead = false;
        if (!(!buffer.exhausted())) {
            boolean $i$a$-require-UnsafeBufferOperations$readFromHead$32 = false;
            String $i$a$-require-UnsafeBufferOperations$readFromHead$32 = "Buffer is empty";
            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$32.toString());
        }
        Segment segment = buffer.getHead();
        Intrinsics.checkNotNull((Object)segment);
        Segment head = segment;
        int bytesRead = ((Number)readAction.invoke((Object)UnsafeBufferOperationsKt.getSegmentReadContextImpl(), (Object)head)).intValue();
        if (bytesRead != 0) {
            if (bytesRead < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (bytesRead > head.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            buffer.skip(bytesRead);
        }
        return bytesRead;
    }

    public final int writeToTail(@NotNull Buffer buffer, int minimumCapacity, @NotNull Function3<? super byte[], ? super Integer, ? super Integer, Integer> writeAction) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(writeAction, (String)"writeAction");
        boolean $i$f$writeToTail = false;
        Segment tail = buffer.writableSegment(minimumCapacity);
        byte[] data2 = tail.dataAsByteArray(false);
        int bytesWritten = ((Number)writeAction.invoke((Object)data2, (Object)tail.getLimit(), (Object)data2.length)).intValue();
        if (bytesWritten == minimumCapacity) {
            tail.writeBackData(data2, bytesWritten);
            tail.setLimit(tail.getLimit() + bytesWritten);
            buffer.setSizeMut(buffer.getSizeMut() + (long)bytesWritten);
            return bytesWritten;
        }
        if (!(0 <= bytesWritten ? bytesWritten <= tail.getRemainingCapacity() : false)) {
            boolean bl = false;
            String string = "Invalid number of bytes written: " + bytesWritten + ". Should be in 0.." + tail.getRemainingCapacity();
            throw new IllegalStateException(string.toString());
        }
        if (bytesWritten != 0) {
            tail.writeBackData(data2, bytesWritten);
            tail.setLimit(tail.getLimit() + bytesWritten);
            buffer.setSizeMut(buffer.getSizeMut() + (long)bytesWritten);
            return bytesWritten;
        }
        if (SegmentKt.isEmpty(tail)) {
            buffer.recycleTail();
        }
        return bytesWritten;
    }

    public final int writeToTail(@NotNull Buffer buffer, int minimumCapacity, @NotNull Function2<? super SegmentWriteContext, ? super Segment, Integer> writeAction) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(writeAction, (String)"writeAction");
        boolean $i$f$writeToTail = false;
        Segment tail = buffer.writableSegment(minimumCapacity);
        int bytesWritten = ((Number)writeAction.invoke((Object)UnsafeBufferOperationsKt.getSegmentWriteContextImpl(), (Object)tail)).intValue();
        if (bytesWritten == minimumCapacity) {
            tail.setLimit(tail.getLimit() + bytesWritten);
            buffer.setSizeMut(buffer.getSizeMut() + (long)bytesWritten);
            return bytesWritten;
        }
        if (!(0 <= bytesWritten ? bytesWritten <= tail.getRemainingCapacity() : false)) {
            boolean bl = false;
            String string = "Invalid number of bytes written: " + bytesWritten + ". Should be in 0.." + tail.getRemainingCapacity();
            throw new IllegalStateException(string.toString());
        }
        if (bytesWritten != 0) {
            tail.setLimit(tail.getLimit() + bytesWritten);
            buffer.setSizeMut(buffer.getSizeMut() + (long)bytesWritten);
            return bytesWritten;
        }
        if (SegmentKt.isEmpty(tail)) {
            buffer.recycleTail();
        }
        return bytesWritten;
    }

    public final void iterate(@NotNull Buffer buffer, @NotNull Function2<? super BufferIterationContext, ? super Segment, Unit> iterationAction) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(iterationAction, (String)"iterationAction");
        boolean $i$f$iterate = false;
        iterationAction.invoke((Object)UnsafeBufferOperationsKt.getBufferIterationContextImpl(), (Object)buffer.getHead());
    }

    /*
     * WARNING - void declaration
     */
    public final void iterate(@NotNull Buffer buffer, long offset, @NotNull Function3<? super BufferIterationContext, ? super Segment, ? super Long, Unit> iterationAction) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(iterationAction, (String)"iterationAction");
        boolean $i$f$iterate = false;
        if (!(offset >= 0L)) {
            boolean $i$a$-require-UnsafeBufferOperations$iterate$22 = false;
            String $i$a$-require-UnsafeBufferOperations$iterate$22 = "Offset must be non-negative: " + offset;
            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$iterate$22.toString());
        }
        if (offset >= buffer.getSize()) {
            throw new IndexOutOfBoundsException("Offset should be less than buffer's size (" + buffer.getSize() + "): " + offset);
        }
        Buffer $this$seek$iv = buffer;
        boolean $i$f$seek = false;
        if ($this$seek$iv.getHead() == null) {
            void o;
            long l = -1L;
            Object s = null;
            boolean bl = false;
            iterationAction.invoke((Object)UnsafeBufferOperationsKt.getBufferIterationContextImpl(), s, (Object)((long)o));
        } else if ($this$seek$iv.getSize() - offset < offset) {
            void o;
            Segment s$iv;
            long offset$iv = $this$seek$iv.getSize();
            for (s$iv = $this$seek$iv.getTail(); s$iv != null && offset$iv > offset && (offset$iv -= (long)(s$iv.getLimit() - s$iv.getPos())) > offset; s$iv = s$iv.getPrev()) {
            }
            long l = offset$iv;
            Segment s = s$iv;
            boolean bl = false;
            iterationAction.invoke((Object)UnsafeBufferOperationsKt.getBufferIterationContextImpl(), (Object)s, (Object)((long)o));
        } else {
            void o;
            long nextOffset$iv;
            Segment s$iv;
            long offset$iv = 0L;
            for (s$iv = $this$seek$iv.getHead(); s$iv != null && (nextOffset$iv = offset$iv + (long)(s$iv.getLimit() - s$iv.getPos())) <= offset; s$iv = s$iv.getNext()) {
                offset$iv = nextOffset$iv;
            }
            long l = offset$iv;
            Segment s = s$iv;
            boolean bl = false;
            iterationAction.invoke((Object)UnsafeBufferOperationsKt.getBufferIterationContextImpl(), (Object)s, (Object)((long)o));
        }
    }

    public final void forEachSegment(@NotNull Buffer buffer, @NotNull Function2<? super SegmentReadContext, ? super Segment, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$forEachSegment = false;
        for (Segment curr = buffer.getHead(); curr != null; curr = curr.getNext()) {
            action.invoke((Object)UnsafeBufferOperationsKt.getSegmentReadContextImpl(), (Object)curr);
        }
    }
}

