/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.files;

import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.io.CoreKt;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Paths.kt\nkotlinx/io/files/PathsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,177:1\n13402#2,2:178\n*S KotlinDebug\n*F\n+ 1 Paths.kt\nkotlinx/io/files/PathsKt\n*L\n84#1:178,2\n*E\n"})
public final class PathsKt {
    @NotNull
    public static final Path Path(@NotNull String base, String ... parts) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
        StringBuilder $this$Path_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$Path_u24lambda_u241.append(base);
        String[] $this$forEach$iv = parts;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[j];
            boolean bl2 = false;
            if (((CharSequence)$this$Path_u24lambda_u241).length() > 0 && !StringsKt.endsWith$default((CharSequence)$this$Path_u24lambda_u241, (char)PathsJvmKt.SystemPathSeparator, (boolean)false, (int)2, null)) {
                $this$Path_u24lambda_u241.append(PathsJvmKt.SystemPathSeparator);
            }
            $this$Path_u24lambda_u241.append(it);
        }
        return PathsJvmKt.Path(stringBuilder.toString());
    }

    @NotNull
    public static final Path Path(@NotNull Path base, String ... parts) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
        return PathsKt.Path(base.toString(), Arrays.copyOf(parts, parts.length));
    }

    @Deprecated(message="Use FileSystem.source instead", replaceWith=@ReplaceWith(expression="SystemFileSystem.source(this).buffered()", imports={"kotlinx.io.files.FileSystem"}), level=DeprecationLevel.WARNING)
    @JvmName(name="sourceDeprecated")
    @NotNull
    public static final Source sourceDeprecated(@NotNull Path $this$source) {
        Intrinsics.checkNotNullParameter((Object)$this$source, (String)"<this>");
        return CoreKt.buffered(FileSystemJvmKt.SystemFileSystem.source($this$source));
    }

    @Deprecated(message="Use FileSystem.sink instead", replaceWith=@ReplaceWith(expression="SystemFileSystem.sink(this).buffered()", imports={"kotlinx.io.files.FileSystem"}), level=DeprecationLevel.WARNING)
    @JvmName(name="sinkDeprecated")
    @NotNull
    public static final Sink sinkDeprecated(@NotNull Path $this$sink) {
        Intrinsics.checkNotNullParameter((Object)$this$sink, (String)"<this>");
        return CoreKt.buffered(FileSystem.sink$default(FileSystemJvmKt.SystemFileSystem, $this$sink, false, 2, null));
    }

    @NotNull
    public static final String removeTrailingSeparators(@NotNull String path2, boolean isWindows_) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        if (isWindows_) {
            int limit = path2.length() > 1 ? (path2.charAt(1) == ':' ? 3 : (PathsKt.isUnc(path2) ? 2 : 1)) : 1;
            return PathsKt.removeTrailingSeparatorsWindows(limit, path2);
        }
        return PathsKt.removeTrailingSeparatorsUnix(path2);
    }

    public static /* synthetic */ String removeTrailingSeparators$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = FileSystemJvmKt.isWindows();
        }
        return PathsKt.removeTrailingSeparators(string, bl);
    }

    private static final boolean isUnc(String path2) {
        if (path2.length() < 2) {
            return false;
        }
        if (StringsKt.startsWith$default((String)path2, (String)"\\\\", (boolean)false, (int)2, null)) {
            return true;
        }
        return StringsKt.startsWith$default((String)path2, (String)"//", (boolean)false, (int)2, null);
    }

    private static final String removeTrailingSeparatorsUnix(String path2) {
        int idx;
        for (idx = path2.length(); idx > 1 && path2.charAt(idx - 1) == '/'; --idx) {
        }
        String string = path2.substring(0, idx);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private static final String removeTrailingSeparatorsWindows(int suffixLength, String path2) {
        char c;
        int idx;
        if (!(suffixLength >= 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        for (idx = path2.length(); idx > suffixLength && ((c = path2.charAt(idx - 1)) == '\\' || c == '/'); --idx) {
        }
        String string = path2.substring(0, idx);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }
}

