/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.files.FileMetadata;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.Mover;
import kotlinx.io.files.NioMover;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import kotlinx.io.files.PathsKt;
import kotlinx.io.files.SystemFileSystemImpl;
import org.jetbrains.annotations.NotNull;

public final class FileSystemJvmKt {
    @NotNull
    private static final Lazy mover$delegate = LazyKt.lazy(FileSystemJvmKt::mover_delegate$lambda$0);
    @JvmField
    @NotNull
    public static final FileSystem SystemFileSystem = new SystemFileSystemImpl(){

        public boolean exists(Path path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return path2.getFile$kotlinx_io_core().exists();
        }

        public void delete(Path path2, boolean mustExist) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            if (!this.exists(path2)) {
                if (mustExist) {
                    throw new FileNotFoundException("File does not exist: " + path2.getFile$kotlinx_io_core());
                }
                return;
            }
            if (!path2.getFile$kotlinx_io_core().delete()) {
                throw new IOException("Deletion failed");
            }
        }

        public void createDirectories(Path path2, boolean mustCreate) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            if (!path2.getFile$kotlinx_io_core().mkdirs()) {
                if (mustCreate) {
                    throw new IOException("Path already exist: " + path2);
                }
                if (path2.getFile$kotlinx_io_core().isFile()) {
                    throw new IOException("Path already exists and it's a file: " + path2);
                }
            }
        }

        public void atomicMove(Path source, Path destination) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            FileSystemJvmKt.access$getMover().move(source, destination);
        }

        public FileMetadata metadataOrNull(Path path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            if (!path2.getFile$kotlinx_io_core().exists()) {
                return null;
            }
            return new FileMetadata(path2.getFile$kotlinx_io_core().isFile(), path2.getFile$kotlinx_io_core().isDirectory(), path2.getFile$kotlinx_io_core().isFile() ? path2.getFile$kotlinx_io_core().length() : -1L);
        }

        public RawSource source(Path path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return JvmCoreKt.asSource(new FileInputStream(path2.getFile$kotlinx_io_core()));
        }

        public RawSink sink(Path path2, boolean append) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return JvmCoreKt.asSink(new FileOutputStream(path2.getFile$kotlinx_io_core(), append));
        }

        public Path resolve(Path path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            if (!path2.getFile$kotlinx_io_core().exists()) {
                throw new FileNotFoundException(path2.getFile$kotlinx_io_core().getAbsolutePath());
            }
            File file = path2.getFile$kotlinx_io_core().getCanonicalFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCanonicalFile(...)");
            return new Path(file);
        }

        public Collection<Path> list(Path directory) {
            List list2;
            block3: {
                Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                File file = directory.getFile$kotlinx_io_core();
                if (!file.exists()) {
                    throw new FileNotFoundException(file.getAbsolutePath());
                }
                if (!file.isDirectory()) {
                    throw new IOException("Not a directory: " + file.getAbsolutePath());
                }
                List $this$list_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                String[] stringArray = file.list();
                if (stringArray == null) break block3;
                String[] $this$forEach$iv = stringArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    String element$iv;
                    String childName = element$iv = $this$forEach$iv[j];
                    boolean bl2 = false;
                    String[] stringArray2 = new String[]{childName};
                    $this$list_u24lambda_u241.add(PathsKt.Path(directory, stringArray2));
                }
            }
            return CollectionsKt.build((List)list2);
        }
    };
    @JvmField
    @NotNull
    public static final Path SystemTemporaryDirectory;
    private static final boolean isWindows;

    private static final Mover getMover() {
        Lazy lazy = mover$delegate;
        return (Mover)lazy.getValue();
    }

    public static final boolean isWindows() {
        return isWindows;
    }

    private static final Mover mover_delegate$lambda$0() {
        Mover mover2;
        try {
            Class.forName("java.nio.file.Files");
            mover2 = new NioMover();
        }
        catch (ClassNotFoundException e) {
            mover2 = new Mover(){

                public void move(Path source, Path destination) {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                    throw new UnsupportedOperationException("Atomic move not supported");
                }
            };
        }
        return mover2;
    }

    public static final /* synthetic */ Mover access$getMover() {
        return FileSystemJvmKt.getMover();
    }

    static {
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        SystemTemporaryDirectory = PathsJvmKt.Path(string);
        String string2 = System.getProperty("os.name");
        isWindows = string2 != null ? StringsKt.startsWith$default((String)string2, (String)"Windows", (boolean)false, (int)2, null) : false;
    }
}

