/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.bytestring;

import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.bytestring.ByteString;
import kotlinx.io.bytestring.ByteStringKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nByteStringBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteStringBuilder.kt\nkotlinx/io/bytestring/ByteStringBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
public final class ByteStringBuilder {
    @NotNull
    private byte[] buffer;
    private int offset;

    public ByteStringBuilder(int initialCapacity) {
        this.buffer = new byte[initialCapacity];
    }

    public /* synthetic */ ByteStringBuilder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    public final int getSize() {
        return this.offset;
    }

    public final int getCapacity() {
        return this.buffer.length;
    }

    @NotNull
    public final ByteString toByteString() {
        if (this.getSize() == 0) {
            return ByteStringKt.ByteString();
        }
        if (this.buffer.length == this.getSize()) {
            return ByteString.Companion.wrap$kotlinx_io_bytestring(this.buffer);
        }
        return new ByteString(this.buffer, 0, this.getSize());
    }

    public final void append(byte by) {
        this.ensureCapacity(this.getSize() + 1);
        int n = this.offset;
        this.offset = n + 1;
        this.buffer[n] = by;
    }

    public final void append(@NotNull byte[] array, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (!(startIndex <= endIndex)) {
            boolean bl = false;
            String string = "startIndex (" + startIndex + ") > endIndex (" + endIndex + ')';
            throw new IllegalArgumentException(string.toString());
        }
        if (startIndex < 0 || endIndex > array.length) {
            throw new IndexOutOfBoundsException("startIndex (" + startIndex + ") and endIndex (" + endIndex + ") represents an interval out of array's bounds [0.." + array.length + ").");
        }
        this.ensureCapacity(this.offset + endIndex - startIndex);
        ArraysKt.copyInto((byte[])array, (byte[])this.buffer, (int)this.offset, (int)startIndex, (int)endIndex);
        this.offset += endIndex - startIndex;
    }

    public static /* synthetic */ void append$default(ByteStringBuilder byteStringBuilder, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        byteStringBuilder.append(byArray, n, n2);
    }

    private final void ensureCapacity(int requiredCapacity) {
        if (this.buffer.length >= requiredCapacity) {
            return;
        }
        int desiredSize = this.buffer.length == 0 ? 16 : (int)((double)this.buffer.length * 1.5);
        desiredSize = Math.max(desiredSize, requiredCapacity);
        byte[] newBuffer = new byte[desiredSize];
        ArraysKt.copyInto$default((byte[])this.buffer, (byte[])newBuffer, (int)0, (int)0, (int)0, (int)14, null);
        this.buffer = newBuffer;
    }

    public ByteStringBuilder() {
        this(0, 1, null);
    }
}

