/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.CoreKt;
import kotlinx.io.InternalIoApi;
import kotlinx.io.PeekSource;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Source;
import kotlinx.io._UtilKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nRealSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealSource.kt\nkotlinx/io/RealSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -Util.kt\nkotlinx/io/_UtilKt\n*L\n1#1,162:1\n159#1:163\n160#1:165\n159#1:167\n160#1:169\n159#1:170\n160#1:172\n159#1:176\n160#1:178\n159#1:180\n160#1:182\n1#2:164\n1#2:166\n1#2:168\n1#2:171\n1#2:173\n1#2:177\n1#2:179\n1#2:181\n1#2:183\n38#3:174\n110#3:175\n*S KotlinDebug\n*F\n+ 1 RealSource.kt\nkotlinx/io/RealSource\n*L\n38#1:163\n38#1:165\n51#1:167\n51#1:169\n60#1:170\n60#1:172\n127#1:176\n127#1:178\n144#1:180\n144#1:182\n38#1:164\n51#1:168\n60#1:171\n127#1:177\n144#1:181\n74#1:174\n80#1:175\n*E\n"})
public final class RealSource
implements Source {
    @NotNull
    private final RawSource source;
    @JvmField
    public boolean closed;
    @NotNull
    private final Buffer bufferField;

    public RealSource(@NotNull RawSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.bufferField = new Buffer();
    }

    @NotNull
    public final RawSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public Buffer getBuffer() {
        return this.bufferField;
    }

    @InternalIoApi
    public static /* synthetic */ void getBuffer$annotations() {
    }

    @Override
    public long readAtMostTo(@NotNull Buffer sink, long byteCount) {
        long read2;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        RealSource this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Source is closed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        if (this.bufferField.getSize() == 0L && (read2 = this.source.readAtMostTo(this.bufferField, 8192L)) == -1L) {
            return -1L;
        }
        long toRead = Math.min(byteCount, this.bufferField.getSize());
        return this.bufferField.readAtMostTo(sink, toRead);
    }

    @Override
    public boolean exhausted() {
        RealSource this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Source is closed.";
            throw new IllegalStateException(string.toString());
        }
        return this.bufferField.exhausted() && this.source.readAtMostTo(this.bufferField, 8192L) == -1L;
    }

    @Override
    public void require(long byteCount) {
        if (!this.request(byteCount)) {
            throw new EOFException("Source doesn't contain required number of bytes (" + byteCount + ").");
        }
    }

    @Override
    public boolean request(long byteCount) {
        RealSource this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Source is closed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        while (this.bufferField.getSize() < byteCount) {
            if (this.source.readAtMostTo(this.bufferField, 8192L) != -1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte readByte() {
        this.require(1L);
        return this.bufferField.readByte();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readAtMostTo(@NotNull byte[] sink, int startIndex, int endIndex) {
        void a$iv;
        long read2;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        int size$iv = sink.length;
        int $i$f$checkBounds = 0;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        if (this.bufferField.getSize() == 0L && (read2 = this.source.readAtMostTo(this.bufferField, 8192L)) == -1L) {
            return -1;
        }
        $i$f$checkBounds = endIndex - startIndex;
        long b$iv = this.bufferField.getSize();
        boolean $i$f$minOf = false;
        int toRead = (int)Math.min((long)a$iv, b$iv);
        return this.bufferField.readAtMostTo(sink, startIndex, startIndex + toRead);
    }

    @Override
    public void readTo(@NotNull RawSink sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        try {
            this.require(byteCount);
        }
        catch (EOFException e) {
            sink.write(this.bufferField, this.bufferField.getSize());
            throw e;
        }
        this.bufferField.readTo(sink, byteCount);
    }

    @Override
    public long transferTo(@NotNull RawSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        long totalBytesWritten = 0L;
        while (this.source.readAtMostTo(this.bufferField, 8192L) != -1L) {
            long emitByteCount = this.bufferField.completeSegmentByteCount$kotlinx_io_core();
            if (emitByteCount <= 0L) continue;
            totalBytesWritten += emitByteCount;
            sink.write(this.bufferField, emitByteCount);
        }
        if (this.bufferField.getSize() > 0L) {
            totalBytesWritten += this.bufferField.getSize();
            sink.write(this.bufferField, this.bufferField.getSize());
        }
        return totalBytesWritten;
    }

    @Override
    public short readShort() {
        this.require(2L);
        return this.bufferField.readShort();
    }

    @Override
    public int readInt() {
        this.require(4L);
        return this.bufferField.readInt();
    }

    @Override
    public long readLong() {
        this.require(8L);
        return this.bufferField.readLong();
    }

    @Override
    public void skip(long byteCount) {
        long toSkip;
        RealSource this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean $i$a$-check-RealSource$checkNotClosed$1$iv22 = false;
            String $i$a$-check-RealSource$checkNotClosed$1$iv22 = "Source is closed.";
            throw new IllegalStateException($i$a$-check-RealSource$checkNotClosed$1$iv22.toString());
        }
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        for (long remainingByteCount = byteCount; remainingByteCount > 0L; remainingByteCount -= toSkip) {
            if (this.bufferField.getSize() == 0L && this.source.readAtMostTo(this.bufferField, 8192L) == -1L) {
                throw new EOFException("Source exhausted before skipping " + byteCount + " bytes (only " + (remainingByteCount - byteCount) + " bytes were skipped).");
            }
            toSkip = Math.min(remainingByteCount, this.bufferField.getSize());
            this.bufferField.skip(toSkip);
        }
    }

    @Override
    @NotNull
    public Source peek() {
        RealSource this_$iv = this;
        boolean $i$f$checkNotClosed = false;
        if (!(!this_$iv.closed)) {
            boolean bl = false;
            String string = "Source is closed.";
            throw new IllegalStateException(string.toString());
        }
        return CoreKt.buffered(new PeekSource(this));
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.source.close();
        this.bufferField.clear();
    }

    @NotNull
    public String toString() {
        return "buffered(" + this.source + ')';
    }

    private final void checkNotClosed() {
        boolean $i$f$checkNotClosed = false;
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "Source is closed.";
            throw new IllegalStateException(string.toString());
        }
    }
}

