/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.persistentOrderedMap;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.collections.AbstractMutableMap;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMap;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.LinkedValue;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMap;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMapBuilder;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMapBuilderEntries;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMapBuilderKeys;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMapBuilderValues;
import kotlinx.collections.immutable.internal.CommonFunctionsKt;
import kotlinx.collections.immutable.internal.EndOfChain;
import kotlinx.collections.immutable.internal.MapImplementation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistentOrderedMapBuilder<K, V>
extends AbstractMutableMap<K, V>
implements PersistentMap.Builder<K, V> {
    @Nullable
    private PersistentOrderedMap<K, V> builtMap;
    @Nullable
    private Object firstKey;
    @Nullable
    private Object lastKey;
    @NotNull
    private final PersistentHashMapBuilder<K, LinkedValue<V>> hashMapBuilder;

    public PersistentOrderedMapBuilder(@NotNull PersistentOrderedMap<K, V> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this.builtMap = map2;
        this.firstKey = map2.getFirstKey$kotlinx_collections_immutable();
        this.lastKey = map2.getLastKey$kotlinx_collections_immutable();
        this.hashMapBuilder = map2.getHashMap$kotlinx_collections_immutable().builder();
    }

    @Nullable
    public final Object getFirstKey$kotlinx_collections_immutable() {
        return this.firstKey;
    }

    @NotNull
    public final PersistentHashMapBuilder<K, LinkedValue<V>> getHashMapBuilder$kotlinx_collections_immutable() {
        return this.hashMapBuilder;
    }

    public int getSize() {
        return this.hashMapBuilder.size();
    }

    @Override
    @NotNull
    public PersistentMap<K, V> build() {
        PersistentMap persistentMap;
        PersistentOrderedMap<K, V> persistentOrderedMap = this.builtMap;
        if (persistentOrderedMap != null) {
            PersistentOrderedMap<K, V> persistentOrderedMap2;
            PersistentOrderedMap<K, V> map2 = persistentOrderedMap2 = persistentOrderedMap;
            boolean bl = false;
            CommonFunctionsKt.assert(this.hashMapBuilder.getBuiltMap$kotlinx_collections_immutable() != null);
            CommonFunctionsKt.assert(this.firstKey == map2.getFirstKey$kotlinx_collections_immutable());
            CommonFunctionsKt.assert(this.lastKey == map2.getLastKey$kotlinx_collections_immutable());
            persistentMap = persistentOrderedMap2;
        } else {
            PersistentOrderedMapBuilder $this$build_u24lambda_u241 = this;
            boolean bl = false;
            CommonFunctionsKt.assert($this$build_u24lambda_u241.hashMapBuilder.getBuiltMap$kotlinx_collections_immutable() == null);
            PersistentMap newHashMap = $this$build_u24lambda_u241.hashMapBuilder.build();
            PersistentOrderedMap newOrdered = new PersistentOrderedMap($this$build_u24lambda_u241.firstKey, $this$build_u24lambda_u241.lastKey, newHashMap);
            $this$build_u24lambda_u241.builtMap = newOrdered;
            persistentMap = newOrdered;
        }
        return persistentMap;
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        return (Set)((Object)new PersistentOrderedMapBuilderEntries(this));
    }

    @NotNull
    public Set<K> getKeys() {
        return new PersistentOrderedMapBuilderKeys(this);
    }

    @NotNull
    public Collection<V> getValues() {
        return new PersistentOrderedMapBuilderValues(this);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hashMapBuilder.containsKey(key);
    }

    @Override
    @Nullable
    public V get(Object key) {
        LinkedValue<V> linkedValue = this.hashMapBuilder.get(key);
        return (V)(linkedValue != null ? linkedValue.getValue() : null);
    }

    @Override
    @Nullable
    public V put(K key, V value2) {
        V v;
        LinkedValue<V> links = this.hashMapBuilder.get(key);
        if (links != null) {
            if (links.getValue() == value2) {
                v = value2;
            } else {
                this.builtMap = null;
                ((Map)this.hashMapBuilder).put(key, links.withValue(value2));
                v = links.getValue();
            }
        } else {
            this.builtMap = null;
            if (this.isEmpty()) {
                this.firstKey = key;
                this.lastKey = key;
                ((Map)this.hashMapBuilder).put(key, new LinkedValue<V>(value2));
            } else {
                Object lastKey = this.lastKey;
                LinkedValue<V> linkedValue = this.hashMapBuilder.get(lastKey);
                Intrinsics.checkNotNull(linkedValue);
                LinkedValue<V> lastLinks = linkedValue;
                CommonFunctionsKt.assert(!lastLinks.getHasNext());
                ((Map)this.hashMapBuilder).put(lastKey, lastLinks.withNext(key));
                ((Map)this.hashMapBuilder).put(key, new LinkedValue<V>(value2, lastKey));
                this.lastKey = key;
            }
            v = null;
        }
        return v;
    }

    @Override
    @Nullable
    public V remove(Object key) {
        LinkedValue<V> linkedValue = this.hashMapBuilder.remove(key);
        if (linkedValue == null) {
            return null;
        }
        LinkedValue<V> links = linkedValue;
        this.builtMap = null;
        if (links.getHasPrevious()) {
            Object v = ((Map)this.hashMapBuilder).get(links.getPrevious());
            Intrinsics.checkNotNull(v);
            LinkedValue previousLinks = (LinkedValue)v;
            ((Map)this.hashMapBuilder).put(links.getPrevious(), previousLinks.withNext(links.getNext()));
        } else {
            this.firstKey = links.getNext();
        }
        if (links.getHasNext()) {
            Object v = ((Map)this.hashMapBuilder).get(links.getNext());
            Intrinsics.checkNotNull(v);
            LinkedValue nextLinks = (LinkedValue)v;
            ((Map)this.hashMapBuilder).put(links.getNext(), nextLinks.withPrevious(links.getPrevious()));
        } else {
            this.lastKey = links.getPrevious();
        }
        return links.getValue();
    }

    @Override
    public final boolean remove(Object key, Object value2) {
        boolean bl;
        LinkedValue<V> linkedValue = this.hashMapBuilder.get(key);
        if (linkedValue == null) {
            return false;
        }
        LinkedValue<V> links = linkedValue;
        if (!Intrinsics.areEqual(links.getValue(), (Object)value2)) {
            bl = false;
        } else {
            this.remove(key);
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        if (!((Map)this.hashMapBuilder).isEmpty()) {
            this.builtMap = null;
        }
        this.hashMapBuilder.clear();
        this.firstKey = EndOfChain.INSTANCE;
        this.lastKey = EndOfChain.INSTANCE;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        if (this.size() != ((Map)other).size()) {
            return false;
        }
        Map map2 = (Map)other;
        return map2 instanceof PersistentOrderedMap ? this.hashMapBuilder.getNode$kotlinx_collections_immutable().equalsWith$kotlinx_collections_immutable(((PersistentOrderedMap)other).getHashMap$kotlinx_collections_immutable().getNode$kotlinx_collections_immutable(), equals.1.INSTANCE) : (map2 instanceof PersistentOrderedMapBuilder ? this.hashMapBuilder.getNode$kotlinx_collections_immutable().equalsWith$kotlinx_collections_immutable(((PersistentOrderedMapBuilder)other).hashMapBuilder.getNode$kotlinx_collections_immutable(), equals.2.INSTANCE) : (map2 instanceof PersistentHashMap ? this.hashMapBuilder.getNode$kotlinx_collections_immutable().equalsWith$kotlinx_collections_immutable(((PersistentHashMap)other).getNode$kotlinx_collections_immutable(), equals.3.INSTANCE) : (map2 instanceof PersistentHashMapBuilder ? this.hashMapBuilder.getNode$kotlinx_collections_immutable().equalsWith$kotlinx_collections_immutable(((PersistentHashMapBuilder)other).getNode$kotlinx_collections_immutable(), equals.4.INSTANCE) : MapImplementation.INSTANCE.equals$kotlinx_collections_immutable(this, (Map)other))));
    }

    @Override
    public int hashCode() {
        return MapImplementation.INSTANCE.hashCode$kotlinx_collections_immutable(this);
    }
}

