/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableSet;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlinx.collections.immutable.implementations.immutableSet.TrieNode;
import kotlinx.collections.immutable.implementations.immutableSet.TrieNodeIterator;
import kotlinx.collections.immutable.internal.CommonFunctionsKt;
import org.jetbrains.annotations.NotNull;

public class PersistentHashSetIterator<E>
implements Iterator<E>,
KMappedMarker {
    @NotNull
    private final List<TrieNodeIterator<E>> path;
    private int pathLastIndex;
    private boolean hasNext;

    public PersistentHashSetIterator(@NotNull TrieNode<E> node2) {
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        Object[] objectArray = new TrieNodeIterator[]{new TrieNodeIterator()};
        this.path = CollectionsKt.mutableListOf((Object[])objectArray);
        this.hasNext = true;
        TrieNodeIterator.reset$default(this.path.get(0), node2.getBuffer(), 0, 2, null);
        this.pathLastIndex = 0;
        this.ensureNextElementIsReady();
    }

    @NotNull
    protected final List<TrieNodeIterator<E>> getPath() {
        return this.path;
    }

    protected final void setPathLastIndex(int n) {
        this.pathLastIndex = n;
    }

    private final int moveToNextNodeWithData(int pathIndex) {
        if (this.path.get(pathIndex).hasNextElement()) {
            return pathIndex;
        }
        if (this.path.get(pathIndex).hasNextNode()) {
            TrieNode<E> node2 = this.path.get(pathIndex).currentNode();
            if (pathIndex + 1 == this.path.size()) {
                this.path.add(new TrieNodeIterator());
            }
            TrieNodeIterator.reset$default(this.path.get(pathIndex + 1), node2.getBuffer(), 0, 2, null);
            return this.moveToNextNodeWithData(pathIndex + 1);
        }
        return -1;
    }

    private final void ensureNextElementIsReady() {
        if (this.path.get(this.pathLastIndex).hasNextElement()) {
            return;
        }
        for (int i2 = this.pathLastIndex; -1 < i2; --i2) {
            int result2 = this.moveToNextNodeWithData(i2);
            if (result2 == -1 && this.path.get(i2).hasNextCell()) {
                this.path.get(i2).moveToNextCell();
                result2 = this.moveToNextNodeWithData(i2);
            }
            if (result2 != -1) {
                this.pathLastIndex = result2;
                return;
            }
            if (i2 > 0) {
                this.path.get(i2 - 1).moveToNextCell();
            }
            this.path.get(i2).reset(TrieNode.Companion.getEMPTY$kotlinx_collections_immutable().getBuffer(), 0);
        }
        this.hasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public E next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        E result2 = this.path.get(this.pathLastIndex).nextElement();
        this.ensureNextElementIsReady();
        return result2;
    }

    protected final E currentElement() {
        CommonFunctionsKt.assert(this.hasNext());
        return this.path.get(this.pathLastIndex).currentElement();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

