/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableMap;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlinx.collections.immutable.implementations.immutableMap.TrieNode;
import kotlinx.collections.immutable.implementations.immutableMap.TrieNodeBaseIterator;
import org.jetbrains.annotations.NotNull;

public abstract class PersistentHashMapBaseIterator<K, V, T>
implements Iterator<T>,
KMappedMarker {
    @NotNull
    private final TrieNodeBaseIterator<K, V, T>[] path;
    private int pathLastIndex;
    private boolean hasNext;

    public PersistentHashMapBaseIterator(@NotNull TrieNode<K, V> node2, @NotNull TrieNodeBaseIterator<K, V, T>[] path2) {
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        Intrinsics.checkNotNullParameter(path2, (String)"path");
        this.path = path2;
        this.hasNext = true;
        this.path[0].reset(node2.getBuffer$kotlinx_collections_immutable(), 2 * node2.entryCount$kotlinx_collections_immutable());
        this.pathLastIndex = 0;
        this.ensureNextEntryIsReady();
    }

    @NotNull
    protected final TrieNodeBaseIterator<K, V, T>[] getPath() {
        return this.path;
    }

    protected final int getPathLastIndex() {
        return this.pathLastIndex;
    }

    protected final void setPathLastIndex(int n) {
        this.pathLastIndex = n;
    }

    private final int moveToNextNodeWithData(int pathIndex) {
        if (this.path[pathIndex].hasNextKey()) {
            return pathIndex;
        }
        if (this.path[pathIndex].hasNextNode()) {
            TrieNode<K, V> node2 = this.path[pathIndex].currentNode();
            if (pathIndex == 6) {
                this.path[pathIndex + 1].reset(node2.getBuffer$kotlinx_collections_immutable(), node2.getBuffer$kotlinx_collections_immutable().length);
            } else {
                this.path[pathIndex + 1].reset(node2.getBuffer$kotlinx_collections_immutable(), 2 * node2.entryCount$kotlinx_collections_immutable());
            }
            return this.moveToNextNodeWithData(pathIndex + 1);
        }
        return -1;
    }

    private final void ensureNextEntryIsReady() {
        if (this.path[this.pathLastIndex].hasNextKey()) {
            return;
        }
        for (int i2 = this.pathLastIndex; -1 < i2; --i2) {
            int result2 = this.moveToNextNodeWithData(i2);
            if (result2 == -1 && this.path[i2].hasNextNode()) {
                this.path[i2].moveToNextNode();
                result2 = this.moveToNextNodeWithData(i2);
            }
            if (result2 != -1) {
                this.pathLastIndex = result2;
                return;
            }
            if (i2 > 0) {
                this.path[i2 - 1].moveToNextNode();
            }
            this.path[i2].reset(TrieNode.Companion.getEMPTY$kotlinx_collections_immutable().getBuffer$kotlinx_collections_immutable(), 0);
        }
        this.hasNext = false;
    }

    protected final K currentKey() {
        this.checkHasNext();
        return this.path[this.pathLastIndex].currentKey();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public T next() {
        this.checkHasNext();
        Object result2 = this.path[this.pathLastIndex].next();
        this.ensureNextEntryIsReady();
        return (T)result2;
    }

    private final void checkHasNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

