/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableMap;

import java.util.Map;
import java.util.Set;
import kotlin.PublishedApi;
import kotlin.collections.AbstractMap;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ImmutableCollection;
import kotlinx.collections.immutable.ImmutableSet;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMap;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapEntries;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapKeys;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapValues;
import kotlinx.collections.immutable.implementations.immutableMap.TrieNode;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMap;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMapBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nPersistentHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentHashMap.kt\nkotlinx/collections/immutable/implementations/immutableMap/PersistentHashMap\n+ 2 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n*L\n1#1,120:1\n53#2:121\n*S KotlinDebug\n*F\n+ 1 PersistentHashMap.kt\nkotlinx/collections/immutable/implementations/immutableMap/PersistentHashMap\n*L\n72#1:121\n*E\n"})
public final class PersistentHashMap<K, V>
extends AbstractMap<K, V>
implements PersistentMap<K, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TrieNode<K, V> node;
    private final int size;
    @NotNull
    private static final PersistentHashMap EMPTY = new PersistentHashMap(TrieNode.Companion.getEMPTY$kotlinx_collections_immutable(), 0);

    public PersistentHashMap(@NotNull TrieNode<K, V> node2, int size) {
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        this.node = node2;
        this.size = size;
    }

    @NotNull
    public final TrieNode<K, V> getNode$kotlinx_collections_immutable() {
        return this.node;
    }

    public int getSize() {
        return this.size;
    }

    @NotNull
    public ImmutableSet<K> getKeys() {
        return new PersistentHashMapKeys(this);
    }

    @NotNull
    public ImmutableCollection<V> getValues() {
        return new PersistentHashMapValues(this);
    }

    private final ImmutableSet<Map.Entry<K, V>> createEntries() {
        return new PersistentHashMapEntries(this);
    }

    @PublishedApi
    @NotNull
    public final Set<Map.Entry<K, V>> getEntries() {
        return this.createEntries();
    }

    @Override
    public boolean containsKey(Object key) {
        Object object = key;
        return this.node.containsKey(object != null ? object.hashCode() : 0, key, 0);
    }

    @Override
    @Nullable
    public V get(Object key) {
        Object object = key;
        return this.node.get(object != null ? object.hashCode() : 0, key, 0);
    }

    @Override
    @NotNull
    public PersistentHashMap<K, V> put(K key, V value2) {
        K k = key;
        TrieNode.ModificationResult<K, V> modificationResult = this.node.put(k != null ? k.hashCode() : 0, key, value2, 0);
        if (modificationResult == null) {
            return this;
        }
        TrieNode.ModificationResult<K, V> newNodeResult = modificationResult;
        return new PersistentHashMap<K, V>(newNodeResult.getNode(), this.size() + newNodeResult.getSizeDelta());
    }

    @Override
    @NotNull
    public PersistentHashMap<K, V> remove(K key) {
        K k = key;
        TrieNode<K, V> newNode = this.node.remove(k != null ? k.hashCode() : 0, key, 0);
        if (this.node == newNode) {
            return this;
        }
        if (newNode == null) {
            return Companion.emptyOf$kotlinx_collections_immutable();
        }
        return new PersistentHashMap<K, V>(newNode, this.size() - 1);
    }

    @NotNull
    public PersistentMap<K, V> putAll(@NotNull Map<? extends K, ? extends V> m) {
        Intrinsics.checkNotNullParameter(m, (String)"m");
        if (m.isEmpty()) {
            return this;
        }
        PersistentMap $this$mutate$iv = this;
        boolean $i$f$mutate = false;
        Intrinsics.checkNotNull((Object)$this$mutate$iv, (String)"null cannot be cast to non-null type kotlinx.collections.immutable.PersistentMap<K of kotlinx.collections.immutable.ExtensionsKt.mutate, V of kotlinx.collections.immutable.ExtensionsKt.mutate>");
        PersistentMap.Builder builder = $this$mutate$iv.builder();
        Map it = builder;
        boolean bl = false;
        it.putAll(m);
        return builder.build();
    }

    @Override
    @NotNull
    public PersistentHashMapBuilder<K, V> builder() {
        return new PersistentHashMapBuilder(this);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        if (this.size() != ((Map)other).size()) {
            return false;
        }
        Map map2 = (Map)other;
        return map2 instanceof PersistentOrderedMap ? this.node.equalsWith$kotlinx_collections_immutable(((PersistentOrderedMap)other).getHashMap$kotlinx_collections_immutable().node, equals.1.INSTANCE) : (map2 instanceof PersistentOrderedMapBuilder ? this.node.equalsWith$kotlinx_collections_immutable(((PersistentOrderedMapBuilder)other).getHashMapBuilder$kotlinx_collections_immutable().getNode$kotlinx_collections_immutable(), equals.2.INSTANCE) : (map2 instanceof PersistentHashMap ? this.node.equalsWith$kotlinx_collections_immutable(((PersistentHashMap)other).node, equals.3.INSTANCE) : (map2 instanceof PersistentHashMapBuilder ? this.node.equalsWith$kotlinx_collections_immutable(((PersistentHashMapBuilder)other).getNode$kotlinx_collections_immutable(), equals.4.INSTANCE) : super.equals(other))));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <K, V> PersistentHashMap<K, V> emptyOf$kotlinx_collections_immutable() {
            PersistentHashMap persistentHashMap = EMPTY;
            Intrinsics.checkNotNull((Object)persistentHashMap, (String)"null cannot be cast to non-null type kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMap<K of kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMap.Companion.emptyOf, V of kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMap.Companion.emptyOf>");
            return persistentHashMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

