/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;

class Log4J2Logger
extends ExtendedLoggerWrapper
implements InternalLogger {
    private static final boolean VARARGS_ONLY = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                Logger.class.getMethod("debug", String.class, Object.class);
                return false;
            }
            catch (NoSuchMethodException ignore) {
                return true;
            }
            catch (SecurityException ignore) {
                return false;
            }
        }
    });

    Log4J2Logger(Logger logger) {
        super((ExtendedLogger)logger, logger.getName(), logger.getMessageFactory());
        if (VARARGS_ONLY) {
            throw new UnsupportedOperationException("Log4J2 version mismatch");
        }
    }

    @Override
    public void warn(Throwable t2) {
        this.log(Level.WARN, "Unexpected exception:", t2);
    }

    @Override
    public boolean isEnabled(InternalLogLevel level) {
        return this.isEnabled(Log4J2Logger.toLevel(level));
    }

    @Override
    public void log(InternalLogLevel level, String msg) {
        this.log(Log4J2Logger.toLevel(level), msg);
    }

    @Override
    public void log(InternalLogLevel level, String msg, Throwable t2) {
        this.log(Log4J2Logger.toLevel(level), msg, t2);
    }

    private static Level toLevel(InternalLogLevel level) {
        switch (level) {
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case TRACE: {
                return Level.TRACE;
            }
        }
        throw new Error();
    }
}

