/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

public final class MathUtil {
    private MathUtil() {
    }

    public static int findNextPositivePowerOfTwo(int value2) {
        assert (value2 > Integer.MIN_VALUE && value2 < 0x40000000);
        return 1 << 32 - Integer.numberOfLeadingZeros(value2 - 1);
    }

    public static int safeFindNextPositivePowerOfTwo(int value2) {
        return value2 <= 0 ? 1 : (value2 >= 0x40000000 ? 0x40000000 : MathUtil.findNextPositivePowerOfTwo(value2));
    }

    public static boolean isOutOfBounds(int index, int length, int capacity) {
        return (index | length | capacity | index + length | capacity - (index + length)) < 0;
    }
}

