/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpConstants;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryStringDecoder {
    private final Charset charset;
    private final String uri;
    private final int maxParams;
    private final boolean semicolonIsNormalChar;
    private int pathEndIdx;
    private Map<String, List<String>> params;

    public QueryStringDecoder(String uri) {
        this(uri, HttpConstants.DEFAULT_CHARSET);
    }

    public QueryStringDecoder(String uri, Charset charset) {
        this(uri, charset, true);
    }

    public QueryStringDecoder(String uri, Charset charset, boolean hasPath) {
        this(uri, charset, hasPath, 1024);
    }

    public QueryStringDecoder(String uri, Charset charset, boolean hasPath, int maxParams) {
        this(uri, charset, hasPath, maxParams, false);
    }

    public QueryStringDecoder(String uri, Charset charset, boolean hasPath, int maxParams, boolean semicolonIsNormalChar) {
        this.uri = ObjectUtil.checkNotNull(uri, "uri");
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
        this.maxParams = ObjectUtil.checkPositive(maxParams, "maxParams");
        this.semicolonIsNormalChar = semicolonIsNormalChar;
        this.pathEndIdx = hasPath ? -1 : 0;
    }

    public String toString() {
        return this.uri();
    }

    public String uri() {
        return this.uri;
    }

    public Map<String, List<String>> parameters() {
        if (this.params == null) {
            this.params = QueryStringDecoder.decodeParams(this.uri, this.pathEndIdx(), this.charset, this.maxParams, this.semicolonIsNormalChar);
        }
        return this.params;
    }

    private int pathEndIdx() {
        if (this.pathEndIdx == -1) {
            this.pathEndIdx = QueryStringDecoder.findPathEndIndex(this.uri);
        }
        return this.pathEndIdx;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Map<String, List<String>> decodeParams(String s, int from, Charset charset, int paramsLimit, boolean semicolonIsNormalChar) {
        int i2;
        int len = s.length();
        if (from >= len) {
            return Collections.emptyMap();
        }
        if (s.charAt(from) == '?') {
            ++from;
        }
        LinkedHashMap<String, List<String>> params2 = new LinkedHashMap<String, List<String>>();
        int nameStart = from;
        int valueStart = -1;
        block6: for (i2 = from; i2 < len; ++i2) {
            switch (s.charAt(i2)) {
                case '=': {
                    if (nameStart == i2) {
                        nameStart = i2 + 1;
                        break;
                    }
                    if (valueStart >= nameStart) break;
                    valueStart = i2 + 1;
                    break;
                }
                case ';': {
                    if (semicolonIsNormalChar) break;
                }
                case '&': {
                    if (QueryStringDecoder.addParam(s, nameStart, valueStart, i2, params2, charset) && --paramsLimit == 0) {
                        return params2;
                    }
                    nameStart = i2 + 1;
                    break;
                }
                case '#': {
                    break block6;
                }
            }
        }
        QueryStringDecoder.addParam(s, nameStart, valueStart, i2, params2, charset);
        return params2;
    }

    private static boolean addParam(String s, int nameStart, int valueStart, int valueEnd, Map<String, List<String>> params2, Charset charset) {
        if (nameStart >= valueEnd) {
            return false;
        }
        if (valueStart <= nameStart) {
            valueStart = valueEnd + 1;
        }
        String name2 = QueryStringDecoder.decodeComponent(s, nameStart, valueStart - 1, charset, false);
        String value2 = QueryStringDecoder.decodeComponent(s, valueStart, valueEnd, charset, false);
        List<String> values = params2.get(name2);
        if (values == null) {
            values = new ArrayList<String>(1);
            params2.put(name2, values);
        }
        values.add(value2);
        return true;
    }

    private static String decodeComponent(String s, int from, int toExcluded, Charset charset, boolean isPath) {
        int len = toExcluded - from;
        if (len <= 0) {
            return "";
        }
        int firstEscaped = -1;
        for (int i2 = from; i2 < toExcluded; ++i2) {
            char c = s.charAt(i2);
            if (c != '%' && (c != '+' || isPath)) continue;
            firstEscaped = i2;
            break;
        }
        if (firstEscaped == -1) {
            return s.substring(from, toExcluded);
        }
        int decodedCapacity = (toExcluded - firstEscaped) / 3;
        byte[] buf = PlatformDependent.allocateUninitializedArray(decodedCapacity);
        StringBuilder strBuf = new StringBuilder(len);
        strBuf.append(s, from, firstEscaped);
        for (int i3 = firstEscaped; i3 < toExcluded; ++i3) {
            char c = s.charAt(i3);
            if (c != '%') {
                strBuf.append(c != '+' || isPath ? c : (char)' ');
                continue;
            }
            int bufIdx = 0;
            do {
                if (i3 + 3 > toExcluded) {
                    throw new IllegalArgumentException("unterminated escape sequence at index " + i3 + " of: " + s);
                }
                buf[bufIdx++] = StringUtil.decodeHexByte(s, i3 + 1);
            } while ((i3 += 3) < toExcluded && s.charAt(i3) == '%');
            --i3;
            strBuf.append(new String(buf, 0, bufIdx, charset));
        }
        return strBuf.toString();
    }

    private static int findPathEndIndex(String uri) {
        int len = uri.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = uri.charAt(i2);
            if (c != '?' && c != '#') continue;
            return i2;
        }
        return len;
    }
}

