/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.AsciiString;

public final class HttpHeaderValidationUtil {
    public static int validateValidHeaderValue(CharSequence value2) {
        int length = value2.length();
        if (length == 0) {
            return -1;
        }
        if (value2 instanceof AsciiString) {
            return HttpHeaderValidationUtil.verifyValidHeaderValueAsciiString((AsciiString)value2);
        }
        return HttpHeaderValidationUtil.verifyValidHeaderValueCharSequence(value2);
    }

    private static int verifyValidHeaderValueAsciiString(AsciiString value2) {
        int start2;
        byte[] array = value2.array();
        int b = array[start2 = value2.arrayOffset()] & 0xFF;
        if (b < 33 || b == 127) {
            return 0;
        }
        int length = value2.length();
        for (int i2 = start2 + 1; i2 < length; ++i2) {
            b = array[i2] & 0xFF;
            if ((b >= 32 || b == 9) && b != 127) continue;
            return i2 - start2;
        }
        return -1;
    }

    private static int verifyValidHeaderValueCharSequence(CharSequence value2) {
        char b = value2.charAt(0);
        if (b < '!' || b == '\u007f') {
            return 0;
        }
        int length = value2.length();
        for (int i2 = 1; i2 < length; ++i2) {
            b = value2.charAt(i2);
            if ((b >= ' ' || b == '\t') && b != '\u007f') continue;
            return i2;
        }
        return -1;
    }

    public static int validateToken(CharSequence token2) {
        return HttpUtil.validateToken(token2);
    }
}

