/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.base64;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;

public final class Base64 {
    private static byte[] alphabet(Base64Dialect dialect) {
        return ObjectUtil.checkNotNull(dialect, (String)"dialect").alphabet;
    }

    public static ByteBuf encode(ByteBuf src, int off, int len, boolean breakLines, Base64Dialect dialect, ByteBufAllocator allocator) {
        ObjectUtil.checkNotNull(src, "src");
        ObjectUtil.checkNotNull(dialect, "dialect");
        ByteBuf dest = allocator.buffer(Base64.encodedBufferSize(len, breakLines)).order(src.order());
        byte[] alphabet = Base64.alphabet(dialect);
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        int lineLength = 0;
        while (d < len2) {
            Base64.encode3to4(src, d + off, 3, dest, e, alphabet);
            if (breakLines && (lineLength += 4) == 76) {
                dest.setByte(e + 4, 10);
                ++e;
                lineLength = 0;
            }
            d += 3;
            e += 4;
        }
        if (d < len) {
            Base64.encode3to4(src, d + off, len - d, dest, e, alphabet);
            e += 4;
        }
        if (e > 1 && dest.getByte(e - 1) == 10) {
            --e;
        }
        return dest.slice(0, e);
    }

    private static void encode3to4(ByteBuf src, int srcOffset, int numSigBytes, ByteBuf dest, int destOffset, byte[] alphabet) {
        if (src.order() == ByteOrder.BIG_ENDIAN) {
            int inBuff;
            switch (numSigBytes) {
                case 1: {
                    inBuff = Base64.toInt(src.getByte(srcOffset));
                    break;
                }
                case 2: {
                    inBuff = Base64.toIntBE(src.getShort(srcOffset));
                    break;
                }
                default: {
                    inBuff = numSigBytes <= 0 ? 0 : Base64.toIntBE(src.getMedium(srcOffset));
                }
            }
            Base64.encode3to4BigEndian(inBuff, numSigBytes, dest, destOffset, alphabet);
        } else {
            int inBuff;
            switch (numSigBytes) {
                case 1: {
                    inBuff = Base64.toInt(src.getByte(srcOffset));
                    break;
                }
                case 2: {
                    inBuff = Base64.toIntLE(src.getShort(srcOffset));
                    break;
                }
                default: {
                    inBuff = numSigBytes <= 0 ? 0 : Base64.toIntLE(src.getMedium(srcOffset));
                }
            }
            Base64.encode3to4LittleEndian(inBuff, numSigBytes, dest, destOffset, alphabet);
        }
    }

    static int encodedBufferSize(int len, boolean breakLines) {
        long len43 = ((long)len << 2) / 3L;
        long ret = len43 + 3L & 0xFFFFFFFFFFFFFFFCL;
        if (breakLines) {
            ret += len43 / 76L;
        }
        return ret < Integer.MAX_VALUE ? (int)ret : Integer.MAX_VALUE;
    }

    private static int toInt(byte value2) {
        return (value2 & 0xFF) << 16;
    }

    private static int toIntBE(short value2) {
        return (value2 & 0xFF00) << 8 | (value2 & 0xFF) << 8;
    }

    private static int toIntLE(short value2) {
        return (value2 & 0xFF) << 16 | value2 & 0xFF00;
    }

    private static int toIntBE(int mediumValue) {
        return mediumValue & 0xFF0000 | mediumValue & 0xFF00 | mediumValue & 0xFF;
    }

    private static int toIntLE(int mediumValue) {
        return (mediumValue & 0xFF) << 16 | mediumValue & 0xFF00 | (mediumValue & 0xFF0000) >>> 16;
    }

    private static void encode3to4BigEndian(int inBuff, int numSigBytes, ByteBuf dest, int destOffset, byte[] alphabet) {
        switch (numSigBytes) {
            case 3: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] << 24 | alphabet[inBuff >>> 12 & 0x3F] << 16 | alphabet[inBuff >>> 6 & 0x3F] << 8 | alphabet[inBuff & 0x3F]);
                break;
            }
            case 2: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] << 24 | alphabet[inBuff >>> 12 & 0x3F] << 16 | alphabet[inBuff >>> 6 & 0x3F] << 8 | 0x3D);
                break;
            }
            case 1: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] << 24 | alphabet[inBuff >>> 12 & 0x3F] << 16 | 0x3D00 | 0x3D);
                break;
            }
        }
    }

    private static void encode3to4LittleEndian(int inBuff, int numSigBytes, ByteBuf dest, int destOffset, byte[] alphabet) {
        switch (numSigBytes) {
            case 3: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] | alphabet[inBuff >>> 12 & 0x3F] << 8 | alphabet[inBuff >>> 6 & 0x3F] << 16 | alphabet[inBuff & 0x3F] << 24);
                break;
            }
            case 2: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] | alphabet[inBuff >>> 12 & 0x3F] << 8 | alphabet[inBuff >>> 6 & 0x3F] << 16 | 0x3D000000);
                break;
            }
            case 1: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] | alphabet[inBuff >>> 12 & 0x3F] << 8 | 0x3D0000 | 0x3D000000);
                break;
            }
        }
    }
}

