/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.EventLoop;
import io.netty.channel.IoEventLoop;
import io.netty.channel.IoEventLoopGroup;
import io.netty.channel.IoHandler;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.SingleThreadIoEventLoop;
import io.netty.util.internal.EmptyArrays;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public class MultiThreadIoEventLoopGroup
extends MultithreadEventLoopGroup
implements IoEventLoopGroup {
    public MultiThreadIoEventLoopGroup(int nThreads, ThreadFactory threadFactory, IoHandlerFactory ioHandlerFactory) {
        super(nThreads, threadFactory, ioHandlerFactory);
    }

    protected MultiThreadIoEventLoopGroup(int nThreads, Executor executor, IoHandlerFactory ioHandlerFactory, Object ... args) {
        super(nThreads, executor, MultiThreadIoEventLoopGroup.combine(ioHandlerFactory, args));
    }

    protected MultiThreadIoEventLoopGroup(int nThreads, ThreadFactory threadFactory, IoHandlerFactory ioHandlerFactory, Object ... args) {
        super(nThreads, threadFactory, MultiThreadIoEventLoopGroup.combine(ioHandlerFactory, args));
    }

    @Override
    protected EventLoop newChild(Executor executor, Object ... args) throws Exception {
        Object[] argsCopy;
        IoHandlerFactory handlerFactory = (IoHandlerFactory)args[0];
        if (args.length > 1) {
            argsCopy = new Object[args.length - 1];
            System.arraycopy(args, 1, argsCopy, 0, argsCopy.length);
        } else {
            argsCopy = EmptyArrays.EMPTY_OBJECTS;
        }
        return this.newChild(executor, handlerFactory.newHandler(), argsCopy);
    }

    protected IoEventLoop newChild(Executor executor, IoHandler ioHandler, Object ... args) {
        return new SingleThreadIoEventLoop(this, executor, ioHandler);
    }

    @Override
    public IoEventLoop next() {
        return (IoEventLoop)super.next();
    }

    private static Object[] combine(IoHandlerFactory handlerFactory, Object ... args) {
        ArrayList<IoHandlerFactory> combinedList = new ArrayList<IoHandlerFactory>();
        combinedList.add(handlerFactory);
        if (args != null) {
            Collections.addAll(combinedList, args);
        }
        return combinedList.toArray(new Object[0]);
    }
}

