/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.buffer.UnsafeDirectSwappedByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

public class UnpooledUnsafeDirectByteBuf
extends UnpooledDirectByteBuf {
    long memoryAddress;

    public UnpooledUnsafeDirectByteBuf(ByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
        super(alloc, initialCapacity, maxCapacity);
    }

    @Override
    final void setByteBuffer(ByteBuffer buffer, boolean tryFree) {
        super.setByteBuffer(buffer, tryFree);
        this.memoryAddress = PlatformDependent.directBufferAddress(buffer);
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    @Override
    public byte getByte(int index) {
        this.checkIndex(index);
        return this._getByte(index);
    }

    @Override
    protected byte _getByte(int index) {
        return UnsafeByteBufUtil.getByte(this.addr(index));
    }

    @Override
    public short getShort(int index) {
        this.checkIndex(index, 2);
        return this._getShort(index);
    }

    @Override
    protected short _getShort(int index) {
        return UnsafeByteBufUtil.getShort(this.addr(index));
    }

    @Override
    protected short _getShortLE(int index) {
        return UnsafeByteBufUtil.getShortLE(this.addr(index));
    }

    @Override
    public int getUnsignedMedium(int index) {
        this.checkIndex(index, 3);
        return this._getUnsignedMedium(index);
    }

    @Override
    protected int _getUnsignedMedium(int index) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(index));
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index, 4);
        return this._getInt(index);
    }

    @Override
    protected int _getInt(int index) {
        return UnsafeByteBufUtil.getInt(this.addr(index));
    }

    @Override
    protected int _getIntLE(int index) {
        return UnsafeByteBufUtil.getIntLE(this.addr(index));
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index, 8);
        return this._getLong(index);
    }

    @Override
    protected long _getLong(int index) {
        return UnsafeByteBufUtil.getLong(this.addr(index));
    }

    @Override
    protected long _getLongLE(int index) {
        return UnsafeByteBufUtil.getLongLE(this.addr(index));
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(index), index, dst, dstIndex, length);
        return this;
    }

    @Override
    void getBytes(int index, byte[] dst, int dstIndex, int length, boolean internal) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(index), index, dst, dstIndex, length);
    }

    @Override
    void getBytes(int index, ByteBuffer dst, boolean internal) {
        UnsafeByteBufUtil.getBytes(this, this.addr(index), index, dst);
    }

    @Override
    public ByteBuf setByte(int index, int value2) {
        this.checkIndex(index);
        this._setByte(index, value2);
        return this;
    }

    @Override
    protected void _setByte(int index, int value2) {
        UnsafeByteBufUtil.setByte(this.addr(index), value2);
    }

    @Override
    public ByteBuf setShort(int index, int value2) {
        this.checkIndex(index, 2);
        this._setShort(index, value2);
        return this;
    }

    @Override
    protected void _setShort(int index, int value2) {
        UnsafeByteBufUtil.setShort(this.addr(index), value2);
    }

    @Override
    public ByteBuf setMedium(int index, int value2) {
        this.checkIndex(index, 3);
        this._setMedium(index, value2);
        return this;
    }

    @Override
    protected void _setMedium(int index, int value2) {
        UnsafeByteBufUtil.setMedium(this.addr(index), value2);
    }

    @Override
    public ByteBuf setInt(int index, int value2) {
        this.checkIndex(index, 4);
        this._setInt(index, value2);
        return this;
    }

    @Override
    protected void _setInt(int index, int value2) {
        UnsafeByteBufUtil.setInt(this.addr(index), value2);
    }

    @Override
    public ByteBuf setLong(int index, long value2) {
        this.checkIndex(index, 8);
        this._setLong(index, value2);
        return this;
    }

    @Override
    protected void _setLong(int index, long value2) {
        UnsafeByteBufUtil.setLong(this.addr(index), value2);
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(index), index, src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(index), index, src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        UnsafeByteBufUtil.setBytes(this, this.addr(index), index, src);
        return this;
    }

    final long addr(int index) {
        return this.memoryAddress + (long)index;
    }

    @Override
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    @Override
    public ByteBuf setZero(int index, int length) {
        this.checkIndex(index, length);
        UnsafeByteBufUtil.setZero(this.addr(index), length);
        return this;
    }
}

