/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.AdaptiveByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.Recycler;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SWARUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public final class ByteBufUtil {
    private static final InternalLogger logger;
    private static final FastThreadLocal<byte[]> BYTE_ARRAYS;
    private static final int MAX_CHAR_BUFFER_SIZE;
    private static final int THREAD_LOCAL_BUFFER_SIZE;
    private static final int MAX_BYTES_PER_CHAR_UTF8;
    static final ByteBufAllocator DEFAULT_ALLOCATOR;
    private static final ByteProcessor FIND_NON_ASCII;

    static byte[] threadLocalTempArray(int minLength) {
        return minLength <= 1024 ? BYTE_ARRAYS.get() : PlatformDependent.allocateUninitializedArray(minLength);
    }

    public static boolean isAccessible(ByteBuf buffer) {
        return buffer.isAccessible();
    }

    public static ByteBuf ensureAccessible(ByteBuf buffer) {
        if (!buffer.isAccessible()) {
            throw new IllegalReferenceCountException(buffer.refCnt());
        }
        return buffer;
    }

    public static String hexDump(byte[] array, int fromIndex, int length) {
        return HexUtil.hexDump(array, fromIndex, length);
    }

    public static int hashCode(ByteBuf buffer) {
        int i2;
        int aLen = buffer.readableBytes();
        int intCount = aLen >>> 2;
        int byteCount = aLen & 3;
        int hashCode = 1;
        int arrayIndex = buffer.readerIndex();
        if (buffer.order() == ByteOrder.BIG_ENDIAN) {
            for (i2 = intCount; i2 > 0; --i2) {
                hashCode = 31 * hashCode + buffer.getInt(arrayIndex);
                arrayIndex += 4;
            }
        } else {
            for (i2 = intCount; i2 > 0; --i2) {
                hashCode = 31 * hashCode + ByteBufUtil.swapInt(buffer.getInt(arrayIndex));
                arrayIndex += 4;
            }
        }
        for (i2 = byteCount; i2 > 0; --i2) {
            hashCode = 31 * hashCode + buffer.getByte(arrayIndex++);
        }
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    public static boolean equals(ByteBuf a, int aStartIndex, ByteBuf b, int bStartIndex, int length) {
        int i2;
        ObjectUtil.checkNotNull(a, "a");
        ObjectUtil.checkNotNull(b, "b");
        ObjectUtil.checkPositiveOrZero(aStartIndex, "aStartIndex");
        ObjectUtil.checkPositiveOrZero(bStartIndex, "bStartIndex");
        ObjectUtil.checkPositiveOrZero(length, "length");
        if (a.writerIndex() - length < aStartIndex || b.writerIndex() - length < bStartIndex) {
            return false;
        }
        int longCount = length >>> 3;
        int byteCount = length & 7;
        if (a.order() == b.order()) {
            for (i2 = longCount; i2 > 0; --i2) {
                if (a.getLong(aStartIndex) != b.getLong(bStartIndex)) {
                    return false;
                }
                aStartIndex += 8;
                bStartIndex += 8;
            }
        } else {
            for (i2 = longCount; i2 > 0; --i2) {
                if (a.getLong(aStartIndex) != ByteBufUtil.swapLong(b.getLong(bStartIndex))) {
                    return false;
                }
                aStartIndex += 8;
                bStartIndex += 8;
            }
        }
        for (i2 = byteCount; i2 > 0; --i2) {
            if (a.getByte(aStartIndex) != b.getByte(bStartIndex)) {
                return false;
            }
            ++aStartIndex;
            ++bStartIndex;
        }
        return true;
    }

    public static boolean equals(ByteBuf bufferA, ByteBuf bufferB) {
        if (bufferA == bufferB) {
            return true;
        }
        int aLen = bufferA.readableBytes();
        if (aLen != bufferB.readableBytes()) {
            return false;
        }
        return ByteBufUtil.equals(bufferA, bufferA.readerIndex(), bufferB, bufferB.readerIndex(), aLen);
    }

    public static int compare(ByteBuf bufferA, ByteBuf bufferB) {
        if (bufferA == bufferB) {
            return 0;
        }
        int aLen = bufferA.readableBytes();
        int bLen = bufferB.readableBytes();
        int minLength = Math.min(aLen, bLen);
        int uintCount = minLength >>> 2;
        int byteCount = minLength & 3;
        int aIndex = bufferA.readerIndex();
        int bIndex = bufferB.readerIndex();
        if (uintCount > 0) {
            long res2;
            boolean bufferAIsBigEndian = bufferA.order() == ByteOrder.BIG_ENDIAN;
            int uintCountIncrement = uintCount << 2;
            if (bufferA.order() == bufferB.order()) {
                res2 = bufferAIsBigEndian ? ByteBufUtil.compareUintBigEndian(bufferA, bufferB, aIndex, bIndex, uintCountIncrement) : ByteBufUtil.compareUintLittleEndian(bufferA, bufferB, aIndex, bIndex, uintCountIncrement);
            } else {
                long l = res2 = bufferAIsBigEndian ? ByteBufUtil.compareUintBigEndianA(bufferA, bufferB, aIndex, bIndex, uintCountIncrement) : ByteBufUtil.compareUintBigEndianB(bufferA, bufferB, aIndex, bIndex, uintCountIncrement);
            }
            if (res2 != 0L) {
                return (int)Math.min(Integer.MAX_VALUE, Math.max(Integer.MIN_VALUE, res2));
            }
            aIndex += uintCountIncrement;
            bIndex += uintCountIncrement;
        }
        int aEnd = aIndex + byteCount;
        while (aIndex < aEnd) {
            int comp = bufferA.getUnsignedByte(aIndex) - bufferB.getUnsignedByte(bIndex);
            if (comp != 0) {
                return comp;
            }
            ++aIndex;
            ++bIndex;
        }
        return aLen - bLen;
    }

    private static long compareUintBigEndian(ByteBuf bufferA, ByteBuf bufferB, int aIndex, int bIndex, int uintCountIncrement) {
        int aEnd = aIndex + uintCountIncrement;
        while (aIndex < aEnd) {
            long comp = bufferA.getUnsignedInt(aIndex) - bufferB.getUnsignedInt(bIndex);
            if (comp != 0L) {
                return comp;
            }
            aIndex += 4;
            bIndex += 4;
        }
        return 0L;
    }

    private static long compareUintLittleEndian(ByteBuf bufferA, ByteBuf bufferB, int aIndex, int bIndex, int uintCountIncrement) {
        int aEnd = aIndex + uintCountIncrement;
        while (aIndex < aEnd) {
            long comp = ByteBufUtil.uintFromLE(bufferA.getUnsignedIntLE(aIndex)) - ByteBufUtil.uintFromLE(bufferB.getUnsignedIntLE(bIndex));
            if (comp != 0L) {
                return comp;
            }
            aIndex += 4;
            bIndex += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianA(ByteBuf bufferA, ByteBuf bufferB, int aIndex, int bIndex, int uintCountIncrement) {
        int aEnd = aIndex + uintCountIncrement;
        while (aIndex < aEnd) {
            long b;
            long a = bufferA.getUnsignedInt(aIndex);
            long comp = a - (b = ByteBufUtil.uintFromLE(bufferB.getUnsignedIntLE(bIndex)));
            if (comp != 0L) {
                return comp;
            }
            aIndex += 4;
            bIndex += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianB(ByteBuf bufferA, ByteBuf bufferB, int aIndex, int bIndex, int uintCountIncrement) {
        int aEnd = aIndex + uintCountIncrement;
        while (aIndex < aEnd) {
            long b;
            long a = ByteBufUtil.uintFromLE(bufferA.getUnsignedIntLE(aIndex));
            long comp = a - (b = bufferB.getUnsignedInt(bIndex));
            if (comp != 0L) {
                return comp;
            }
            aIndex += 4;
            bIndex += 4;
        }
        return 0L;
    }

    private static long uintFromLE(long value2) {
        return Long.reverseBytes(value2) >>> 32;
    }

    private static int unrolledFirstIndexOf(AbstractByteBuf buffer, int fromIndex, int byteCount, byte value2) {
        assert (byteCount > 0 && byteCount < 8);
        if (buffer._getByte(fromIndex) == value2) {
            return fromIndex;
        }
        if (byteCount == 1) {
            return -1;
        }
        if (buffer._getByte(fromIndex + 1) == value2) {
            return fromIndex + 1;
        }
        if (byteCount == 2) {
            return -1;
        }
        if (buffer._getByte(fromIndex + 2) == value2) {
            return fromIndex + 2;
        }
        if (byteCount == 3) {
            return -1;
        }
        if (buffer._getByte(fromIndex + 3) == value2) {
            return fromIndex + 3;
        }
        if (byteCount == 4) {
            return -1;
        }
        if (buffer._getByte(fromIndex + 4) == value2) {
            return fromIndex + 4;
        }
        if (byteCount == 5) {
            return -1;
        }
        if (buffer._getByte(fromIndex + 5) == value2) {
            return fromIndex + 5;
        }
        if (byteCount == 6) {
            return -1;
        }
        if (buffer._getByte(fromIndex + 6) == value2) {
            return fromIndex + 6;
        }
        return -1;
    }

    static int firstIndexOf(AbstractByteBuf buffer, int fromIndex, int toIndex, byte value2) {
        if ((fromIndex = Math.max(fromIndex, 0)) >= toIndex || buffer.capacity() == 0) {
            return -1;
        }
        int length = toIndex - fromIndex;
        buffer.checkIndex(fromIndex, length);
        if (!PlatformDependent.isUnaligned()) {
            return ByteBufUtil.linearFirstIndexOf(buffer, fromIndex, toIndex, value2);
        }
        assert (PlatformDependent.isUnaligned());
        int offset = fromIndex;
        int byteCount = length & 7;
        if (byteCount > 0) {
            int index = ByteBufUtil.unrolledFirstIndexOf(buffer, fromIndex, byteCount, value2);
            if (index != -1) {
                return index;
            }
            if ((offset += byteCount) == toIndex) {
                return -1;
            }
        }
        int longCount = length >>> 3;
        ByteOrder nativeOrder = ByteOrder.nativeOrder();
        boolean isNative = nativeOrder == buffer.order();
        boolean useLE = nativeOrder == ByteOrder.LITTLE_ENDIAN;
        long pattern = SWARUtil.compilePattern(value2);
        for (int i2 = 0; i2 < longCount; ++i2) {
            long word = useLE ? buffer._getLongLE(offset) : buffer._getLong(offset);
            long result2 = SWARUtil.applyPattern(word, pattern);
            if (result2 != 0L) {
                return offset + SWARUtil.getIndex(result2, isNative);
            }
            offset += 8;
        }
        return -1;
    }

    private static int linearFirstIndexOf(AbstractByteBuf buffer, int fromIndex, int toIndex, byte value2) {
        for (int i2 = fromIndex; i2 < toIndex; ++i2) {
            if (buffer._getByte(i2) != value2) continue;
            return i2;
        }
        return -1;
    }

    public static short swapShort(short value2) {
        return Short.reverseBytes(value2);
    }

    public static int swapMedium(int value2) {
        int swapped = value2 << 16 & 0xFF0000 | value2 & 0xFF00 | value2 >>> 16 & 0xFF;
        if ((swapped & 0x800000) != 0) {
            swapped |= 0xFF000000;
        }
        return swapped;
    }

    public static int swapInt(int value2) {
        return Integer.reverseBytes(value2);
    }

    public static long swapLong(long value2) {
        return Long.reverseBytes(value2);
    }

    public static ByteBuf writeShortBE(ByteBuf buf, int shortValue) {
        return buf.order() == ByteOrder.BIG_ENDIAN ? buf.writeShort(shortValue) : buf.writeShort(ByteBufUtil.swapShort((short)shortValue));
    }

    public static ByteBuf setShortBE(ByteBuf buf, int index, int shortValue) {
        return buf.order() == ByteOrder.BIG_ENDIAN ? buf.setShort(index, shortValue) : buf.setShort(index, ByteBufUtil.swapShort((short)shortValue));
    }

    public static ByteBuf writeMediumBE(ByteBuf buf, int mediumValue) {
        return buf.order() == ByteOrder.BIG_ENDIAN ? buf.writeMedium(mediumValue) : buf.writeMedium(ByteBufUtil.swapMedium(mediumValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf readBytes(ByteBufAllocator alloc, ByteBuf buffer, int length) {
        boolean release2 = true;
        ByteBuf dst = alloc.buffer(length);
        try {
            buffer.readBytes(dst);
            release2 = false;
            ByteBuf byteBuf = dst;
            return byteBuf;
        }
        finally {
            if (release2) {
                dst.release();
            }
        }
    }

    static int lastIndexOf(AbstractByteBuf buffer, int fromIndex, int toIndex, byte value2) {
        assert (fromIndex > toIndex);
        int capacity = buffer.capacity();
        if ((fromIndex = Math.min(fromIndex, capacity)) <= 0) {
            return -1;
        }
        int length = fromIndex - toIndex;
        buffer.checkIndex(toIndex, length);
        if (!PlatformDependent.isUnaligned()) {
            return ByteBufUtil.linearLastIndexOf(buffer, fromIndex, toIndex, value2);
        }
        int longCount = length >>> 3;
        if (longCount > 0) {
            ByteOrder nativeOrder = ByteOrder.nativeOrder();
            boolean isNative = nativeOrder == buffer.order();
            boolean useLE = nativeOrder == ByteOrder.LITTLE_ENDIAN;
            long pattern = SWARUtil.compilePattern(value2);
            int i2 = 0;
            int offset = fromIndex - 8;
            while (i2 < longCount) {
                long word = useLE ? buffer._getLongLE(offset) : buffer._getLong(offset);
                long result2 = SWARUtil.applyPattern(word, pattern);
                if (result2 != 0L) {
                    return offset + 8 - 1 - SWARUtil.getIndex(result2, !isNative);
                }
                ++i2;
                offset -= 8;
            }
        }
        return ByteBufUtil.unrolledLastIndexOf(buffer, fromIndex - (longCount << 3), length & 7, value2);
    }

    private static int linearLastIndexOf(AbstractByteBuf buffer, int fromIndex, int toIndex, byte value2) {
        for (int i2 = fromIndex - 1; i2 >= toIndex; --i2) {
            if (buffer._getByte(i2) != value2) continue;
            return i2;
        }
        return -1;
    }

    private static int unrolledLastIndexOf(AbstractByteBuf buffer, int fromIndex, int byteCount, byte value2) {
        assert (byteCount >= 0 && byteCount < 8);
        if (byteCount == 0) {
            return -1;
        }
        if (buffer._getByte(fromIndex - 1) == value2) {
            return fromIndex - 1;
        }
        if (byteCount == 1) {
            return -1;
        }
        if (buffer._getByte(fromIndex - 2) == value2) {
            return fromIndex - 2;
        }
        if (byteCount == 2) {
            return -1;
        }
        if (buffer._getByte(fromIndex - 3) == value2) {
            return fromIndex - 3;
        }
        if (byteCount == 3) {
            return -1;
        }
        if (buffer._getByte(fromIndex - 4) == value2) {
            return fromIndex - 4;
        }
        if (byteCount == 4) {
            return -1;
        }
        if (buffer._getByte(fromIndex - 5) == value2) {
            return fromIndex - 5;
        }
        if (byteCount == 5) {
            return -1;
        }
        if (buffer._getByte(fromIndex - 6) == value2) {
            return fromIndex - 6;
        }
        if (byteCount == 6) {
            return -1;
        }
        if (buffer._getByte(fromIndex - 7) == value2) {
            return fromIndex - 7;
        }
        return -1;
    }

    static int writeUtf8(AbstractByteBuf buffer, int writerIndex, int reservedBytes, CharSequence seq, int len) {
        return ByteBufUtil.writeUtf8(buffer, writerIndex, reservedBytes, seq, 0, len);
    }

    static int writeUtf8(AbstractByteBuf buffer, int writerIndex, int reservedBytes, CharSequence seq, int start2, int end) {
        if (seq instanceof AsciiString) {
            ByteBufUtil.writeAsciiString(buffer, writerIndex, (AsciiString)seq, start2, end);
            return end - start2;
        }
        if (PlatformDependent.hasUnsafe()) {
            if (buffer.hasArray()) {
                return ByteBufUtil.unsafeWriteUtf8(buffer.array(), PlatformDependent.byteArrayBaseOffset(), buffer.arrayOffset() + writerIndex, seq, start2, end);
            }
            if (buffer.hasMemoryAddress()) {
                return ByteBufUtil.unsafeWriteUtf8(null, buffer.memoryAddress(), writerIndex, seq, start2, end);
            }
        } else {
            if (buffer.hasArray()) {
                return ByteBufUtil.safeArrayWriteUtf8(buffer.array(), buffer.arrayOffset() + writerIndex, seq, start2, end);
            }
            if (buffer.isDirect()) {
                assert (buffer.nioBufferCount() == 1);
                ByteBuffer internalDirectBuffer = buffer.internalNioBuffer(writerIndex, reservedBytes);
                int bufferPosition = internalDirectBuffer.position();
                return ByteBufUtil.safeDirectWriteUtf8(internalDirectBuffer, bufferPosition, seq, start2, end);
            }
        }
        return ByteBufUtil.safeWriteUtf8(buffer, writerIndex, seq, start2, end);
    }

    static void writeAsciiString(AbstractByteBuf buffer, int writerIndex, AsciiString seq, int start2, int end) {
        int begin = seq.arrayOffset() + start2;
        int length = end - start2;
        if (PlatformDependent.hasUnsafe()) {
            if (buffer.hasArray()) {
                PlatformDependent.copyMemory(seq.array(), begin, buffer.array(), buffer.arrayOffset() + writerIndex, length);
                return;
            }
            if (buffer.hasMemoryAddress()) {
                PlatformDependent.copyMemory(seq.array(), begin, buffer.memoryAddress() + (long)writerIndex, (long)length);
                return;
            }
        }
        if (buffer.hasArray()) {
            System.arraycopy(seq.array(), begin, buffer.array(), buffer.arrayOffset() + writerIndex, length);
            return;
        }
        buffer.setBytes(writerIndex, seq.array(), begin, length);
    }

    private static int safeDirectWriteUtf8(ByteBuffer buffer, int writerIndex, CharSequence seq, int start2, int end) {
        assert (!(seq instanceof AsciiString));
        int oldWriterIndex = writerIndex;
        for (int i2 = start2; i2 < end; ++i2) {
            char c = seq.charAt(i2);
            if (c < '\u0080') {
                buffer.put(writerIndex++, (byte)c);
                continue;
            }
            if (c < '\u0800') {
                buffer.put(writerIndex++, (byte)(0xC0 | c >> 6));
                buffer.put(writerIndex++, (byte)(0x80 | c & 0x3F));
                continue;
            }
            if (StringUtil.isSurrogate(c)) {
                if (!Character.isHighSurrogate(c)) {
                    buffer.put(writerIndex++, (byte)63);
                    continue;
                }
                if (++i2 == end) {
                    buffer.put(writerIndex++, (byte)63);
                    break;
                }
                char c2 = seq.charAt(i2);
                if (!Character.isLowSurrogate(c2)) {
                    buffer.put(writerIndex++, (byte)63);
                    buffer.put(writerIndex++, (byte)(Character.isHighSurrogate(c2) ? 63 : (byte)c2));
                    continue;
                }
                int codePoint = Character.toCodePoint(c, c2);
                buffer.put(writerIndex++, (byte)(0xF0 | codePoint >> 18));
                buffer.put(writerIndex++, (byte)(0x80 | codePoint >> 12 & 0x3F));
                buffer.put(writerIndex++, (byte)(0x80 | codePoint >> 6 & 0x3F));
                buffer.put(writerIndex++, (byte)(0x80 | codePoint & 0x3F));
                continue;
            }
            buffer.put(writerIndex++, (byte)(0xE0 | c >> 12));
            buffer.put(writerIndex++, (byte)(0x80 | c >> 6 & 0x3F));
            buffer.put(writerIndex++, (byte)(0x80 | c & 0x3F));
        }
        return writerIndex - oldWriterIndex;
    }

    private static int safeWriteUtf8(AbstractByteBuf buffer, int writerIndex, CharSequence seq, int start2, int end) {
        assert (!(seq instanceof AsciiString));
        int oldWriterIndex = writerIndex;
        for (int i2 = start2; i2 < end; ++i2) {
            char c = seq.charAt(i2);
            if (c < '\u0080') {
                buffer._setByte(writerIndex++, (byte)c);
                continue;
            }
            if (c < '\u0800') {
                buffer._setByte(writerIndex++, (byte)(0xC0 | c >> 6));
                buffer._setByte(writerIndex++, (byte)(0x80 | c & 0x3F));
                continue;
            }
            if (StringUtil.isSurrogate(c)) {
                if (!Character.isHighSurrogate(c)) {
                    buffer._setByte(writerIndex++, 63);
                    continue;
                }
                if (++i2 == end) {
                    buffer._setByte(writerIndex++, 63);
                    break;
                }
                char c2 = seq.charAt(i2);
                if (!Character.isLowSurrogate(c2)) {
                    buffer._setByte(writerIndex++, 63);
                    buffer._setByte(writerIndex++, Character.isHighSurrogate(c2) ? 63 : (int)c2);
                    continue;
                }
                int codePoint = Character.toCodePoint(c, c2);
                buffer._setByte(writerIndex++, (byte)(0xF0 | codePoint >> 18));
                buffer._setByte(writerIndex++, (byte)(0x80 | codePoint >> 12 & 0x3F));
                buffer._setByte(writerIndex++, (byte)(0x80 | codePoint >> 6 & 0x3F));
                buffer._setByte(writerIndex++, (byte)(0x80 | codePoint & 0x3F));
                continue;
            }
            buffer._setByte(writerIndex++, (byte)(0xE0 | c >> 12));
            buffer._setByte(writerIndex++, (byte)(0x80 | c >> 6 & 0x3F));
            buffer._setByte(writerIndex++, (byte)(0x80 | c & 0x3F));
        }
        return writerIndex - oldWriterIndex;
    }

    private static int safeArrayWriteUtf8(byte[] buffer, int writerIndex, CharSequence seq, int start2, int end) {
        int oldWriterIndex = writerIndex;
        for (int i2 = start2; i2 < end; ++i2) {
            char c = seq.charAt(i2);
            if (c < '\u0080') {
                buffer[writerIndex++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                buffer[writerIndex++] = (byte)(0xC0 | c >> 6);
                buffer[writerIndex++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (StringUtil.isSurrogate(c)) {
                if (!Character.isHighSurrogate(c)) {
                    buffer[writerIndex++] = 63;
                    continue;
                }
                if (++i2 == end) {
                    buffer[writerIndex++] = 63;
                    break;
                }
                char c2 = seq.charAt(i2);
                if (!Character.isLowSurrogate(c2)) {
                    buffer[writerIndex++] = 63;
                    buffer[writerIndex++] = (byte)(Character.isHighSurrogate(c2) ? 63 : (int)c2);
                    continue;
                }
                int codePoint = Character.toCodePoint(c, c2);
                buffer[writerIndex++] = (byte)(0xF0 | codePoint >> 18);
                buffer[writerIndex++] = (byte)(0x80 | codePoint >> 12 & 0x3F);
                buffer[writerIndex++] = (byte)(0x80 | codePoint >> 6 & 0x3F);
                buffer[writerIndex++] = (byte)(0x80 | codePoint & 0x3F);
                continue;
            }
            buffer[writerIndex++] = (byte)(0xE0 | c >> 12);
            buffer[writerIndex++] = (byte)(0x80 | c >> 6 & 0x3F);
            buffer[writerIndex++] = (byte)(0x80 | c & 0x3F);
        }
        return writerIndex - oldWriterIndex;
    }

    private static int unsafeWriteUtf8(byte[] buffer, long memoryOffset, int writerIndex, CharSequence seq, int start2, int end) {
        long writerOffset;
        assert (!(seq instanceof AsciiString));
        long oldWriterOffset = writerOffset = memoryOffset + (long)writerIndex;
        for (int i2 = start2; i2 < end; ++i2) {
            char c = seq.charAt(i2);
            if (c < '\u0080') {
                PlatformDependent.putByte((Object)buffer, writerOffset++, (byte)c);
                continue;
            }
            if (c < '\u0800') {
                PlatformDependent.putByte((Object)buffer, writerOffset++, (byte)(0xC0 | c >> 6));
                PlatformDependent.putByte((Object)buffer, writerOffset++, (byte)(0x80 | c & 0x3F));
                continue;
            }
            if (StringUtil.isSurrogate(c)) {
                if (!Character.isHighSurrogate(c)) {
                    PlatformDependent.putByte((Object)buffer, writerOffset++, (byte)63);
                    continue;
                }
                if (++i2 == end) {
                    PlatformDependent.putByte((Object)buffer, writerOffset++, (byte)63);
                    break;
                }
                char c2 = seq.charAt(i2);
                if (!Character.isLowSurrogate(c2)) {
                    PlatformDependent.putByte((Object)buffer, writerOffset++, (byte)63);
                    PlatformDependent.putByte((Object)buffer, writerOffset++, (byte)(Character.isHighSurrogate(c2) ? 63 : (int)c2));
                    continue;
                }
                int codePoint = Character.toCodePoint(c, c2);
                PlatformDependent.putByte((Object)buffer, writerOffset++, (byte)(0xF0 | codePoint >> 18));
                PlatformDependent.putByte((Object)buffer, writerOffset++, (byte)(0x80 | codePoint >> 12 & 0x3F));
                PlatformDependent.putByte((Object)buffer, writerOffset++, (byte)(0x80 | codePoint >> 6 & 0x3F));
                PlatformDependent.putByte((Object)buffer, writerOffset++, (byte)(0x80 | codePoint & 0x3F));
                continue;
            }
            PlatformDependent.putByte((Object)buffer, writerOffset++, (byte)(0xE0 | c >> 12));
            PlatformDependent.putByte((Object)buffer, writerOffset++, (byte)(0x80 | c >> 6 & 0x3F));
            PlatformDependent.putByte((Object)buffer, writerOffset++, (byte)(0x80 | c & 0x3F));
        }
        return (int)(writerOffset - oldWriterOffset);
    }

    public static int utf8MaxBytes(int seqLength) {
        return seqLength * MAX_BYTES_PER_CHAR_UTF8;
    }

    public static int utf8MaxBytes(CharSequence seq) {
        if (seq instanceof AsciiString) {
            return seq.length();
        }
        return ByteBufUtil.utf8MaxBytes(seq.length());
    }

    static int writeAscii(AbstractByteBuf buffer, int writerIndex, CharSequence seq, int len) {
        if (seq instanceof AsciiString) {
            ByteBufUtil.writeAsciiString(buffer, writerIndex, (AsciiString)seq, 0, len);
        } else {
            ByteBufUtil.writeAsciiCharSequence(buffer, writerIndex, seq, len);
        }
        return len;
    }

    private static int writeAsciiCharSequence(AbstractByteBuf buffer, int writerIndex, CharSequence seq, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            buffer._setByte(writerIndex++, AsciiString.c2b(seq.charAt(i2)));
        }
        return len;
    }

    public static ByteBuf encodeString(ByteBufAllocator alloc, CharBuffer src, Charset charset) {
        return ByteBufUtil.encodeString0(alloc, false, src, charset, 0);
    }

    static ByteBuf encodeString0(ByteBufAllocator alloc, boolean enforceHeap, CharBuffer src, Charset charset, int extraCapacity) {
        CharsetEncoder encoder = CharsetUtil.encoder(charset);
        int length = (int)((double)src.remaining() * (double)encoder.maxBytesPerChar()) + extraCapacity;
        boolean release2 = true;
        ByteBuf dst = enforceHeap ? alloc.heapBuffer(length) : alloc.buffer(length);
        try {
            ByteBuffer dstBuf = dst.internalNioBuffer(dst.readerIndex(), length);
            int pos = dstBuf.position();
            CoderResult cr = encoder.encode(src, dstBuf, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = encoder.flush(dstBuf)).isUnderflow()) {
                cr.throwException();
            }
            dst.writerIndex(dst.writerIndex() + dstBuf.position() - pos);
            release2 = false;
            ByteBuf byteBuf = dst;
            return byteBuf;
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException(x);
        }
        finally {
            if (release2) {
                dst.release();
            }
        }
    }

    static String decodeString(ByteBuf src, int readerIndex, int len, Charset charset) {
        int offset;
        byte[] array;
        if (len == 0) {
            return "";
        }
        if (src.hasArray()) {
            array = src.array();
            offset = src.arrayOffset() + readerIndex;
        } else {
            array = ByteBufUtil.threadLocalTempArray(len);
            offset = 0;
            src.getBytes(readerIndex, array, 0, len);
        }
        if (CharsetUtil.US_ASCII.equals(charset)) {
            return new String(array, 0, offset, len);
        }
        return new String(array, offset, len, charset);
    }

    public static ByteBuf threadLocalDirectBuffer() {
        if (THREAD_LOCAL_BUFFER_SIZE <= 0) {
            return null;
        }
        if (PlatformDependent.hasUnsafe()) {
            return ThreadLocalUnsafeDirectByteBuf.newInstance();
        }
        return ThreadLocalDirectByteBuf.newInstance();
    }

    public static void copy(AsciiString src, ByteBuf dst) {
        ByteBufUtil.copy(src, 0, dst, src.length());
    }

    public static void copy(AsciiString src, int srcIdx, ByteBuf dst, int dstIdx, int length) {
        if (MathUtil.isOutOfBounds(srcIdx, length, src.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + src.length() + ')');
        }
        ObjectUtil.checkNotNull(dst, "dst").setBytes(dstIdx, src.array(), srcIdx + src.arrayOffset(), length);
    }

    public static void copy(AsciiString src, int srcIdx, ByteBuf dst, int length) {
        if (MathUtil.isOutOfBounds(srcIdx, length, src.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + src.length() + ')');
        }
        ObjectUtil.checkNotNull(dst, "dst").writeBytes(src.array(), srcIdx + src.arrayOffset(), length);
    }

    public static void appendPrettyHexDump(StringBuilder dump, ByteBuf buf) {
        ByteBufUtil.appendPrettyHexDump(dump, buf, buf.readerIndex(), buf.readableBytes());
    }

    public static void appendPrettyHexDump(StringBuilder dump, ByteBuf buf, int offset, int length) {
        HexUtil.appendPrettyHexDump(dump, buf, offset, length);
    }

    private ByteBufUtil() {
    }

    static {
        AbstractByteBufAllocator alloc;
        logger = InternalLoggerFactory.getInstance(ByteBufUtil.class);
        BYTE_ARRAYS = new FastThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() throws Exception {
                return PlatformDependent.allocateUninitializedArray(1024);
            }
        };
        MAX_BYTES_PER_CHAR_UTF8 = (int)CharsetUtil.encoder(CharsetUtil.UTF_8).maxBytesPerChar();
        String allocType = SystemPropertyUtil.get("io.netty.allocator.type", "adaptive");
        if ("unpooled".equals(allocType)) {
            alloc = UnpooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)allocType);
        } else if ("pooled".equals(allocType)) {
            alloc = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)allocType);
        } else if ("adaptive".equals(allocType)) {
            alloc = new AdaptiveByteBufAllocator();
            logger.debug("-Dio.netty.allocator.type: {}", (Object)allocType);
        } else {
            alloc = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: pooled (unknown: {})", (Object)allocType);
        }
        DEFAULT_ALLOCATOR = alloc;
        THREAD_LOCAL_BUFFER_SIZE = SystemPropertyUtil.getInt("io.netty.threadLocalDirectBufferSize", 0);
        logger.debug("-Dio.netty.threadLocalDirectBufferSize: {}", (Object)THREAD_LOCAL_BUFFER_SIZE);
        MAX_CHAR_BUFFER_SIZE = SystemPropertyUtil.getInt("io.netty.maxThreadLocalCharBufferSize", 16384);
        logger.debug("-Dio.netty.maxThreadLocalCharBufferSize: {}", (Object)MAX_CHAR_BUFFER_SIZE);
        FIND_NON_ASCII = new ByteProcessor(){

            @Override
            public boolean process(byte value2) {
                return value2 >= 0;
            }
        };
    }

    static final class ThreadLocalDirectByteBuf
    extends UnpooledDirectByteBuf {
        private static final ObjectPool<ThreadLocalDirectByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<ThreadLocalDirectByteBuf>(){

            @Override
            public ThreadLocalDirectByteBuf newObject(ObjectPool.Handle<ThreadLocalDirectByteBuf> handle2) {
                return new ThreadLocalDirectByteBuf(handle2);
            }
        });
        private final Recycler.EnhancedHandle<ThreadLocalDirectByteBuf> handle;

        static ThreadLocalDirectByteBuf newInstance() {
            ThreadLocalDirectByteBuf buf = RECYCLER.get();
            buf.resetRefCnt();
            return buf;
        }

        private ThreadLocalDirectByteBuf(ObjectPool.Handle<ThreadLocalDirectByteBuf> handle2) {
            super(UnpooledByteBufAllocator.DEFAULT, 256, Integer.MAX_VALUE);
            this.handle = (Recycler.EnhancedHandle)handle2;
        }

        @Override
        protected void deallocate() {
            if (this.capacity() > THREAD_LOCAL_BUFFER_SIZE) {
                super.deallocate();
            } else {
                this.clear();
                this.handle.unguardedRecycle(this);
            }
        }
    }

    static final class ThreadLocalUnsafeDirectByteBuf
    extends UnpooledUnsafeDirectByteBuf {
        private static final ObjectPool<ThreadLocalUnsafeDirectByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<ThreadLocalUnsafeDirectByteBuf>(){

            @Override
            public ThreadLocalUnsafeDirectByteBuf newObject(ObjectPool.Handle<ThreadLocalUnsafeDirectByteBuf> handle2) {
                return new ThreadLocalUnsafeDirectByteBuf(handle2);
            }
        });
        private final Recycler.EnhancedHandle<ThreadLocalUnsafeDirectByteBuf> handle;

        static ThreadLocalUnsafeDirectByteBuf newInstance() {
            ThreadLocalUnsafeDirectByteBuf buf = RECYCLER.get();
            buf.resetRefCnt();
            return buf;
        }

        private ThreadLocalUnsafeDirectByteBuf(ObjectPool.Handle<ThreadLocalUnsafeDirectByteBuf> handle2) {
            super(UnpooledByteBufAllocator.DEFAULT, 256, Integer.MAX_VALUE);
            this.handle = (Recycler.EnhancedHandle)handle2;
        }

        @Override
        protected void deallocate() {
            if (this.capacity() > THREAD_LOCAL_BUFFER_SIZE) {
                super.deallocate();
            } else {
                this.clear();
                this.handle.unguardedRecycle(this);
            }
        }
    }

    private static final class HexUtil {
        private static final char[] BYTE2CHAR;
        private static final char[] HEXDUMP_TABLE;
        private static final String[] HEXPADDING;
        private static final String[] HEXDUMP_ROWPREFIXES;
        private static final String[] BYTE2HEX;
        private static final String[] BYTEPADDING;

        private static String hexDump(byte[] array, int fromIndex, int length) {
            ObjectUtil.checkPositiveOrZero(length, "length");
            if (length == 0) {
                return "";
            }
            int endIndex = fromIndex + length;
            char[] buf = new char[length << 1];
            int srcIdx = fromIndex;
            int dstIdx = 0;
            while (srcIdx < endIndex) {
                System.arraycopy(HEXDUMP_TABLE, (array[srcIdx] & 0xFF) << 1, buf, dstIdx, 2);
                ++srcIdx;
                dstIdx += 2;
            }
            return new String(buf);
        }

        private static void appendPrettyHexDump(StringBuilder dump, ByteBuf buf, int offset, int length) {
            if (MathUtil.isOutOfBounds(offset, length, buf.capacity())) {
                throw new IndexOutOfBoundsException("expected: 0 <= offset(" + offset + ") <= offset + length(" + length + ") <= buf.capacity(" + buf.capacity() + ')');
            }
            if (length == 0) {
                return;
            }
            dump.append("         +-------------------------------------------------+" + StringUtil.NEWLINE + "         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |" + StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
            int fullRows = length >>> 4;
            int remainder = length & 0xF;
            for (int row = 0; row < fullRows; ++row) {
                int j;
                int rowStartIndex = (row << 4) + offset;
                HexUtil.appendHexDumpRowPrefix(dump, row, rowStartIndex);
                int rowEndIndex = rowStartIndex + 16;
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2HEX[buf.getUnsignedByte(j)]);
                }
                dump.append(" |");
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2CHAR[buf.getUnsignedByte(j)]);
                }
                dump.append('|');
            }
            if (remainder != 0) {
                int j;
                int rowStartIndex = (fullRows << 4) + offset;
                HexUtil.appendHexDumpRowPrefix(dump, fullRows, rowStartIndex);
                int rowEndIndex = rowStartIndex + remainder;
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2HEX[buf.getUnsignedByte(j)]);
                }
                dump.append(HEXPADDING[remainder]);
                dump.append(" |");
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2CHAR[buf.getUnsignedByte(j)]);
                }
                dump.append(BYTEPADDING[remainder]);
                dump.append('|');
            }
            dump.append(StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
        }

        private static void appendHexDumpRowPrefix(StringBuilder dump, int row, int rowStartIndex) {
            if (row < HEXDUMP_ROWPREFIXES.length) {
                dump.append(HEXDUMP_ROWPREFIXES[row]);
            } else {
                dump.append(StringUtil.NEWLINE);
                dump.append(Long.toHexString((long)rowStartIndex & 0xFFFFFFFFL | 0x100000000L));
                dump.setCharAt(dump.length() - 9, '|');
                dump.append('|');
            }
        }

        static {
            int j;
            StringBuilder buf;
            int i2;
            BYTE2CHAR = new char[256];
            HEXDUMP_TABLE = new char[1024];
            HEXPADDING = new String[16];
            HEXDUMP_ROWPREFIXES = new String[4096];
            BYTE2HEX = new String[256];
            BYTEPADDING = new String[16];
            char[] DIGITS = "0123456789abcdef".toCharArray();
            for (i2 = 0; i2 < 256; ++i2) {
                HexUtil.HEXDUMP_TABLE[i2 << 1] = DIGITS[i2 >>> 4 & 0xF];
                HexUtil.HEXDUMP_TABLE[(i2 << 1) + 1] = DIGITS[i2 & 0xF];
            }
            for (i2 = 0; i2 < HEXPADDING.length; ++i2) {
                int padding = HEXPADDING.length - i2;
                buf = new StringBuilder(padding * 3);
                for (j = 0; j < padding; ++j) {
                    buf.append("   ");
                }
                HexUtil.HEXPADDING[i2] = buf.toString();
            }
            for (i2 = 0; i2 < HEXDUMP_ROWPREFIXES.length; ++i2) {
                StringBuilder buf2 = new StringBuilder(12);
                buf2.append(StringUtil.NEWLINE);
                buf2.append(Long.toHexString((long)(i2 << 4) & 0xFFFFFFFFL | 0x100000000L));
                buf2.setCharAt(buf2.length() - 9, '|');
                buf2.append('|');
                HexUtil.HEXDUMP_ROWPREFIXES[i2] = buf2.toString();
            }
            for (i2 = 0; i2 < BYTE2HEX.length; ++i2) {
                HexUtil.BYTE2HEX[i2] = ' ' + StringUtil.byteToHexStringPadded(i2);
            }
            for (i2 = 0; i2 < BYTEPADDING.length; ++i2) {
                int padding = BYTEPADDING.length - i2;
                buf = new StringBuilder(padding);
                for (j = 0; j < padding; ++j) {
                    buf.append(' ');
                }
                HexUtil.BYTEPADDING[i2] = buf.toString();
            }
            for (i2 = 0; i2 < BYTE2CHAR.length; ++i2) {
                HexUtil.BYTE2CHAR[i2] = i2 <= 31 || i2 >= 127 ? 46 : (char)i2;
            }
        }
    }
}

