/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.server.application.ApplicationCallPipeline;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.ApplicationPluginKt;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.application.PipelineCallKt;
import io.ktor.server.application.Plugin;
import io.ktor.server.routing.Route;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RoutingCall;
import io.ktor.server.routing.RoutingContext;
import io.ktor.server.routing.RoutingPipelineCall;
import io.ktor.server.routing.RoutingRootKt;
import io.ktor.server.routing.TrailingSlashRouteSelector;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.utils.io.KtorDsl;
import java.util.ArrayList;
import java.util.List;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KtorDsl
@SourceDebugExtension(value={"SMAP\nRoutingNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoutingNode.kt\nio/ktor/server/routing/RoutingNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,401:1\n295#2,2:402\n1869#2,2:404\n*S KotlinDebug\n*F\n+ 1 RoutingNode.kt\nio/ktor/server/routing/RoutingNode\n*L\n56#1:402,2\n100#1:404,2\n*E\n"})
public class RoutingNode
extends ApplicationCallPipeline
implements Route {
    @Nullable
    private final RoutingNode parent;
    @NotNull
    private final RouteSelector selector;
    @NotNull
    private final List<RoutingNode> childList;
    @Nullable
    private ApplicationCallPipeline cachedPipeline;
    @NotNull
    private final List<Function2<RoutingContext, Continuation<? super Unit>, Object>> handlers;

    public RoutingNode(@Nullable RoutingNode parent, @NotNull RouteSelector selector, boolean developmentMode, @NotNull ApplicationEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super(developmentMode, environment);
        this.parent = parent;
        this.selector = selector;
        this.childList = new ArrayList();
        this.handlers = new ArrayList();
    }

    @Override
    @Nullable
    public RoutingNode getParent() {
        return this.parent;
    }

    @NotNull
    public final RouteSelector getSelector() {
        return this.selector;
    }

    @NotNull
    public final List<RoutingNode> getChildren() {
        return this.childList;
    }

    @NotNull
    public final List<Function2<RoutingContext, Continuation<? super Unit>, Object>> getHandlers$ktor_server_core() {
        return this.handlers;
    }

    @Override
    @NotNull
    public RoutingNode createChild(@NotNull RouteSelector selector) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            Iterable $this$firstOrNull$iv = this.childList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RoutingNode it = (RoutingNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.selector, (Object)selector)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        RoutingNode existingEntry = v0;
        if (existingEntry == null) {
            RoutingNode entry = new RoutingNode(this, selector, this.getDevelopmentMode(), this.getEnvironment());
            this.childList.add(entry);
            return entry;
        }
        return existingEntry;
    }

    @Override
    public void handle(@NotNull Function2<? super RoutingContext, ? super Continuation<? super Unit>, ? extends Object> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.handlers.add(body);
        this.cachedPipeline = null;
    }

    @Override
    @NotNull
    public <F> F plugin(@NotNull Plugin<?, ?, F> plugin) {
        Intrinsics.checkNotNullParameter(plugin, (String)"plugin");
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.ktor.server.application.ApplicationCallPipeline");
        return ApplicationPluginKt.plugin((Pipeline)this, plugin);
    }

    @Override
    @NotNull
    public <B, F> F install(@NotNull Plugin<? super ApplicationCallPipeline, ? extends B, F> plugin, @NotNull Function1<? super B, Unit> configure2) {
        Intrinsics.checkNotNullParameter(plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter(configure2, (String)"configure");
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.ktor.server.application.ApplicationCallPipeline");
        return ApplicationPluginKt.install((Pipeline)this, plugin, configure2);
    }

    public void afterIntercepted() {
        this.invalidateCachesRecursively();
    }

    private final void invalidateCachesRecursively() {
        this.cachedPipeline = null;
        Iterable $this$forEach$iv = this.childList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RoutingNode it = (RoutingNode)element$iv;
            boolean bl = false;
            it.invalidateCachesRecursively();
        }
    }

    @NotNull
    public final ApplicationCallPipeline buildPipeline$ktor_server_core() {
        ApplicationCallPipeline applicationCallPipeline = this.cachedPipeline;
        if (applicationCallPipeline == null) {
            RoutingNode $this$buildPipeline_u24lambda_u242 = this;
            boolean bl = false;
            ApplicationCallPipeline pipeline = new ApplicationCallPipeline($this$buildPipeline_u24lambda_u242.getDevelopmentMode(), RoutingRootKt.getApplication($this$buildPipeline_u24lambda_u242).getEnvironment());
            List routePipelines = new ArrayList();
            for (RoutingNode current = $this$buildPipeline_u24lambda_u242; current != null; current = current.getParent()) {
                routePipelines.add(current);
            }
            for (int index = CollectionsKt.getLastIndex((List)routePipelines); -1 < index; --index) {
                ApplicationCallPipeline routePipeline = (ApplicationCallPipeline)((Object)routePipelines.get(index));
                pipeline.merge(routePipeline);
                pipeline.getReceivePipeline().merge(routePipeline.getReceivePipeline());
                pipeline.getSendPipeline().merge(routePipeline.getSendPipeline());
            }
            int index = 0;
            List<Function2<RoutingContext, Continuation<? super Unit>, Object>> handlers2 = $this$buildPipeline_u24lambda_u242.handlers;
            int n = CollectionsKt.getLastIndex(handlers2);
            if (index <= n) {
                while (true) {
                    pipeline.intercept(ApplicationCallPipeline.ApplicationPhase.getCall(), (Function3)new Function3<PipelineContext<Unit, PipelineCall>, Unit, Continuation<? super Unit>, Object>(handlers2, index, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ List<Function2<RoutingContext, Continuation<? super Unit>, Object>> $handlers;
                        final /* synthetic */ int $index;
                        {
                            this.$handlers = $handlers;
                            this.$index = $index;
                            super(3, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    PipelineContext $this$intercept;
                                    ResultKt.throwOnFailure((Object)object);
                                    PipelineContext $this$call$iv = $this$intercept = (PipelineContext)this.L$0;
                                    boolean $i$f$getCall = false;
                                    PipelineCall pipelineCall = (PipelineCall)$this$call$iv.getContext();
                                    Intrinsics.checkNotNull((Object)pipelineCall, (String)"null cannot be cast to non-null type io.ktor.server.routing.RoutingPipelineCall");
                                    RoutingPipelineCall call2 = (RoutingPipelineCall)pipelineCall;
                                    RoutingCall routingCall = new RoutingCall(call2);
                                    RoutingContext routingContext = new RoutingContext(routingCall);
                                    if (PipelineCallKt.isHandled(call2)) {
                                        return Unit.INSTANCE;
                                    }
                                    this.label = 1;
                                    Object object3 = this.$handlers.get(this.$index).invoke((Object)routingContext, (Object)((Object)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Object invoke(PipelineContext<Unit, PipelineCall> p1, Unit p2, Continuation<? super Unit> p3) {
                            Function3<PipelineContext<Unit, PipelineCall>, Unit, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                            function3.L$0 = p1;
                            return function3.invokeSuspend((Object)Unit.INSTANCE);
                        }
                    });
                    if (index == n) break;
                    ++index;
                }
            }
            $this$buildPipeline_u24lambda_u242.cachedPipeline = pipeline;
            applicationCallPipeline = pipeline;
        }
        return applicationCallPipeline;
    }

    @NotNull
    public String toString() {
        String parentRoute;
        RoutingNode routingNode = this.getParent();
        String string = parentRoute = routingNode != null ? routingNode.toString() : null;
        return parentRoute == null ? (this.selector instanceof TrailingSlashRouteSelector ? "/" : "" + '/' + this.selector) : (this.selector instanceof TrailingSlashRouteSelector ? (StringsKt.endsWith$default((CharSequence)parentRoute, (char)'/', (boolean)false, (int)2, null) ? parentRoute : parentRoute + '/') : (StringsKt.endsWith$default((CharSequence)parentRoute, (char)'/', (boolean)false, (int)2, null) ? parentRoute + this.selector : parentRoute + '/' + this.selector));
    }
}

