/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingPath;
import io.ktor.server.routing.RoutingPathSegment;
import io.ktor.server.routing.RoutingPathSegmentKind;
import io.ktor.server.routing.RoutingResolveContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRouteSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/RootRouteSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,782:1\n1563#2:783\n1634#2,3:784\n1#3:787\n*S KotlinDebug\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/RootRouteSelector\n*L\n262#1:783\n262#1:784,3\n*E\n"})
public final class RootRouteSelector
extends RouteSelector {
    @NotNull
    private final List<String> parts;
    @NotNull
    private final RouteSelectorEvaluation.Success successEvaluationResult;

    /*
     * WARNING - void declaration
     */
    public RootRouteSelector(@NotNull String rootPath) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Iterable iterable = RoutingPath.Companion.parse(rootPath).getParts();
        RootRouteSelector rootRouteSelector = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RoutingPathSegment routingPathSegment = (RoutingPathSegment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == RoutingPathSegmentKind.Constant)) {
                boolean bl2 = false;
                String string = "rootPath should be constant, no wildcards supported.";
                throw new IllegalArgumentException(string.toString());
            }
            collection.add(it.getValue());
        }
        rootRouteSelector.parts = (List)destination$iv$iv;
        this.successEvaluationResult = new RouteSelectorEvaluation.Success(1.0, null, this.parts.size(), 2, null);
    }

    public /* synthetic */ RootRouteSelector(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    @Override
    @Nullable
    public Object evaluate(@NotNull RoutingResolveContext context2, int segmentIndex, @NotNull Continuation<? super RouteSelectorEvaluation> $completion) {
        if (!(segmentIndex == 0)) {
            boolean $i$a$-check-RootRouteSelector$evaluate$32 = false;
            String $i$a$-check-RootRouteSelector$evaluate$32 = "Root selector should be evaluated first.";
            throw new IllegalStateException($i$a$-check-RootRouteSelector$evaluate$32.toString());
        }
        if (this.parts.isEmpty()) {
            return RouteSelectorEvaluation.Companion.getConstant();
        }
        List<String> parts = this.parts;
        List<String> segments = context2.getSegments();
        if (segments.size() < parts.size()) {
            return RouteSelectorEvaluation.Companion.getFailedPath();
        }
        int n = segmentIndex + parts.size();
        for (int index = segmentIndex; index < n; ++index) {
            if (Intrinsics.areEqual((Object)segments.get(index), (Object)parts.get(index))) continue;
            return RouteSelectorEvaluation.Companion.getFailedPath();
        }
        return this.successEvaluationResult;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.parts, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    public RootRouteSelector() {
        this(null, 1, null);
    }
}

