/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

final class ShutdownHook
extends Thread {
    @NotNull
    private final Function0<Unit> stopFunction;
    @NotNull
    private final AtomicBoolean shouldStop;

    public ShutdownHook(@NotNull Function0<Unit> stopFunction) {
        Intrinsics.checkNotNullParameter(stopFunction, (String)"stopFunction");
        super("KtorShutdownHook");
        this.stopFunction = stopFunction;
        this.shouldStop = new AtomicBoolean(true);
    }

    @Override
    public void run() {
        if (this.shouldStop.compareAndSet(true, false)) {
            this.stopFunction.invoke();
        }
    }
}

