/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.events.EventDefinition;
import io.ktor.events.Events;
import io.ktor.http.HttpStatusCode;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.ApplicationModulesKt;
import io.ktor.server.application.ApplicationModules_jvmKt;
import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.application.DynamicApplicationModule;
import io.ktor.server.application.ModuleParametersInjector;
import io.ktor.server.application.ServerConfig;
import io.ktor.server.config.ApplicationConfigValue;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineFactory;
import io.ktor.server.engine.ClassLoadersKt;
import io.ktor.server.engine.EmbeddedServer;
import io.ktor.server.engine.EmbeddedServerJvmKt;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.OverridingClassLoader;
import io.ktor.server.engine.ServerHostUtilsKt;
import io.ktor.server.engine.ShutdownHookKt;
import io.ktor.server.engine.internal.AutoReloadUtilsKt;
import io.ktor.server.engine.internal.CallableUtilsKt;
import io.ktor.server.engine.internal.EngineUtilsJvmKt;
import io.ktor.server.engine.internal.ReloadingException;
import io.ktor.util.Attributes;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.utils.io.ByteReadChannel;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.io.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@SourceDebugExtension(value={"SMAP\nEmbeddedServerJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddedServerJvm.kt\nio/ktor/server/engine/EmbeddedServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ServiceLoader.kt\nio/ktor/util/reflect/ServiceLoaderKt\n*L\n1#1,485:1\n1374#2:486\n1460#2,5:487\n1374#2:492\n1460#2,5:493\n1869#2,2:498\n1563#2:500\n1634#2,3:501\n774#2:504\n865#2,2:505\n1625#2:507\n1869#2:508\n1870#2:510\n1626#2:511\n774#2:512\n865#2:513\n1761#2,3:514\n866#2:517\n1869#2,2:518\n1869#2,2:521\n1617#2,9:523\n1869#2:532\n1870#2:534\n1626#2:535\n1563#2:544\n1634#2,3:545\n1563#2:548\n1634#2,3:549\n1#3:509\n1#3:520\n1#3:533\n1#3:536\n47#4:537\n23#4,2:538\n22#4,4:540\n*S KotlinDebug\n*F\n+ 1 EmbeddedServerJvm.kt\nio/ktor/server/engine/EmbeddedServer\n*L\n131#1:486\n131#1:487,5\n141#1:492\n141#1:493,5\n151#1:498,2\n191#1:500\n191#1:501,3\n193#1:504\n193#1:505,2\n206#1:507\n206#1:508\n206#1:510\n206#1:511\n208#1:512\n208#1:513\n210#1:514,3\n208#1:517\n248#1:518,2\n297#1:521,2\n302#1:523,9\n302#1:532\n302#1:534\n302#1:535\n65#1:544\n65#1:545,3\n66#1:548\n66#1:549,3\n206#1:509\n302#1:533\n62#1:537\n62#1:538,2\n62#1:540,4\n*E\n"})
public final class EmbeddedServer<TEngine extends ApplicationEngine, TConfiguration extends ApplicationEngine.Configuration> {
    @NotNull
    private final ServerConfig rootConfig;
    @NotNull
    private final Events monitor;
    @NotNull
    private final ApplicationEnvironment environment;
    @NotNull
    private final TConfiguration engineConfig;
    @NotNull
    private final ReentrantReadWriteLock applicationInstanceLock;
    private boolean recreateInstance;
    @Nullable
    private ClassLoader applicationClassLoader;
    @NotNull
    private List<? extends WatchKey> packageWatchKeys;
    @NotNull
    private final List<String> configuredWatchPath;
    @NotNull
    private final List<String> watchPatterns;
    @NotNull
    private final Lazy moduleInjector$delegate;
    @NotNull
    private final Lazy modules$delegate;
    @Nullable
    private Application applicationInstance;
    @NotNull
    private final TEngine engine;
    @NotNull
    private final Lazy watcher$delegate;

    public EmbeddedServer(@NotNull ServerConfig rootConfig, @NotNull ApplicationEngineFactory<? extends TEngine, TConfiguration> engineFactory, @NotNull Function1<? super TConfiguration, Unit> engineConfigBlock) {
        Intrinsics.checkNotNullParameter((Object)rootConfig, (String)"rootConfig");
        Intrinsics.checkNotNullParameter(engineFactory, (String)"engineFactory");
        Intrinsics.checkNotNullParameter(engineConfigBlock, (String)"engineConfigBlock");
        this.rootConfig = rootConfig;
        this.monitor = this.rootConfig.getEnvironment().getMonitor();
        this.environment = this.rootConfig.getEnvironment();
        this.engineConfig = engineFactory.configuration(engineConfigBlock);
        this.applicationInstanceLock = new ReentrantReadWriteLock();
        this.packageWatchKeys = CollectionsKt.emptyList();
        ApplicationConfigValue applicationConfigValue = this.environment.getConfig().propertyOrNull("ktor.deployment.watch");
        List list2 = applicationConfigValue != null ? applicationConfigValue.getList() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        this.configuredWatchPath = list2;
        this.watchPatterns = CollectionsKt.plus((Collection)this.configuredWatchPath, (Iterable)this.rootConfig.getWatchPaths$ktor_server_core());
        this.moduleInjector$delegate = LazyKt.lazy(EmbeddedServer::moduleInjector_delegate$lambda$1);
        this.modules$delegate = LazyKt.lazy(() -> EmbeddedServer.modules_delegate$lambda$3(this));
        this.applicationInstance = new Application(this.environment, this.rootConfig.getDevelopmentMode(), this.rootConfig.getRootPath(), this.monitor, this.rootConfig.getParentCoroutineContext(), (Function0<? extends ApplicationEngine>)((Function0)new PropertyReference0Impl(this){

            public Object get() {
                return ((EmbeddedServer)this.receiver).getEngine();
            }
        }));
        this.engine = engineFactory.create(this.environment, this.monitor, this.rootConfig.getDevelopmentMode(), this.engineConfig, (Function0<Application>)((Function0)new Function0<Application>((Object)this){

            public final Application invoke() {
                return EmbeddedServer.access$currentApplication((EmbeddedServer)this.receiver);
            }
        }));
        this.watcher$delegate = LazyKt.lazy(EmbeddedServer::watcher_delegate$lambda$4);
    }

    @NotNull
    public final Events getMonitor() {
        return this.monitor;
    }

    @NotNull
    public final ApplicationEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final Application getApplication() {
        return this.currentApplication();
    }

    @NotNull
    public final TConfiguration getEngineConfig() {
        return this.engineConfig;
    }

    private final ModuleParametersInjector getModuleInjector() {
        Lazy lazy = this.moduleInjector$delegate;
        return (ModuleParametersInjector)lazy.getValue();
    }

    private final List<DynamicApplicationModule> getModules() {
        Lazy lazy = this.modules$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final TEngine getEngine() {
        return this.engine;
    }

    private final WatchService getWatcher() {
        Lazy lazy = this.watcher$delegate;
        return (WatchService)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Application currentApplication() {
        Application application;
        ReentrantReadWriteLock.ReadLock readLock = this.applicationInstanceLock.readLock();
        readLock.lock();
        try {
            Application application2;
            boolean bl = false;
            Application application3 = this.applicationInstance;
            if (application3 == null) {
                throw new IllegalStateException("EmbeddedServer was stopped".toString());
            }
            Application currentApplication = application3;
            if (!this.rootConfig.getDevelopmentMode()) {
                application2 = currentApplication;
            } else {
                Object object = this.getFileChanges();
                if (object == null || object.isEmpty()) {
                    application2 = currentApplication;
                } else {
                    object = this.applicationInstanceLock;
                    ReentrantReadWriteLock.ReadLock readLock2 = ((ReentrantReadWriteLock)object).readLock();
                    int n = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
                    for (int j = 0; j < n; ++j) {
                        readLock2.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
                    writeLock.lock();
                    try {
                        boolean bl2 = false;
                        this.destroyApplication();
                        Pair<Application, ClassLoader> pair = this.createApplication();
                        Application application4 = (Application)((Object)pair.component1());
                        ClassLoader classLoader = (ClassLoader)pair.component2();
                        this.applicationInstance = application4;
                        this.applicationClassLoader = classLoader;
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        for (int j = 0; j < n; ++j) {
                            readLock2.lock();
                        }
                        writeLock.unlock();
                    }
                    application2 = this.applicationInstance;
                    if (application2 == null) {
                        throw new IllegalStateException("EmbeddedServer was stopped".toString());
                    }
                }
            }
            application = application2;
        }
        finally {
            readLock.unlock();
        }
        return application;
    }

    /*
     * WARNING - void declaration
     */
    private final List<WatchEvent<?>> getFileChanges() {
        try {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.packageWatchKeys;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                WatchKey it = (WatchKey)element$iv$iv;
                boolean bl = false;
                List<WatchEvent<?>> list2 = it.pollEvents();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"pollEvents(...)");
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List changes = (List)destination$iv$iv;
            if (changes.isEmpty()) {
                return changes;
            }
            this.environment.getLog().info("Changes in application detected.");
            int count = changes.size();
            while (true) {
                void $this$flatMapTo$iv$iv2;
                Thread.sleep(200L);
                Iterable $this$flatMap$iv2 = this.packageWatchKeys;
                boolean $i$f$flatMap2 = false;
                Iterable $i$f$flatMapTo2 = $this$flatMap$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo3 = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                    WatchKey it = (WatchKey)element$iv$iv;
                    boolean bl = false;
                    List<WatchEvent<?>> list3 = it.pollEvents();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"pollEvents(...)");
                    Iterable list$iv$iv = list3;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                List moreChanges = (List)destination$iv$iv2;
                if (moreChanges.isEmpty()) break;
                this.environment.getLog().debug("Waiting for more changes.");
                count += moreChanges.size();
            }
            this.environment.getLog().debug("Changes to " + count + " files caused application restart.");
            Iterable $this$forEach$iv = CollectionsKt.take((Iterable)changes, (int)5);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WatchEvent it = (WatchEvent)element$iv;
                boolean bl = false;
                this.environment.getLog().debug("...  {}", it.context());
            }
            return changes;
        }
        catch (InterruptedException e) {
            this.environment.getLog().debug("Watch service was interrupted", (Throwable)e);
            return null;
        }
        catch (ClosedWatchServiceException e) {
            this.environment.getLog().debug("Watch service was closed", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<Application, ClassLoader> createApplication() {
        ClassLoader classLoader = this.createClassLoader();
        Thread currentThread = Thread.currentThread();
        ClassLoader oldThreadClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(classLoader);
        try {
            Pair pair = TuplesKt.to((Object)((Object)this.instantiateAndConfigureApplication(classLoader)), (Object)classLoader);
            return pair;
        }
        finally {
            currentThread.setContextClassLoader(oldThreadClassLoader);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ClassLoader createClassLoader() {
        baseClassLoader = this.environment.getClassLoader();
        if (!this.rootConfig.getDevelopmentMode()) {
            this.environment.getLog().info("Autoreload is disabled because the development mode is off.");
            return baseClassLoader;
        }
        watchPatterns = this.watchPatterns;
        if (watchPatterns.isEmpty()) {
            this.environment.getLog().info("No ktor.deployment.watch patterns specified, automatic reload is not active.");
            return baseClassLoader;
        }
        allUrls = ClassLoadersKt.allURLs(baseClassLoader);
        jre = new File(System.getProperty("java.home")).getParent();
        $this$map$iv = allUrls;
        $i$f$map = false;
        var8_8 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var13_18 = (URL)item$iv$iv;
            var23_22 = destination$iv$iv;
            $i$a$-map-EmbeddedServer$createClassLoader$debugUrls$1 = false;
            var23_22.add(it.getFile());
        }
        debugUrls = (List)destination$iv$iv;
        this.environment.getLog().debug("Java Home: " + jre);
        $this$map$iv = debugUrls;
        var24_24 = new StringBuilder().append("Class Loader: ").append(baseClassLoader).append(": ");
        var23_22 = this.environment.getLog();
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            $i$a$-filter-EmbeddedServer$createClassLoader$1 = false;
            v0 = it.toString();
            Intrinsics.checkNotNull((Object)jre);
            if (!(StringsKt.startsWith$default((String)v0, (String)jre, (boolean)false, (int)2, null) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var25_25 = (List)destination$iv$iv;
        var23_22.debug(var24_24.append(var25_25).toString());
        $i$f$filter /* !! */  = new Class[]{ApplicationEnvironment.class, Pipeline.class, HttpStatusCode.class, Function1.class, Logger.class, ByteReadChannel.class, Source.class, Attributes.class};
        $i$f$filter /* !! */  = CollectionsKt.listOf((Object[])$i$f$filter /* !! */ );
        destination$iv = new HashSet<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        $i$f$forEach = false;
        element$iv$iv = $this$forEach$iv$iv.iterator();
        while (element$iv$iv.hasNext()) {
            element$iv = element$iv$iv = element$iv$iv.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv = false;
            it = (Class)element$iv;
            $i$a$-mapNotNullTo-EmbeddedServer$createClassLoader$coreUrls$1 = false;
            if (it.getProtectionDomain().getCodeSource().getLocation() == null) continue;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv = false;
            destination$iv.add(it$iv);
        }
        coreUrls = (HashSet)destination$iv;
        $this$filter$iv = allUrls;
        $i$f$filter = false;
        $this$forEach$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            block13: {
                url = (URL)element$iv$iv;
                $i$a$-filter-EmbeddedServer$createClassLoader$watchUrls$1 = false;
                if (coreUrls.contains(url)) ** GOTO lbl-1000
                $this$any$iv = watchPatterns;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        pattern = (String)element$iv;
                        $i$a$-any-EmbeddedServer$createClassLoader$watchUrls$1$1 = false;
                        if (!EmbeddedServerJvmKt.checkUrlMatches(url, pattern)) continue;
                        v1 = true;
                        break block13;
                    }
                    v1 = false;
                }
            }
            if (!v1) ** GOTO lbl-1000
            v2 = url.getPath();
            if (v2 == null) {
                v2 = "";
            }
            Intrinsics.checkNotNull((Object)jre);
            if (!StringsKt.startsWith$default((String)v2, (String)jre, (boolean)false, (int)2, null)) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        watchUrls = (List)destination$iv$iv;
        if (watchUrls.isEmpty()) {
            this.environment.getLog().info("No ktor.deployment.watch patterns match classpath entries, automatic reload is not active");
            return baseClassLoader;
        }
        this.watchUrls(watchUrls);
        return new OverridingClassLoader(watchUrls, baseClassLoader);
    }

    private final void safeRaiseEvent(EventDefinition<Application> event, Application application) {
        try {
            this.monitor.raise(event, (Object)application);
        }
        catch (Throwable cause) {
            this.environment.getLog().debug("One or more of the handlers thrown an exception", cause);
        }
    }

    private final void destroyApplication() {
        Application currentApplication = this.applicationInstance;
        ClassLoader currentApplicationClassLoader = this.applicationClassLoader;
        this.applicationInstance = null;
        this.applicationClassLoader = null;
        if (currentApplication != null) {
            this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStopping(), currentApplication);
            try {
                this.destroyBlocking(currentApplication, currentApplicationClassLoader);
            }
            catch (Throwable e) {
                this.environment.getLog().error("Failed to destroy application instance.", e);
            }
            this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStopped(), currentApplication);
        }
        Iterable $this$forEach$iv = this.packageWatchKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WatchKey it = (WatchKey)element$iv;
            boolean bl = false;
            it.cancel();
        }
        this.packageWatchKeys = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void destroyBlocking(Application application, ClassLoader classLoader) {
        try {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, application, null){
                int label;
                final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
                final /* synthetic */ Application $application;
                {
                    this.this$0 = $receiver;
                    this.$application = $application;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = TimeoutKt.withTimeout((long)((ApplicationEngine.Configuration)this.this$0.getEngineConfig()).getShutdownTimeout(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$application, null){
                                int label;
                                final /* synthetic */ Application $application;
                                {
                                    this.$application = $application;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = this.$application.disposeAndJoin((Continuation<? super Unit>)((Continuation)this));
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        catch (Throwable throwable) {
            OverridingClassLoader overridingClassLoader = classLoader instanceof OverridingClassLoader ? (OverridingClassLoader)classLoader : null;
            if (overridingClassLoader != null) {
                overridingClassLoader.close();
            }
            throw throwable;
        }
        OverridingClassLoader overridingClassLoader = classLoader instanceof OverridingClassLoader ? (OverridingClassLoader)classLoader : null;
        if (overridingClassLoader != null) {
            overridingClassLoader.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void watchUrls(List<URL> urls2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        WatchEvent.Modifier[] modifierArray;
        Object element$iv2;
        WatchEvent.Modifier[] modifierArray2;
        HashSet<Path> paths = new HashSet<Path>();
        for (URL url : urls2) {
            Path folder;
            Object $this$watchUrls_u24lambda_u2417;
            Object path2;
            if (url.getPath() == null) continue;
            String decodedPath = URLDecoder.decode((String)path2, "utf-8");
            modifierArray2 = this;
            try {
                $this$watchUrls_u24lambda_u2417 = modifierArray2;
                boolean bl = false;
                $this$watchUrls_u24lambda_u2417 = Result.constructor-impl((Object)new File(decodedPath).toPath());
            }
            catch (Throwable throwable) {
                $this$watchUrls_u24lambda_u2417 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            modifierArray2 = $this$watchUrls_u24lambda_u2417;
            if ((Path)(Result.isFailure-impl((Object)modifierArray2) ? null : modifierArray2) == null || !Files.exists(folder, new LinkOption[0])) continue;
            SimpleFileVisitor<Path> visitor2 = new SimpleFileVisitor<Path>(paths){
                final /* synthetic */ HashSet<Path> $paths;
                {
                    this.$paths = $paths;
                }

                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    this.$paths.add(dir);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    Path dir = file.getParent();
                    if (dir != null) {
                        this.$paths.add(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            if (!Files.isDirectory(folder, new LinkOption[0])) continue;
            Files.walkFileTree(folder, (FileVisitor<? super Path>)visitor2);
        }
        Iterable $this$forEach$iv = paths;
        boolean $i$f$forEach22 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Path path3 = (Path)element$iv2;
            boolean bl = false;
            this.environment.getLog().debug("Watching " + path3 + " for changes.");
        }
        WatchEvent.Modifier modifier2 = AutoReloadUtilsKt.get_com_sun_nio_file_SensitivityWatchEventModifier_HIGH();
        if (modifier2 != null) {
            WatchEvent.Modifier it = modifier2;
            boolean bl = false;
            modifierArray2 = new WatchEvent.Modifier[]{it};
            modifierArray = modifierArray2;
        } else {
            modifierArray = new WatchEvent.Modifier[]{};
        }
        WatchEvent.Modifier[] modifiers = modifierArray;
        Iterable $i$f$forEach22 = paths;
        WatchEvent.Modifier[] modifierArray3 = this;
        boolean $i$f$mapNotNull = false;
        element$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            WatchKey watchKey;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Path path4 = (Path)element$iv$iv;
            boolean bl2 = false;
            if (super.getWatcher() != null) {
                WatchService it;
                boolean bl3 = false;
                WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
                watchKey = path4.register(it, kindArray, Arrays.copyOf(modifiers, modifiers.length));
            } else {
                watchKey = null;
            }
            if (watchKey == null) continue;
            WatchKey it$iv$iv = watchKey;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        modifierArray3.packageWatchKeys = (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final EmbeddedServer<TEngine, TConfiguration> start(boolean wait) {
        ShutdownHookKt.addShutdownHook(this, (Function0<Unit>)((Function0)() -> EmbeddedServer.start$lambda$22(this)));
        ReentrantReadWriteLock reentrantReadWriteLock = this.applicationInstanceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Pair<Application, ClassLoader> pair;
            boolean bl = false;
            try {
                pair = this.createApplication();
            }
            catch (Throwable cause) {
                this.destroyApplication();
                if (!((Collection)this.watchPatterns).isEmpty()) {
                    this.cleanupWatcher();
                }
                throw cause;
            }
            Pair<Application, ClassLoader> pair2 = pair;
            Application application = (Application)((Object)pair2.component1());
            ClassLoader classLoader = (ClassLoader)pair2.component2();
            this.applicationInstance = application;
            this.applicationClassLoader = classLoader;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.getApplication().getCoroutineContext()), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.getEngine().resolvedConnectors((Continuation<List<EngineConnectorConfig>>)((Continuation)this));
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = (Iterable)v0;
                        var3_4 = this.this$0;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (EngineConnectorConfig)element$iv;
                            $i$a$-forEach-EmbeddedServer$start$3$1 = false;
                            host = EngineUtilsJvmKt.escapeHostname(it.getHost());
                            v1 = var3_4.getEnvironment().getLog();
                            v2 = new StringBuilder().append("Responding at ");
                            v3 = it.getType().getName().toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toLowerCase(...)");
                            v1.info(v2.append(v3).append("://").append(host).append(':').append(it.getPort()).toString());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.engine.start(wait);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(long shutdownGracePeriod, long shutdownTimeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        try {
            this.engine.stop(timeUnit.toMillis(shutdownGracePeriod), timeUnit.toMillis(shutdownTimeout));
        }
        catch (Exception e) {
            this.environment.getLog().warn("Exception occurred during engine shutdown", (Throwable)e);
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.applicationInstanceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.destroyApplication();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (!((Collection)this.watchPatterns).isEmpty()) {
            this.cleanupWatcher();
        }
    }

    public final void stop(long gracePeriodMillis, long timeoutMillis) {
        this.stop(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public static /* synthetic */ void stop$default(EmbeddedServer embeddedServer, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        if ((n & 2) != 0) {
            l2 = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        embeddedServer.stop(l, l2);
    }

    private final Application instantiateAndConfigureApplication(ClassLoader currentClassLoader) {
        Application application;
        if (this.recreateInstance || this.applicationInstance == null) {
            application = new Application(this.environment, this.rootConfig.getDevelopmentMode(), this.rootConfig.getRootPath(), this.monitor, this.rootConfig.getParentCoroutineContext(), (Function0<? extends ApplicationEngine>)((Function0)new PropertyReference0Impl(this){

                public Object get() {
                    return ((EmbeddedServer)this.receiver).getEngine();
                }
            }));
        } else {
            this.recreateInstance = true;
            Application application2 = this.applicationInstance;
            application = application2;
            Intrinsics.checkNotNull((Object)((Object)application2));
        }
        Application newInstance2 = application;
        this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStarting(), newInstance2);
        this.avoidingDoubleStartup((Function1<Continuation<Unit>, Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, newInstance2, currentClassLoader, null){
            int label;
            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
            final /* synthetic */ Application $newInstance;
            final /* synthetic */ ClassLoader $currentClassLoader;
            {
                this.this$0 = $receiver;
                this.$newInstance = $newInstance;
                this.$currentClassLoader = $currentClassLoader;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TimeoutKt.withTimeout-KLykuaI((long)ApplicationModulesKt.getStartupTimeout(this.this$0.getEnvironment()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$newInstance, this.$currentClassLoader, null){
                            int label;
                            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
                            final /* synthetic */ Application $newInstance;
                            final /* synthetic */ ClassLoader $currentClassLoader;
                            {
                                this.this$0 = $receiver;
                                this.$newInstance = $newInstance;
                                this.$currentClassLoader = $currentClassLoader;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = ApplicationModules_jvmKt.getModuleLoader(this.this$0.getEnvironment()).loadModules(this.$newInstance, this.$currentClassLoader, EmbeddedServer.access$getModules(this.this$0), (Continuation<? super Unit>)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        this.monitor.raise(DefaultApplicationEventsKt.getApplicationModulesLoaded(), (Object)newInstance2);
        this.monitor.raise(DefaultApplicationEventsKt.getApplicationStarted(), (Object)newInstance2);
        return newInstance2;
    }

    private final DynamicApplicationModule dynamicModule(String name2) {
        return new DynamicApplicationModule(name2, (Function3<? super Application, ? super ClassLoader, ? super Continuation<? super Unit>, ? extends Object>)((Function3)new Function3<Application, ClassLoader, Continuation<? super Unit>, Object>(this, name2, null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Application $this$DynamicApplicationModule = (Application)((Object)this.L$0);
                        ClassLoader classLoader = (ClassLoader)this.L$1;
                        Application application = $this$DynamicApplicationModule;
                        this.L$0 = null;
                        this.label = 1;
                        Object object3 = EmbeddedServer.access$launchModuleByName(this.this$0, this.$name, classLoader, application, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(Application p1, ClassLoader p2, Continuation<? super Unit> p3) {
                Function3<Application, ClassLoader, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                function3.L$1 = p2;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        }));
    }

    private final DynamicApplicationModule toDynamicModuleOrNull(Function2<? super Application, ? super Continuation<? super Unit>, ? extends Object> $this$toDynamicModuleOrNull) {
        Object $this$toDynamicModuleOrNull_u24lambda_u2425;
        if (!this.rootConfig.getDevelopmentMode()) {
            return null;
        }
        Function2<? super Application, ? super Continuation<? super Unit>, ? extends Object> module = $this$toDynamicModuleOrNull;
        Function2<? super Application, ? super Continuation<? super Unit>, ? extends Object> function2 = $this$toDynamicModuleOrNull;
        try {
            $this$toDynamicModuleOrNull_u24lambda_u2425 = function2;
            boolean bl = false;
            $this$toDynamicModuleOrNull_u24lambda_u2425 = Result.constructor-impl((Object)ServerHostUtilsKt.methodName((Function)module));
        }
        catch (Throwable bl) {
            $this$toDynamicModuleOrNull_u24lambda_u2425 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        function2 = $this$toDynamicModuleOrNull_u24lambda_u2425;
        Throwable throwable = Result.exceptionOrNull-impl(function2);
        if (throwable != null) {
            Object cause = $this$toDynamicModuleOrNull_u24lambda_u2425 = throwable;
            boolean bl = false;
            this.environment.getLog().debug("Module can't be loaded dynamically, auto-reloading won't work for this module", cause);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl(function2);
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            return null;
        }
        String name2 = (String)function2;
        return new DynamicApplicationModule(name2, (Function3<? super Application, ? super ClassLoader, ? super Continuation<? super Unit>, ? extends Object>)((Function3)new Function3<Application, ClassLoader, Continuation<? super Unit>, Object>(this, name2, module, null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ Function2<Application, Continuation<? super Unit>, Object> $module;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                this.$module = $module;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Application $this$DynamicApplicationModule = (Application)((Object)this.L$0);
                        ClassLoader classLoader = (ClassLoader)this.L$1;
                        Application application = $this$DynamicApplicationModule;
                        this.L$0 = $this$DynamicApplicationModule;
                        this.L$1 = application;
                        this.label = 1;
                        Object object3 = EmbeddedServer.access$launchModuleByName(this.this$0, this.$name, classLoader, application, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object4;
                        void $result;
                        Object object3;
                        Application application = (Application)((Object)this.L$1);
                        Application $this$DynamicApplicationModule = (Application)((Object)this.L$0);
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (ReloadingException cause) {
                            $this$DynamicApplicationModule.getEnvironment().getLog().debug("Failed to load module '" + this.$name + "' by classpath reference, falling back to currently loaded value", (Throwable)cause);
                            this.L$0 = null;
                            this.L$1 = null;
                            this.label = 2;
                            object4 = this.$module.invoke((Object)((Object)application), (Object)((Object)this));
                            if (object4 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                    }
                    case 2: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(Application p1, ClassLoader p2, Continuation<? super Unit> p3) {
                Function3<Application, ClassLoader, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                function3.L$1 = p2;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        }));
    }

    private final DynamicApplicationModule wrapWithDynamicModule(Function2<? super Application, ? super Continuation<? super Unit>, ? extends Object> $this$wrapWithDynamicModule) {
        Function2<? super Application, ? super Continuation<? super Unit>, ? extends Object> module = $this$wrapWithDynamicModule;
        return new DynamicApplicationModule(null, (Function3)new Function3<Application, ClassLoader, Continuation<? super Unit>, Object>(module, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function2<Application, Continuation<? super Unit>, Object> $module;
            {
                this.$module = $module;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Application $this$DynamicApplicationModule = (Application)((Object)this.L$0);
                        this.label = 1;
                        Object object3 = this.$module.invoke((Object)((Object)$this$DynamicApplicationModule), (Object)((Object)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(Application p1, ClassLoader p2, Continuation<? super Unit> p3) {
                Function3<Application, ClassLoader, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        }, 1, null);
    }

    private final Object launchModuleByName(String name2, ClassLoader currentClassLoader, Application newInstance2, Continuation<? super Unit> $completion) {
        Object object = this.avoidingDoubleStartupFor(name2, (Function1<Continuation<Unit>, Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(currentClassLoader, name2, newInstance2, this, null){
            int label;
            final /* synthetic */ ClassLoader $currentClassLoader;
            final /* synthetic */ String $name;
            final /* synthetic */ Application $newInstance;
            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
            {
                this.$currentClassLoader = $currentClassLoader;
                this.$name = $name;
                this.$newInstance = $newInstance;
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = CallableUtilsKt.executeModuleFunction(this.$currentClassLoader, this.$name, this.$newInstance, EmbeddedServer.access$getModuleInjector(this.this$0), (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void avoidingDoubleStartup(Function1<? super Continuation<? super Unit>, ? extends Object> block) {
        try {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(block, null){
                int label;
                final /* synthetic */ Function1<Continuation<? super Unit>, Object> $block;
                {
                    this.$block = $block;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.$block.invoke((Object)((Object)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        finally {
            List<String> list2 = AutoReloadUtilsKt.getCurrentStartupModules().get();
            if (list2 != null) {
                List<String> it = list2;
                boolean bl = false;
                if (it.isEmpty()) {
                    AutoReloadUtilsKt.getCurrentStartupModules().remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object avoidingDoubleStartupFor(String var1_1, Function1<? super Continuation<? super Unit>, ? extends Object> var2_2, Continuation<? super Unit> $completion) {
        if (!($completion instanceof avoidingDoubleStartupFor.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EmbeddedServer.access$avoidingDoubleStartupFor(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = AutoReloadUtilsKt.getCurrentStartupModules();
                v0 = var5_7.get();
                if (v0 == null) {
                    $i$a$-getOrSet-EmbeddedServer$avoidingDoubleStartupFor$modules$1 = false;
                    var7_13 = $i$a$-getOrSet-EmbeddedServer$avoidingDoubleStartupFor$modules$1 = (List)new ArrayList<E>(1);
                    var5_7.set(var7_13);
                    v0 = $i$a$-getOrSet-EmbeddedServer$avoidingDoubleStartupFor$modules$1;
                }
                if (!((modules = v0).contains(fqName) == false)) {
                    $i$a$-check-EmbeddedServer$avoidingDoubleStartupFor$2 = false;
                    var6_12 = "Module startup is already in progress for function " + fqName + " (recursive module startup from module main?)";
                    throw new IllegalStateException(var6_12.toString());
                }
                modules.add((String)fqName);
                $continuation.L$0 = fqName;
                $continuation.L$1 = modules;
                $continuation.label = 1;
                v1 = block.invoke((Object)$continuation);
                ** if (v1 != var10_6) goto lbl33
lbl32:
                // 1 sources

                return var10_6;
lbl33:
                // 1 sources

                ** GOTO lbl48
            }
            case 1: {
                modules = (List)$continuation.L$1;
                fqName = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
                catch (Throwable var5_8) {
                    throw var5_8;
                }
                finally {
                    modules.remove(fqName);
                }
lbl48:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void cleanupWatcher() {
        EmbeddedServer embeddedServer = this;
        try {
            Unit unit;
            EmbeddedServer $this$cleanupWatcher_u24lambda_u2431 = embeddedServer;
            boolean bl = false;
            WatchService watchService = $this$cleanupWatcher_u24lambda_u2431.getWatcher();
            if (watchService != null) {
                watchService.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private static final ModuleParametersInjector moduleInjector_delegate$lambda$1() {
        boolean $i$f$loadServiceOrNull = false;
        boolean $i$f$loadServicesAsSequence = false;
        Iterator<ModuleParametersInjector> iterator2 = ServiceLoader.load(ModuleParametersInjector.class, ModuleParametersInjector.class.getClassLoader()).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        ModuleParametersInjector moduleParametersInjector = (ModuleParametersInjector)SequencesKt.firstOrNull((Sequence)SequencesKt.asSequence(iterator2));
        if (moduleParametersInjector == null) {
            moduleParametersInjector = ModuleParametersInjector.Companion.getDisabled$ktor_server_core();
        }
        return moduleParametersInjector;
    }

    /*
     * WARNING - void declaration
     */
    private static final List modules_delegate$lambda$3(EmbeddedServer this$0) {
        Function2 p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = ApplicationModulesKt.getModuleConfigReferences(this$0.environment);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.dynamicModule((String)p0));
        }
        $this$map$iv = this$0.rootConfig.getModules$ktor_server_core();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void module;
            p0 = (Function2)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            DynamicApplicationModule dynamicApplicationModule = this$0.toDynamicModuleOrNull((Function2<Application, Continuation<Unit>, Object>)module);
            if (dynamicApplicationModule == null) {
                dynamicApplicationModule = this$0.wrapWithDynamicModule((Function2<Application, Continuation<Unit>, Object>)module);
            }
            collection2.add(dynamicApplicationModule);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    private static final WatchService watcher_delegate$lambda$4() {
        WatchService watchService;
        try {
            watchService = FileSystems.getDefault().newWatchService();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            watchService = null;
        }
        return watchService;
    }

    private static final Unit start$lambda$22(EmbeddedServer this$0) {
        EmbeddedServer.stop$default(this$0, 0L, 0L, 3, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ List access$getModules(EmbeddedServer $this) {
        return $this.getModules();
    }

    public static final /* synthetic */ Object access$launchModuleByName(EmbeddedServer $this, String name2, ClassLoader currentClassLoader, Application newInstance2, Continuation $completion) {
        return $this.launchModuleByName(name2, currentClassLoader, newInstance2, (Continuation<Unit>)$completion);
    }

    public static final /* synthetic */ ModuleParametersInjector access$getModuleInjector(EmbeddedServer $this) {
        return $this.getModuleInjector();
    }

    public static final /* synthetic */ Object access$avoidingDoubleStartupFor(EmbeddedServer $this, String fqName, Function1 block, Continuation $completion) {
        return $this.avoidingDoubleStartupFor(fqName, (Function1<Continuation<Unit>, Object>)block, (Continuation<Unit>)$completion);
    }

    public static final /* synthetic */ Application access$currentApplication(EmbeddedServer $this) {
        return $this.currentApplication();
    }
}

