/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.http.ContentType;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.content.OutgoingContent;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.application.PipelineCallKt;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.engine.LongKt;
import io.ktor.server.engine.internal.ApplicationUtilsJvmKt;
import io.ktor.server.engine.internal.ExceptionPageContent;
import io.ktor.server.response.ApplicationResponsePropertiesKt;
import io.ktor.server.response.ApplicationSendPipeline;
import io.ktor.server.response.PipelineResponse;
import io.ktor.server.response.ResponseCookies;
import io.ktor.server.response.ResponseHeaders;
import io.ktor.util.AttributeKey;
import io.ktor.util.cio.ChannelWriteException;
import io.ktor.util.internal.ExceptionUtilsJvmKt;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteReadChannelKt;
import io.ktor.utils.io.ByteReadChannelOperationsKt;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.ByteWriteChannelKt;
import io.ktor.utils.io.ByteWriteChannelOperationsKt;
import io.ktor.utils.io.ClosedWriteChannelException;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CopyableThrowable;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@SourceDebugExtension(value={"SMAP\nBaseApplicationResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseApplicationResponse.kt\nio/ktor/server/engine/BaseApplicationResponse\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Readers.kt\nio/ktor/util/cio/ReadersKt\n+ 4 Attributes.kt\nio/ktor/util/AttributesKt\n+ 5 Type.kt\nio/ktor/util/reflect/TypeKt\n*L\n1#1,372:1\n1#2:373\n33#3,10:374\n33#3,10:384\n21#4:394\n69#5:395\n84#5,8:396\n*S KotlinDebug\n*F\n+ 1 BaseApplicationResponse.kt\nio/ktor/server/engine/BaseApplicationResponse\n*L\n181#1:374,10\n220#1:384,10\n320#1:394\n320#1:395\n320#1:396,8\n*E\n"})
public abstract class BaseApplicationResponse
implements PipelineResponse {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final PipelineCall call;
    @Nullable
    private HttpStatusCode status;
    private boolean isSent;
    @NotNull
    private final Lazy cookies$delegate;
    private boolean responded;
    @NotNull
    private final ApplicationSendPipeline pipeline;
    @NotNull
    private static final AttributeKey<BaseApplicationResponse> EngineResponseAttributeKey;

    /*
     * WARNING - void declaration
     */
    public BaseApplicationResponse(@NotNull PipelineCall call2) {
        void $this$pipeline_u24lambda_u241;
        ApplicationSendPipeline applicationSendPipeline;
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        this.call = call2;
        this.cookies$delegate = LazyKt.lazy(() -> BaseApplicationResponse.cookies_delegate$lambda$0(this));
        ApplicationSendPipeline applicationSendPipeline2 = applicationSendPipeline = new ApplicationSendPipeline(this.call.getApplication().getDevelopmentMode());
        BaseApplicationResponse baseApplicationResponse = this;
        boolean bl = false;
        $this$pipeline_u24lambda_u241.resetFrom((Pipeline)this.call.getApplication().getSendPipeline());
        baseApplicationResponse.pipeline = applicationSendPipeline;
    }

    @Override
    public boolean isCommitted() {
        return this.responded;
    }

    @Override
    @NotNull
    public ResponseCookies getCookies() {
        Lazy lazy = this.cookies$delegate;
        return (ResponseCookies)lazy.getValue();
    }

    @Override
    @Nullable
    public HttpStatusCode status() {
        return this.status;
    }

    @Override
    public void status(@NotNull HttpStatusCode value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.status = value2;
        this.setStatus(value2);
    }

    @Override
    @NotNull
    public final ApplicationSendPipeline getPipeline() {
        return this.pipeline;
    }

    protected final void commitHeaders(@NotNull OutgoingContent content2) {
        String connection;
        OutgoingContent outgoingContent;
        HttpStatusCode httpStatusCode;
        HttpStatusCode it;
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        if (this.responded) {
            throw new ResponseAlreadySentException();
        }
        this.responded = true;
        Ref.BooleanRef transferEncodingSet = new Ref.BooleanRef();
        HttpStatusCode httpStatusCode2 = content2.getStatus();
        if (httpStatusCode2 != null) {
            it = httpStatusCode2;
            boolean bl = false;
            this.status(it);
            httpStatusCode = Unit.INSTANCE;
        } else {
            httpStatusCode = this.status();
            if (httpStatusCode == null) {
                this.status(HttpStatusCode.Companion.getOK());
                httpStatusCode = Unit.INSTANCE;
            }
        }
        content2.getHeaders().forEach((arg_0, arg_1) -> BaseApplicationResponse.commitHeaders$lambda$3(transferEncodingSet, content2, this, arg_0, arg_1));
        Long contentLength = content2.getContentLength();
        if (contentLength != null) {
            this.getHeaders().append(HttpHeaders.INSTANCE.getContentLength(), LongKt.toStringFast(contentLength), false);
        } else if (!transferEncodingSet.element && !((outgoingContent = content2) instanceof OutgoingContent.ProtocolUpgrade)) {
            if (outgoingContent instanceof OutgoingContent.NoContent) {
                this.getHeaders().append(HttpHeaders.INSTANCE.getContentLength(), "0", false);
            } else {
                this.getHeaders().append(HttpHeaders.INSTANCE.getTransferEncoding(), "chunked", false);
            }
        }
        if (!this.getHeaders().contains(HttpHeaders.INSTANCE.getContentType())) {
            ContentType contentType = content2.getContentType();
            if (contentType != null) {
                it = contentType;
                boolean bl = false;
                this.getHeaders().append(HttpHeaders.INSTANCE.getContentType(), it.toString(), false);
            }
        }
        if ((connection = this.call.getRequest().getHeaders().get(HttpHeaders.INSTANCE.getConnection())) != null && !this.call.getResponse().getHeaders().contains(HttpHeaders.INSTANCE.getConnection())) {
            if (StringsKt.equals((String)connection, (String)"close", (boolean)true)) {
                ApplicationResponsePropertiesKt.header(this, "Connection", "close");
            } else if (StringsKt.equals((String)connection, (String)"keep-alive", (boolean)true)) {
                ApplicationResponsePropertiesKt.header(this, "Connection", "keep-alive");
            }
        }
    }

    @Nullable
    protected Object respondOutgoingContent(@NotNull OutgoingContent content2, @NotNull Continuation<? super Unit> $completion) {
        return BaseApplicationResponse.respondOutgoingContent$suspendImpl(this, content2, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ Object respondOutgoingContent$suspendImpl(BaseApplicationResponse var0, OutgoingContent var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof respondOutgoingContent.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ BaseApplicationResponse this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondOutgoingContent$suspendImpl(this.this$0, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = content;
                if (!(var3_6 instanceof OutgoingContent.ProtocolUpgrade)) ** GOTO lbl26
                $this.commitHeaders((OutgoingContent)content);
                $continuation.L$0 = $this;
                $continuation.label = 1;
                v0 = $this.respondUpgrade((OutgoingContent.ProtocolUpgrade)content, (Continuation<? super Unit>)$continuation);
                if (v0 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl104
            }
            case 1: {
                $this = (BaseApplicationResponse)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                ** GOTO lbl104
            }
lbl26:
            // 1 sources

            if (!(var3_6 instanceof OutgoingContent.ByteArrayContent)) ** GOTO lbl40
            bytes = ((OutgoingContent.ByteArrayContent)content).bytes();
            $this.commitHeaders((OutgoingContent)content);
            $continuation.L$0 = $this;
            $continuation.label = 2;
            v1 = $this.respondFromBytes(bytes, (Continuation<? super Unit>)$continuation);
            if (v1 == var8_5) {
                return var8_5;
            }
            ** GOTO lbl104
            case 2: {
                $this = (BaseApplicationResponse)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                ** GOTO lbl104
            }
lbl40:
            // 1 sources

            if (!(var3_6 instanceof OutgoingContent.WriteChannelContent)) ** GOTO lbl53
            $this.commitHeaders((OutgoingContent)content);
            $continuation.L$0 = $this;
            $continuation.label = 3;
            v2 = $this.respondWriteChannelContent((OutgoingContent.WriteChannelContent)content, (Continuation<? super Unit>)$continuation);
            if (v2 == var8_5) {
                return var8_5;
            }
            ** GOTO lbl104
            case 3: {
                $this = (BaseApplicationResponse)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                ** GOTO lbl104
            }
lbl53:
            // 1 sources

            if (!(var3_6 instanceof OutgoingContent.ReadChannelContent)) ** GOTO lbl80
            readChannel = ((OutgoingContent.ReadChannelContent)content).readFrom();
            $this.commitHeaders((OutgoingContent)content);
            $continuation.L$0 = $this;
            $continuation.L$1 = readChannel;
            $continuation.label = 4;
            v3 = $this.respondFromChannel(readChannel, (Continuation<? super Unit>)$continuation);
            v4 = v3;
            if (v3 == var8_5) {
                return var8_5;
            }
            ** GOTO lbl104
            case 4: {
                readChannel = (ByteReadChannel)$continuation.L$1;
                $this = (BaseApplicationResponse)$continuation.L$0;
                ** try [egrp 1[TRYBLOCK] [1 : 388->397)] { 
lbl73:
                // 1 sources

                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
                ** GOTO lbl104
lbl77:
                // 1 sources

                finally {
                    ByteReadChannelKt.cancel((ByteReadChannel)readChannel);
                }
            }
lbl80:
            // 1 sources

            if (!(var3_6 instanceof OutgoingContent.NoContent)) ** GOTO lbl93
            $this.commitHeaders((OutgoingContent)content);
            $continuation.L$0 = $this;
            $continuation.label = 5;
            v5 = $this.respondNoContent((OutgoingContent.NoContent)content, (Continuation<? super Unit>)$continuation);
            if (v5 == var8_5) {
                return var8_5;
            }
            ** GOTO lbl104
            case 5: {
                $this = (BaseApplicationResponse)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
                ** GOTO lbl104
            }
lbl93:
            // 1 sources

            if (var3_6 instanceof OutgoingContent.ContentWrapper == false) throw new NoWhenBranchMatchedException();
            $continuation.L$0 = $this;
            $continuation.label = 6;
            v6 = $this.respondOutgoingContent(((OutgoingContent.ContentWrapper)content).delegate(), (Continuation<? super Unit>)$continuation);
            if (v6 == var8_5) {
                return var8_5;
            }
            ** GOTO lbl104
            case 6: {
                $this = (BaseApplicationResponse)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl104:
                // 12 sources

                $this.isSent = true;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object respondNoContent(@NotNull OutgoingContent.NoContent content2, @NotNull Continuation<? super Unit> $completion) {
        return BaseApplicationResponse.respondNoContent$suspendImpl(this, content2, $completion);
    }

    static /* synthetic */ Object respondNoContent$suspendImpl(BaseApplicationResponse $this, OutgoingContent.NoContent content2, Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object respondWriteChannelContent(@NotNull OutgoingContent.WriteChannelContent content2, @NotNull Continuation<? super Unit> $completion) {
        return BaseApplicationResponse.respondWriteChannelContent$suspendImpl(this, content2, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondWriteChannelContent$suspendImpl(BaseApplicationResponse var0, OutgoingContent.WriteChannelContent var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof respondWriteChannelContent.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BaseApplicationResponse this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondWriteChannelContent$suspendImpl(this.this$0, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = content;
                $continuation.label = 1;
                v0 = $this.responseChannel((Continuation<? super ByteWriteChannel>)$continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                content = (OutgoingContent.WriteChannelContent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                $this$use$iv = (ByteWriteChannel)v0;
                $i$f$use = false;
                $this$respondWriteChannelContent_u24lambda_u245 = $this$use$iv;
                $i$a$-use-BaseApplicationResponse$respondWriteChannelContent$2 = false;
                $continuation.L$0 = $this$use$iv;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)ApplicationUtilsJvmKt.getIOBridge(Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(content, $this$respondWriteChannelContent_u24lambda_u245, null){
                    int label;
                    final /* synthetic */ OutgoingContent.WriteChannelContent $content;
                    final /* synthetic */ ByteWriteChannel $this_use;
                    {
                        this.$content = $content;
                        this.$this_use = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.$content.writeTo(this.$this_use, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var11_5) goto lbl35
lbl34:
                // 1 sources

                return var11_5;
lbl35:
                // 1 sources

                ** GOTO lbl56
            }
            case 2: {
                $i$f$use = false;
                $i$a$-use-BaseApplicationResponse$respondWriteChannelContent$2 = false;
                $this$use$iv = (ByteWriteChannel)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    ** GOTO lbl56
                    {
                        catch (ClosedWriteChannelException closed) {
                            throw new ChannelWriteException(null, (Throwable)closed, 1, null);
                        }
                    }
                }
                catch (Throwable cause$iv) {
                    ByteWriteChannelOperationsKt.close((ByteWriteChannel)$this$use$iv, (Throwable)cause$iv);
                    throw cause$iv;
                }
            }
            catch (Throwable var8_14) {
                throw var8_14;
            }
            {
                finally {
                    ByteWriteChannelKt.close((ByteWriteChannel)$this$use$iv);
                }
lbl56:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object respondFromBytes(@NotNull byte[] bytes2, @NotNull Continuation<? super Unit> $completion) {
        return BaseApplicationResponse.respondFromBytes$suspendImpl(this, bytes2, $completion);
    }

    static /* synthetic */ Object respondFromBytes$suspendImpl(BaseApplicationResponse $this, byte[] bytes2, Continuation<? super Unit> $completion) {
        String string = $this.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        if (string != null) {
            long length = Long.parseLong(string);
            boolean bl = false;
            $this.ensureLength(length, bytes2.length);
        }
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getUnconfined()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this, bytes2, null){
            Object L$0;
            int label;
            final /* synthetic */ BaseApplicationResponse this$0;
            final /* synthetic */ byte[] $bytes;
            {
                this.this$0 = $receiver;
                this.$bytes = $bytes;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.responseChannel((Continuation<? super ByteWriteChannel>)((Continuation)this));
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = (ByteWriteChannel)v0;
                        var3_4 = this.$bytes;
                        $i$f$use = false;
                        $this$invokeSuspend_u24lambda_u240 = $this$use$iv;
                        $i$a$-use-BaseApplicationResponse$respondFromBytes$3$1 = false;
                        this.L$0 = $this$use$iv;
                        this.label = 2;
                        v1 = ByteWriteChannelOperationsKt.writeFully$default((ByteWriteChannel)$this$invokeSuspend_u24lambda_u240, (byte[])var3_4, (int)0, (int)0, (Continuation)this, (int)6, null);
                        ** if (v1 != var8_2) goto lbl25
lbl24:
                        // 1 sources

                        return var8_2;
lbl25:
                        // 1 sources

                        ** GOTO lbl43
                    }
                    case 2: {
                        $i$f$use = false;
                        $i$a$-use-BaseApplicationResponse$respondFromBytes$3$1 = false;
                        $this$use$iv = (ByteWriteChannel)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl43
                        }
                        catch (Throwable cause$iv) {
                            ByteWriteChannelOperationsKt.close((ByteWriteChannel)$this$use$iv, (Throwable)cause$iv);
                            throw cause$iv;
                        }
                    }
                    catch (Throwable var7_11) {
                        throw var7_11;
                    }
                    {
                        finally {
                            ByteWriteChannelKt.close((ByteWriteChannel)$this$use$iv);
                        }
lbl43:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object respondFromChannel(@NotNull ByteReadChannel readChannel, @NotNull Continuation<? super Unit> $completion) {
        return BaseApplicationResponse.respondFromChannel$suspendImpl(this, readChannel, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondFromChannel$suspendImpl(BaseApplicationResponse var0, ByteReadChannel var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof respondFromChannel.1)) ** GOTO lbl-1000
        var14_3 = $completion;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ BaseApplicationResponse this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondFromChannel$suspendImpl(this.this$0, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this;
                $continuation.L$1 = readChannel;
                $continuation.label = 1;
                v0 = $this.responseChannel((Continuation<? super ByteWriteChannel>)$continuation);
                if (v0 == var15_5) {
                    return var15_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                readChannel = (ByteReadChannel)$continuation.L$1;
                $this = (BaseApplicationResponse)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                $this$use$iv = (ByteWriteChannel)v0;
                $i$f$use = false;
                $this$respondFromChannel_u24lambda_u247 = $this$use$iv;
                $i$a$-use-BaseApplicationResponse$respondFromChannel$2 = false;
                v1 = $this.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
                length = v1 != null ? Boxing.boxLong((long)Long.parseLong(v1)) : null;
                $continuation.L$0 = $this;
                $continuation.L$1 = readChannel;
                $continuation.L$2 = $this$use$iv;
                $continuation.L$3 = length;
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getUnconfined()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(readChannel, $this$respondFromChannel_u24lambda_u247, length, null){
                    int label;
                    final /* synthetic */ ByteReadChannel $readChannel;
                    final /* synthetic */ ByteWriteChannel $this_use;
                    final /* synthetic */ Long $length;
                    {
                        this.$readChannel = $readChannel;
                        this.$this_use = $receiver;
                        this.$length = $length;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Long l = this.$length;
                                this.label = 1;
                                Object object3 = ByteReadChannelOperationsKt.copyTo((ByteReadChannel)this.$readChannel, (ByteWriteChannel)this.$this_use, (long)(l != null ? l : Long.MAX_VALUE), (Continuation)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Long> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v2 != var15_5) goto lbl40
lbl39:
                // 1 sources

                return var15_5;
lbl40:
                // 1 sources

                ** GOTO lbl52
            }
            case 2: {
                $i$f$use = false;
                $i$a$-use-BaseApplicationResponse$respondFromChannel$2 = false;
                length = (Long)$continuation.L$3;
                $this$use$iv = (ByteWriteChannel)$continuation.L$2;
                readChannel = (ByteReadChannel)$continuation.L$1;
                $this = (BaseApplicationResponse)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl52:
                // 2 sources

                copied = ((Number)v2).longValue();
                v3 = length;
                if (v3 != null) ** GOTO lbl56
                ** GOTO lbl90
lbl56:
                // 1 sources

                v3.longValue();
                $continuation.L$0 = $this;
                $continuation.L$1 = $this$use$iv;
                $continuation.L$2 = length;
                $continuation.L$3 = null;
                $continuation.J$0 = copied;
                $continuation.label = 3;
                v4 = ByteReadChannelOperationsKt.discard((ByteReadChannel)readChannel, (long)1L, (Continuation)$continuation);
                ** if (v4 != var15_5) goto lbl66
lbl65:
                // 1 sources

                return var15_5;
lbl66:
                // 1 sources

                ** GOTO lbl78
            }
            case 3: {
                $i$f$use = false;
                $i$a$-use-BaseApplicationResponse$respondFromChannel$2 = false;
                copied = $continuation.J$0;
                length = (Long)$continuation.L$2;
                $this$use$iv = (ByteWriteChannel)$continuation.L$1;
                $this = (BaseApplicationResponse)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl78:
                    // 2 sources

                    discarded = ((Number)v4).longValue();
                    $this.ensureLength(length, copied + discarded);
                    ** GOTO lbl90
                }
                catch (Throwable cause$iv) {
                    ByteWriteChannelOperationsKt.close((ByteWriteChannel)$this$use$iv, (Throwable)cause$iv);
                    throw cause$iv;
                }
            }
            catch (Throwable var12_18) {
                throw var12_18;
            }
            {
                finally {
                    ByteWriteChannelKt.close((ByteWriteChannel)$this$use$iv);
                }
lbl90:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void ensureLength(long expected, long actual) {
        if (expected < actual) {
            throw new BodyLengthIsTooLong(expected);
        }
        if (expected > actual) {
            throw new BodyLengthIsTooSmall(expected, actual);
        }
    }

    @Nullable
    protected abstract Object respondUpgrade(@NotNull OutgoingContent.ProtocolUpgrade var1, @NotNull Continuation<? super Unit> var2);

    @Nullable
    protected abstract Object responseChannel(@NotNull Continuation<? super ByteWriteChannel> var1);

    protected abstract void setStatus(@NotNull HttpStatusCode var1);

    private static final ResponseCookies cookies_delegate$lambda$0(BaseApplicationResponse this$0) {
        return new ResponseCookies(this$0);
    }

    private static final Unit commitHeaders$lambda$3(Ref.BooleanRef $transferEncodingSet, OutgoingContent $content, BaseApplicationResponse this$0, String name2, List values) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        String string = name2;
        if (Intrinsics.areEqual((Object)string, (Object)HttpHeaders.INSTANCE.getTransferEncoding())) {
            $transferEncodingSet.element = true;
        } else if (Intrinsics.areEqual((Object)string, (Object)HttpHeaders.INSTANCE.getUpgrade())) {
            if (!($content instanceof OutgoingContent.ProtocolUpgrade)) {
                throw new InvalidHeaderForContent(HttpHeaders.INSTANCE.getUpgrade(), "non-upgrading response");
            }
            for (String value2 : values) {
                this$0.getHeaders().append(name2, value2, false);
            }
            return Unit.INSTANCE;
        }
        for (String value3 : values) {
            ResponseHeaders.append$default(this$0.getHeaders(), name2, value3, false, 4, null);
        }
        return Unit.INSTANCE;
    }

    static {
        KType kType;
        Companion = new Companion(null);
        String name$iv = "EngineResponse";
        boolean $i$f$AttributeKey = false;
        String string = name$iv;
        boolean $i$f$typeInfo = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(BaseApplicationResponse.class);
        boolean $i$f$typeOfOrNull = false;
        try {
            kType = Reflection.typeOf(BaseApplicationResponse.class);
        }
        catch (Throwable throwable) {
            kType = null;
        }
        KType kType2 = kType;
        KClass kClass2 = kClass;
        TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
        String string2 = string;
        EngineResponseAttributeKey = new AttributeKey(string2, typeInfo);
    }

    public static final class BodyLengthIsTooLong
    extends IllegalStateException
    implements CopyableThrowable<BodyLengthIsTooLong> {
        private final long expected;

        public BodyLengthIsTooLong(long expected) {
            super("Body.size is too long. Expected " + expected);
            this.expected = expected;
        }

        @NotNull
        public BodyLengthIsTooLong createCopy() {
            BodyLengthIsTooLong bodyLengthIsTooLong;
            BodyLengthIsTooLong it = bodyLengthIsTooLong = new BodyLengthIsTooLong(this.expected);
            boolean bl = false;
            ExceptionUtilsJvmKt.initCauseBridge((Throwable)it, (Throwable)this);
            return bodyLengthIsTooLong;
        }
    }

    public static final class BodyLengthIsTooSmall
    extends IllegalStateException
    implements CopyableThrowable<BodyLengthIsTooSmall> {
        private final long expected;
        private final long actual;

        public BodyLengthIsTooSmall(long expected, long actual) {
            super("Body.size is too small. Body: " + actual + ", Content-Length: " + expected);
            this.expected = expected;
            this.actual = actual;
        }

        @NotNull
        public BodyLengthIsTooSmall createCopy() {
            BodyLengthIsTooSmall bodyLengthIsTooSmall;
            BodyLengthIsTooSmall it = bodyLengthIsTooSmall = new BodyLengthIsTooSmall(this.expected, this.actual);
            boolean bl = false;
            ExceptionUtilsJvmKt.initCauseBridge((Throwable)it, (Throwable)this);
            return bodyLengthIsTooSmall;
        }
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeKey<BaseApplicationResponse> getEngineResponseAttributeKey() {
            return EngineResponseAttributeKey;
        }

        public final void setupSendPipeline(@NotNull ApplicationSendPipeline sendPipeline) {
            Intrinsics.checkNotNullParameter((Object)((Object)sendPipeline), (String)"sendPipeline");
            sendPipeline.intercept(ApplicationSendPipeline.Phases.getEngine(), (Function3)new Function3<PipelineContext<Object, PipelineCall>, Object, Continuation<? super Unit>, Object>(null){
                int label;
                private /* synthetic */ Object L$0;
                /* synthetic */ Object L$1;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            PipelineContext $this$intercept = (PipelineContext)this.L$0;
                            Object body = this.L$1;
                            PipelineContext $this$call$iv = $this$intercept;
                            boolean $i$f$getCall = false;
                            if (PipelineCallKt.isHandled((PipelineCall)$this$call$iv.getContext())) {
                                return Unit.INSTANCE;
                            }
                            if (!(body instanceof OutgoingContent)) {
                                throw new IllegalArgumentException("Response pipeline couldn't transform '" + Reflection.getOrCreateKotlinClass(body.getClass()) + "' to the OutgoingContent");
                            }
                            PipelineContext $this$call$iv2 = $this$intercept;
                            boolean $i$f$getCall2 = false;
                            PipelineResponse pipelineResponse = ((PipelineCall)$this$call$iv2.getContext()).getResponse();
                            BaseApplicationResponse baseApplicationResponse = pipelineResponse instanceof BaseApplicationResponse ? (BaseApplicationResponse)pipelineResponse : null;
                            if (baseApplicationResponse == null) {
                                PipelineContext $this$call$iv3 = $this$intercept;
                                boolean $i$f$getCall3 = false;
                                baseApplicationResponse = (BaseApplicationResponse)((PipelineCall)$this$call$iv3.getContext()).getAttributes().get(BaseApplicationResponse.Companion.getEngineResponseAttributeKey());
                            }
                            BaseApplicationResponse response2 = baseApplicationResponse;
                            this.L$0 = null;
                            this.label = 1;
                            Object object3 = response2.respondOutgoingContent((OutgoingContent)body, (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Object invoke(PipelineContext<Object, PipelineCall> p1, Object p2, Continuation<? super Unit> p3) {
                    Function3<PipelineContext<Object, PipelineCall>, Object, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    function3.L$1 = p2;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            });
        }

        public final void setupFallbackResponse$ktor_server_core(@NotNull EnginePipeline application, @NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)((Object)application), (String)"application");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            boolean inDevMode = application.getDevelopmentMode();
            application.intercept(EnginePipeline.Companion.getBefore(), (Function3)new Function3<PipelineContext<Unit, PipelineCall>, Unit, Continuation<? super Unit>, Object>(logger, inDevMode, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Logger $logger;
                final /* synthetic */ boolean $inDevMode;
                {
                    this.$logger = $logger;
                    this.$inDevMode = $inDevMode;
                    super(3, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            PipelineContext $this$intercept = (PipelineContext)this.L$0;
                            this.L$0 = $this$intercept;
                            this.label = 1;
                            Object object3 = $this$intercept.proceed((Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            Object object4;
                            void $result;
                            Object object3;
                            PipelineContext $this$intercept = (PipelineContext)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                object3 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Throwable cause) {
                                OutgoingContent outgoingContent;
                                BaseApplicationResponse response2;
                                PipelineContext $this$call$iv;
                                PipelineContext $this$call$iv2 = $this$intercept;
                                boolean $i$f$getCall = false;
                                if (PipelineCallKt.isHandled((PipelineCall)$this$call$iv2.getContext())) {
                                    return Unit.INSTANCE;
                                }
                                this.$logger.error("Unhandled server error: \"" + cause.getMessage() + '\"', cause);
                                PipelineContext $this$call$iv3 = $this$intercept;
                                boolean $i$f$getCall2 = false;
                                PipelineResponse pipelineResponse = ((PipelineCall)$this$call$iv3.getContext()).getResponse();
                                BaseApplicationResponse baseApplicationResponse = pipelineResponse instanceof BaseApplicationResponse ? (BaseApplicationResponse)pipelineResponse : null;
                                if (baseApplicationResponse == null) {
                                    $this$call$iv = $this$intercept;
                                    boolean $i$f$getCall3 = false;
                                    baseApplicationResponse = response2 = (BaseApplicationResponse)((PipelineCall)$this$call$iv.getContext()).getAttributes().get(BaseApplicationResponse.Companion.getEngineResponseAttributeKey());
                                }
                                if (this.$inDevMode) {
                                    $this$call$iv = $this$intercept;
                                    boolean $i$f$getCall4 = false;
                                    outgoingContent = (OutgoingContent)new ExceptionPageContent((PipelineCall)$this$call$iv.getContext(), cause);
                                } else {
                                    outgoingContent = (OutgoingContent)new OutgoingContent.NoContent(){
                                        private final HttpStatusCode status;
                                        {
                                            this.status = HttpStatusCode.Companion.getInternalServerError();
                                        }

                                        public HttpStatusCode getStatus() {
                                            return this.status;
                                        }
                                    };
                                }
                                OutgoingContent content2 = outgoingContent;
                                this.L$0 = null;
                                this.label = 2;
                                object4 = response2.respondOutgoingContent(content2, (Continuation<? super Unit>)((Continuation)this));
                                if (object4 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                        }
                        case 2: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Object invoke(PipelineContext<Unit, PipelineCall> p1, Unit p2, Continuation<? super Unit> p3) {
                    Function3<PipelineContext<Unit, PipelineCall>, Unit, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class InvalidHeaderForContent
    extends IllegalStateException
    implements CopyableThrowable<InvalidHeaderForContent> {
        @NotNull
        private final String name;
        @NotNull
        private final String content;

        public InvalidHeaderForContent(@NotNull String name2, @NotNull String content2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            super("Header " + name2 + " is not allowed for " + content2);
            this.name = name2;
            this.content = content2;
        }

        @NotNull
        public InvalidHeaderForContent createCopy() {
            InvalidHeaderForContent invalidHeaderForContent;
            InvalidHeaderForContent it = invalidHeaderForContent = new InvalidHeaderForContent(this.name, this.content);
            boolean bl = false;
            ExceptionUtilsJvmKt.initCauseBridge((Throwable)it, (Throwable)this);
            return invalidHeaderForContent;
        }
    }

    public static final class ResponseAlreadySentException
    extends IllegalStateException {
        public ResponseAlreadySentException() {
            super("Response has already been sent");
        }
    }
}

