/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.cio;

import io.ktor.http.HttpMethod;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.http.URLProtocol;
import io.ktor.util.network.NetworkAddressJvmKt;
import java.net.SocketAddress;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CIOConnectionPoint
implements RequestConnectionPoint {
    @Nullable
    private final SocketAddress remoteNetworkAddress;
    @Nullable
    private final SocketAddress localNetworkAddress;
    @NotNull
    private final String version;
    @NotNull
    private final String uri;
    @Nullable
    private final String hostHeaderValue;
    @NotNull
    private final HttpMethod method;
    private final int defaultPort;

    public CIOConnectionPoint(@Nullable SocketAddress remoteNetworkAddress, @Nullable SocketAddress localNetworkAddress, @NotNull String version, @NotNull String uri, @Nullable String hostHeaderValue, @NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.remoteNetworkAddress = remoteNetworkAddress;
        this.localNetworkAddress = localNetworkAddress;
        this.version = version;
        this.uri = uri;
        this.hostHeaderValue = hostHeaderValue;
        this.method = method;
        this.defaultPort = URLProtocol.Companion.createOrDefault(this.getScheme()).getDefaultPort();
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    @NotNull
    public String getUri() {
        return this.uri;
    }

    @NotNull
    public HttpMethod getMethod() {
        return this.method;
    }

    @NotNull
    public String getScheme() {
        return "http";
    }

    @NotNull
    public String getHost() {
        Object object = this.localNetworkAddress;
        if (object == null || (object = NetworkAddressJvmKt.getHostname((SocketAddress)object)) == null) {
            String string = this.hostHeaderValue;
            object = string != null ? StringsKt.substringBefore$default((String)string, (String)":", null, (int)2, null) : "localhost";
        }
        return object;
    }

    public int getPort() {
        String string;
        SocketAddress socketAddress = this.localNetworkAddress;
        return socketAddress != null ? NetworkAddressJvmKt.getPort((SocketAddress)socketAddress) : ((string = this.hostHeaderValue) != null && (string = StringsKt.substringAfter((String)string, (String)":", (String)"80")) != null ? Integer.parseInt(string) : 80);
    }

    public int getLocalPort() {
        SocketAddress socketAddress = this.localNetworkAddress;
        return socketAddress != null ? NetworkAddressJvmKt.getPort((SocketAddress)socketAddress) : this.defaultPort;
    }

    public int getServerPort() {
        String string;
        String string2 = this.hostHeaderValue;
        return string2 != null && (string = StringsKt.substringAfterLast((String)string2, (String)":", (String)String.valueOf(this.defaultPort))) != null ? Integer.parseInt(string) : this.getLocalPort();
    }

    @NotNull
    public String getLocalHost() {
        Object object = this.localNetworkAddress;
        if (object == null || (object = NetworkAddressJvmKt.getHostname((SocketAddress)object)) == null) {
            object = "localhost";
        }
        return object;
    }

    @NotNull
    public String getServerHost() {
        String string = this.hostHeaderValue;
        if (string == null || (string = StringsKt.substringBeforeLast$default((String)string, (String)":", null, (int)2, null)) == null) {
            string = this.getLocalHost();
        }
        return string;
    }

    @NotNull
    public String getLocalAddress() {
        Object object = this.localNetworkAddress;
        if (object == null || (object = NetworkAddressJvmKt.getAddress((SocketAddress)object)) == null) {
            object = "localhost";
        }
        return object;
    }

    @NotNull
    public String getRemoteHost() {
        Object object = this.remoteNetworkAddress;
        if (object == null || (object = NetworkAddressJvmKt.getHostname((SocketAddress)object)) == null) {
            object = "unknown";
        }
        return object;
    }

    public int getRemotePort() {
        SocketAddress socketAddress = this.remoteNetworkAddress;
        return socketAddress != null ? NetworkAddressJvmKt.getPort((SocketAddress)socketAddress) : 0;
    }

    @NotNull
    public String getRemoteAddress() {
        Object object = this.remoteNetworkAddress;
        if (object == null || (object = NetworkAddressJvmKt.getAddress((SocketAddress)object)) == null) {
            object = "unknown";
        }
        return object;
    }

    @NotNull
    public String toString() {
        return "CIOConnectionPoint(uri=" + this.getUri() + ", method=" + this.getMethod() + ", version=" + this.getVersion() + ", localAddress=" + this.getLocalAddress() + ", localPort=" + this.getLocalPort() + ", remoteAddress=" + this.getRemoteAddress() + ", remotePort=" + this.getRemotePort() + ')';
    }
}

