/*
 * Decompiled with CFR 0.152.
 */
package fleet.kernel.rete;

import fleet.kernel.rete.Query;
import fleet.kernel.rete.QueryObserver;
import fleet.kernel.rete.ReteDbSource;
import fleet.kernel.rete.ReteState;
import fleet.kernel.rete.impl.ObservableMatch;
import fleet.kernel.rete.impl.QueryTracingKey;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import java.util.Collection;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRete.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rete.kt\nfleet/kernel/rete/Rete\n+ 2 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,531:1\n18#2:532\n*S KotlinDebug\n*F\n+ 1 Rete.kt\nfleet/kernel/rete/Rete\n*L\n60#1:532\n*E\n"})
public final class Rete
implements CoroutineContext.Element {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean abortOnError;
    @NotNull
    private final SendChannel<Command> commands;
    @NotNull
    private final StateFlow<ReteState> reteState;
    @NotNull
    private final ReteDbSource dbSource;
    @NotNull
    private final CoroutineContext.Key<?> key;
    @NotNull
    private static final KLogger logger;

    public Rete(boolean abortOnError, @NotNull SendChannel<? super Command> commands, @NotNull StateFlow<? extends ReteState> reteState, @NotNull ReteDbSource dbSource) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        Intrinsics.checkNotNullParameter(reteState, (String)"reteState");
        Intrinsics.checkNotNullParameter((Object)dbSource, (String)"dbSource");
        this.abortOnError = abortOnError;
        this.commands = commands;
        this.reteState = reteState;
        this.dbSource = dbSource;
        this.key = Companion;
    }

    public final boolean getAbortOnError$fleet_kernel() {
        return this.abortOnError;
    }

    @NotNull
    public final SendChannel<Command> getCommands$fleet_kernel() {
        return this.commands;
    }

    @NotNull
    public final StateFlow<ReteState> getReteState$fleet_kernel() {
        return this.reteState;
    }

    @NotNull
    public final ReteDbSource getDbSource$fleet_kernel() {
        return this.dbSource;
    }

    @NotNull
    public CoroutineContext.Key<?> getKey() {
        return this.key;
    }

    @NotNull
    public String toString() {
        return "Rete(abortOnError=" + this.abortOnError + ", commands=" + this.commands + ", reteState=" + this.reteState + ", dbSource=" + this.dbSource + ")";
    }

    public int hashCode() {
        int result2 = Boolean.hashCode(this.abortOnError);
        result2 = result2 * 31 + this.commands.hashCode();
        result2 = result2 * 31 + this.reteState.hashCode();
        result2 = result2 * 31 + this.dbSource.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rete)) {
            return false;
        }
        Rete rete = (Rete)other;
        if (this.abortOnError != rete.abortOnError) {
            return false;
        }
        if (!Intrinsics.areEqual(this.commands, rete.commands)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.reteState, rete.reteState)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.dbSource, (Object)rete.dbSource);
    }

    static {
        boolean $i$f$logger = false;
        logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(Rete.class));
    }

    public static sealed interface Command {

        public static final class AddObserver<T>
        implements Command {
            private final long dbTimestamp;
            @NotNull
            private final Collection<ObservableMatch<?>> dependencies;
            @NotNull
            private final Query<?, T> query;
            @Nullable
            private final QueryTracingKey tracingKey;
            @NotNull
            private final ObserverId observerId;
            @NotNull
            private final QueryObserver<T> observer;

            public AddObserver(long dbTimestamp, @NotNull Collection<? extends ObservableMatch<?>> dependencies, @NotNull Query<?, ? extends T> query2, @Nullable QueryTracingKey tracingKey, @NotNull ObserverId observerId, @NotNull QueryObserver<? super T> observer) {
                Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
                Intrinsics.checkNotNullParameter(query2, (String)"query");
                Intrinsics.checkNotNullParameter((Object)observerId, (String)"observerId");
                Intrinsics.checkNotNullParameter(observer, (String)"observer");
                this.dbTimestamp = dbTimestamp;
                this.dependencies = dependencies;
                this.query = query2;
                this.tracingKey = tracingKey;
                this.observerId = observerId;
                this.observer = observer;
            }

            public final long getDbTimestamp() {
                return this.dbTimestamp;
            }

            @NotNull
            public final Collection<ObservableMatch<?>> getDependencies() {
                return this.dependencies;
            }

            @NotNull
            public final Query<?, T> getQuery() {
                return this.query;
            }

            @Nullable
            public final QueryTracingKey getTracingKey() {
                return this.tracingKey;
            }

            @NotNull
            public final ObserverId getObserverId() {
                return this.observerId;
            }

            @NotNull
            public final QueryObserver<T> getObserver() {
                return this.observer;
            }

            @NotNull
            public String toString() {
                return "AddObserver(dbTimestamp=" + this.dbTimestamp + ", dependencies=" + this.dependencies + ", query=" + this.query + ", tracingKey=" + this.tracingKey + ", observerId=" + this.observerId + ", observer=" + this.observer + ")";
            }

            public int hashCode() {
                int result2 = Long.hashCode(this.dbTimestamp);
                result2 = result2 * 31 + ((Object)this.dependencies).hashCode();
                result2 = result2 * 31 + this.query.hashCode();
                result2 = result2 * 31 + (this.tracingKey == null ? 0 : this.tracingKey.hashCode());
                result2 = result2 * 31 + this.observerId.hashCode();
                result2 = result2 * 31 + this.observer.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AddObserver)) {
                    return false;
                }
                AddObserver addObserver = (AddObserver)other;
                if (this.dbTimestamp != addObserver.dbTimestamp) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.dependencies, addObserver.dependencies)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.query, addObserver.query)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.tracingKey, (Object)addObserver.tracingKey)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.observerId, (Object)addObserver.observerId)) {
                    return false;
                }
                return Intrinsics.areEqual(this.observer, addObserver.observer);
            }
        }

        public static final class RemoveObserver
        implements Command {
            @NotNull
            private final ObserverId observerId;

            public RemoveObserver(@NotNull ObserverId observerId) {
                Intrinsics.checkNotNullParameter((Object)observerId, (String)"observerId");
                this.observerId = observerId;
            }

            @NotNull
            public final ObserverId getObserverId() {
                return this.observerId;
            }

            @NotNull
            public String toString() {
                return "RemoveObserver(observerId=" + this.observerId + ")";
            }

            public int hashCode() {
                return this.observerId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RemoveObserver)) {
                    return false;
                }
                RemoveObserver removeObserver = (RemoveObserver)other;
                return Intrinsics.areEqual((Object)this.observerId, (Object)removeObserver.observerId);
            }
        }
    }

    public static final class Companion
    implements CoroutineContext.Key<Rete> {
        private Companion() {
        }

        @NotNull
        public final KLogger getLogger$fleet_kernel() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class ObserverId {
    }
}

