/*
 * Decompiled with CFR 0.152.
 */
package fleet.kernel.rebase;

import com.jetbrains.rhizomedb.APIKt;
import com.jetbrains.rhizomedb.Attribute;
import com.jetbrains.rhizomedb.Change;
import com.jetbrains.rhizomedb.ChangeKt;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.DB;
import com.jetbrains.rhizomedb.DBUtilKt;
import com.jetbrains.rhizomedb.Datom;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.Instruction;
import com.jetbrains.rhizomedb.InstructionEffect;
import com.jetbrains.rhizomedb.Mut;
import com.jetbrains.rhizomedb.Novelty;
import com.jetbrains.rhizomedb.NoveltyKt;
import com.jetbrains.rhizomedb.Q;
import fleet.fastutil.ints.Int2ObjectOpenHashMap;
import fleet.fastutil.ints.IntMap;
import fleet.kernel.DurableEntityKt;
import fleet.kernel.SharedChangeScope;
import fleet.kernel.rebase.EffectsAndNovelty;
import fleet.kernel.rebase.InstructionDecoder;
import fleet.kernel.rebase.InstructionDecodingContext;
import fleet.kernel.rebase.InstructionEncoder;
import fleet.kernel.rebase.InstructionsPair;
import fleet.kernel.rebase.InstructionsRecordingKt;
import fleet.kernel.rebase.LogSegment;
import fleet.kernel.rebase.Memoizer;
import fleet.kernel.rebase.QueryCodingKt;
import fleet.kernel.rebase.RebaseLog;
import fleet.kernel.rebase.RebaseLogEntry;
import fleet.kernel.rebase.RebaseLogKt;
import fleet.kernel.rebase.RebaseLogger;
import fleet.kernel.rebase.RebaseLoopInvariantBroken;
import fleet.kernel.rebase.ReconsiderableBlock;
import fleet.kernel.rebase.SharedBlock;
import fleet.kernel.rebase.SharedInstruction;
import fleet.kernel.rebase.Transaction;
import fleet.rpc.core.AssumptionsViolatedException;
import fleet.util.UID;
import fleet.util.logging.KLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRebaseLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RebaseLog.kt\nfleet/kernel/rebase/RebaseLogKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 DbContext.kt\ncom/jetbrains/rhizomedb/DbContext\n+ 5 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,410:1\n1374#2:411\n1460#2,2:412\n1374#2:414\n1460#2,5:415\n1462#2,3:420\n1374#2:423\n1460#2,5:424\n1374#2:429\n1460#2,5:430\n1563#2:435\n1634#2,3:436\n1563#2:440\n1634#2,3:441\n1803#2,3:444\n1563#2:447\n1634#2,3:448\n1803#2,3:451\n1374#2:454\n1460#2,2:455\n1617#2,9:457\n1869#2:466\n1870#2:468\n1626#2:469\n1462#2,3:470\n774#2:481\n865#2,2:482\n1#3:439\n1#3:467\n91#4,8:473\n42#5,2:484\n42#5,2:486\n*S KotlinDebug\n*F\n+ 1 RebaseLog.kt\nfleet/kernel/rebase/RebaseLogKt\n*L\n149#1:411\n149#1:412,2\n152#1:414\n152#1:415,5\n149#1:420,3\n175#1:423\n175#1:424,5\n176#1:429\n176#1:430,5\n216#1:435\n216#1:436,3\n262#1:440\n262#1:441,3\n262#1:444,3\n274#1:447\n274#1:448,3\n274#1:451,3\n278#1:454\n278#1:455,2\n281#1:457,9\n281#1:466\n281#1:468\n281#1:469\n278#1:470,3\n290#1:481\n290#1:482,2\n281#1:467\n287#1:473,8\n330#1:484,2\n384#1:486,2\n*E\n"})
public final class RebaseLogKt {
    public static final boolean isEmpty(@NotNull LogSegment $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return $this$isEmpty.getEntries().isEmpty();
    }

    @NotNull
    public static final Pair<LogSegment, RebaseLogEntry> advance(@NotNull LogSegment $this$advance, @NotNull Function2<? super DB, ? super RebaseLogEntry, RebaseLogEntry> rebase) {
        Intrinsics.checkNotNullParameter((Object)$this$advance, (String)"<this>");
        Intrinsics.checkNotNullParameter(rebase, (String)"rebase");
        RebaseLogEntry rebasedEntry = (RebaseLogEntry)rebase.invoke((Object)$this$advance.getBase(), CollectionsKt.first((List)$this$advance.getEntries()));
        return TuplesKt.to((Object)new LogSegment(rebasedEntry.getDbAfter(), (fleet.bifurcan.List<RebaseLogEntry>)((Object)$this$advance.getEntries().removeFirst())), (Object)rebasedEntry);
    }

    @NotNull
    public static final LogSegment append(@NotNull LogSegment $this$append, @NotNull RebaseLogEntry entry) {
        Intrinsics.checkNotNullParameter((Object)$this$append, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return LogSegment.copy$default($this$append, null, $this$append.getEntries().addLast(entry), 1, null);
    }

    public static final boolean isEmpty(@NotNull RebaseLog $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return RebaseLogKt.isEmpty($this$isEmpty.getSpeculation()) && RebaseLogKt.isEmpty($this$isEmpty.getRebasing());
    }

    @NotNull
    public static final Pair<RebaseLog, RebaseLogEntry> advance(@NotNull RebaseLog $this$advance) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)$this$advance, (String)"<this>");
        if (!RebaseLogKt.isEmpty($this$advance.getSpeculation())) {
            Pair<LogSegment, RebaseLogEntry> pair2 = RebaseLogKt.advance($this$advance.getSpeculation(), (Function2<? super DB, ? super RebaseLogEntry, RebaseLogEntry>)((Function2)advance.1.INSTANCE));
            LogSegment speculationPrime = (LogSegment)pair2.component1();
            RebaseLogEntry change2 = (RebaseLogEntry)pair2.component2();
            pair = TuplesKt.to((Object)RebaseLog.copy$default($this$advance, speculationPrime, null, 0L, 6, null), (Object)change2);
        } else if (!RebaseLogKt.isEmpty($this$advance.getRebasing())) {
            Pair<LogSegment, RebaseLogEntry> pair3 = RebaseLogKt.advance($this$advance.getRebasing(), (Function2<? super DB, ? super RebaseLogEntry, RebaseLogEntry>)((Function2)advance.2.INSTANCE));
            LogSegment rebasingPrime = (LogSegment)pair3.component1();
            RebaseLogEntry change3 = (RebaseLogEntry)pair3.component2();
            LogSegment logSegment = LogSegment.copy$default($this$advance.getSpeculation(), rebasingPrime.getBase(), null, 2, null);
            pair = TuplesKt.to((Object)RebaseLog.copy$default($this$advance, logSegment, rebasingPrime, 0L, 4, null), (Object)change3);
        } else {
            throw new IllegalStateException("rebase log is empty".toString());
        }
        return pair;
    }

    @Nullable
    public static final RebaseLogEntry firstOrNull(@NotNull RebaseLog $this$firstOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$firstOrNull, (String)"<this>");
        RebaseLogEntry rebaseLogEntry = (RebaseLogEntry)CollectionsKt.firstOrNull((List)$this$firstOrNull.getSpeculation().getEntries());
        if (rebaseLogEntry == null) {
            rebaseLogEntry = (RebaseLogEntry)CollectionsKt.firstOrNull((List)$this$firstOrNull.getRebasing().getEntries());
        }
        return rebaseLogEntry;
    }

    @NotNull
    public static final RebaseLog reset(@NotNull RebaseLog $this$reset, @NotNull DB committedDB) {
        Intrinsics.checkNotNullParameter((Object)$this$reset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)committedDB, (String)"committedDB");
        return RebaseLog.copy$default($this$reset, new LogSegment(committedDB, new fleet.bifurcan.List<RebaseLogEntry>()), new LogSegment(committedDB, $this$reset.getSpeculation().getEntries().concat((PersistentList<RebaseLogEntry>)$this$reset.getRebasing().getEntries())), 0L, 4, null);
    }

    @NotNull
    public static final RebaseLog append(@NotNull RebaseLog $this$append, @NotNull RebaseLogEntry entry) {
        Intrinsics.checkNotNullParameter((Object)$this$append, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return RebaseLog.copy$default($this$append, null, RebaseLogKt.append($this$append.getRebasing(), entry), 0L, 5, null);
    }

    @NotNull
    public static final Pair<RebaseLog, EffectsAndNovelty> consumeTx(@NotNull RebaseLog $this$consumeTx, @NotNull Transaction tx, @NotNull InstructionDecoder instructionDecoder) {
        Intrinsics.checkNotNullParameter((Object)$this$consumeTx, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)instructionDecoder, (String)"instructionDecoder");
        try {
            Pair<DB, EffectsAndNovelty> pair = RebaseLogKt.playTransactionFromRemote($this$consumeTx.getSpeculation().getBase(), tx, instructionDecoder);
            DB committedDB = (DB)pair.component1();
            EffectsAndNovelty effectsAndNovelty = (EffectsAndNovelty)pair.component2();
            return TuplesKt.to((Object)RebaseLogKt.reset($this$consumeTx, committedDB), (Object)effectsAndNovelty);
        }
        catch (Throwable x) {
            throw new RebaseLoopInvariantBroken("failed to play transaction from remote " + tx + "\n" + $this$consumeTx.debugString(), x);
        }
    }

    public static final void invariant(@NotNull RebaseLog $this$invariant, boolean b, @NotNull Function0<String> f) {
        Intrinsics.checkNotNullParameter((Object)$this$invariant, (String)"<this>");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (!b) {
            throw new RebaseLoopInvariantBroken("rebase loop invariant broken " + f.invoke() + "\n" + $this$invariant.debugString(), null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<InstructionEffect> effects(@NotNull RebaseLogEntry $this$effects) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$effects, (String)"<this>");
        Iterable $this$flatMap$iv = $this$effects.getSharedBlocks();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            SharedBlock block = (SharedBlock)element$iv$iv;
            boolean bl = false;
            SharedBlock sharedBlock = block;
            if (sharedBlock instanceof InstructionsPair) {
                list2 = ((InstructionsPair)block).getSharedEffects();
            } else if (sharedBlock instanceof ReconsiderableBlock) {
                void $this$flatMapTo$iv$iv2;
                Iterable $this$flatMap$iv2 = ((ReconsiderableBlock)block).getItems();
                boolean $i$f$flatMap2 = false;
                Iterable iterable2 = $this$flatMap$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                    InstructionsPair it = (InstructionsPair)element$iv$iv2;
                    boolean bl2 = false;
                    Iterable list$iv$iv = it.getSharedEffects();
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                list2 = (List)destination$iv$iv2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Triple<RebaseLog, EffectsAndNovelty, Transaction> ack(@NotNull RebaseLog $this$ack, @NotNull UID txId, boolean failed) {
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)$this$ack, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)txId, (String)"txId");
        RebaseLogEntry unack = RebaseLogKt.firstOrNull($this$ack);
        RebaseLogKt.invariant($this$ack, unack != null, (Function0<String>)((Function0)new Function0<String>(txId){
            final /* synthetic */ UID $txId;
            {
                this.$txId = $txId;
                super(0);
            }

            public final String invoke() {
                return "no transaction to ack: " + this.$txId;
            }
        }));
        RebaseLogKt.invariant($this$ack, unack.getTransaction() != null, (Function0<String>)((Function0)new Function0<String>(txId, unack){
            final /* synthetic */ UID $txId;
            final /* synthetic */ RebaseLogEntry $unack;
            {
                this.$txId = $txId;
                this.$unack = $unack;
                super(0);
            }

            public final String invoke() {
                return "failed to ack " + this.$txId + ", first item in rebase log (" + this.$unack + ") has no transaction";
            }
        }));
        RebaseLogKt.invariant($this$ack, Intrinsics.areEqual((Object)unack.getTransaction().getId(), (Object)txId), (Function0<String>)((Function0)new Function0<String>(unack, txId){
            final /* synthetic */ RebaseLogEntry $unack;
            final /* synthetic */ UID $txId;
            {
                this.$unack = $unack;
                this.$txId = $txId;
                super(0);
            }

            public final String invoke() {
                return "first item in rebase log (" + this.$unack + ") has different id (" + this.$unack.getTransaction().getId() + ") than ack " + this.$txId;
            }
        }));
        Pair<RebaseLog, RebaseLogEntry> pair = RebaseLogKt.advance($this$ack);
        RebaseLog advanced = (RebaseLog)pair.component1();
        RebaseLogEntry rebaseLogEntry = (RebaseLogEntry)pair.component2();
        RebaseLogKt.invariant($this$ack, rebaseLogEntry.getReplayFailed() == failed, (Function0<String>)((Function0)new Function0<String>(txId, rebaseLogEntry, failed){
            final /* synthetic */ UID $txId;
            final /* synthetic */ RebaseLogEntry $rebaseLogEntry;
            final /* synthetic */ boolean $failed;
            {
                this.$txId = $txId;
                this.$rebaseLogEntry = $rebaseLogEntry;
                this.$failed = $failed;
                super(0);
            }

            public final String invoke() {
                return "different success status for tx " + this.$txId + ", failed-locally: " + this.$rebaseLogEntry.getReplayFailed() + " failed-remotely: " + this.$failed;
            }
        }));
        Pair<RebaseLog, List<RebaseLogEntry>> pair2 = RebaseLogKt.skipLocalChanges(advanced);
        RebaseLog finalRebaseLog = (RebaseLog)pair2.component1();
        List localChanges = (List)pair2.component2();
        Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)rebaseLogEntry), (Iterable)localChanges);
        RebaseLog rebaseLog = finalRebaseLog;
        boolean $i$f$flatMap = false;
        void var12_13 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RebaseLogEntry p0 = (RebaseLogEntry)element$iv$iv;
            boolean bl = false;
            list$iv$iv = RebaseLogKt.effects(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)rebaseLogEntry), (Iterable)localChanges);
        List list2 = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RebaseLogEntry c = (RebaseLogEntry)element$iv$iv;
            boolean bl = false;
            list$iv$iv = RebaseLogKt.getSharedNovelty(c);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        Novelty novelty2 = NoveltyKt.toNovelty(list3);
        List list4 = list2;
        Transaction transaction = unack.getTransaction();
        EffectsAndNovelty effectsAndNovelty = new EffectsAndNovelty(list4, novelty2);
        RebaseLog rebaseLog2 = rebaseLog;
        return new Triple((Object)rebaseLog2, (Object)effectsAndNovelty, (Object)transaction);
    }

    @NotNull
    public static final Pair<DB, EffectsAndNovelty> playTransactionFromRemote(@NotNull DB db, @NotNull Transaction transaction, @NotNull InstructionDecoder instructionDecoder) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)instructionDecoder, (String)"instructionDecoder");
        boolean bl = false;
        ArrayList<InstructionEffect> effects = new ArrayList<InstructionEffect>();
        Change change2 = ChangeKt.change$default(db, 0, (Function1)new Function1<ChangeScope, Unit>(effects, instructionDecoder, transaction){
            final /* synthetic */ ArrayList<InstructionEffect> $effects;
            final /* synthetic */ InstructionDecoder $instructionDecoder;
            final /* synthetic */ Transaction $transaction;
            {
                this.$effects = $effects;
                this.$instructionDecoder = $instructionDecoder;
                this.$transaction = $transaction;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(ChangeScope $this$change) {
                void dbContextPrime$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
                DbContext<Mut> dbContext = $this$change.getContext();
                Q q = DBUtilKt.delayingEffects(QueryCodingKt.expandingWithReadTracking($this$change.getContext().getImpl()), (Function1<? super InstructionEffect, Unit>)((Function1)new Function1<InstructionEffect, Unit>(this.$effects){

                    public final void invoke(InstructionEffect p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((ArrayList)this.receiver).add(p0);
                    }
                }));
                InstructionDecoder instructionDecoder = this.$instructionDecoder;
                Transaction transaction = this.$transaction;
                boolean $i$f$alter = false;
                Object oldContext$iv = this_$iv.getPrivateValue();
                this_$iv.setPrivateValue(dbContextPrime$iv);
                try {
                    Intrinsics.checkNotNull((Object)this_$iv, (String)"null cannot be cast to non-null type com.jetbrains.rhizomedb.DbContext<U of com.jetbrains.rhizomedb.DbContext.alter>");
                    void $this$invoke_u24lambda_u240 = this_$iv;
                    boolean bl = false;
                    int n = DurableEntityKt.uidAttribute();
                    InstructionDecodingContext deserContext = new InstructionDecodingContext(instructionDecoder, n, null);
                    for (SharedInstruction i2 : transaction.getInstructions()) {
                        InstructionDecoder $this$invoke_u24lambda_u240_u240 = instructionDecoder;
                        boolean bl2 = false;
                        List<Instruction> instructions = $this$invoke_u24lambda_u240_u240.decode((DbContext<? extends Q>)$this$invoke_u24lambda_u240, deserContext, i2);
                        Iterable $this$forEach$iv = instructions;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Instruction it = (Instruction)element$iv;
                            boolean bl3 = false;
                            DBUtilKt.mutate((DbContext<? extends Mut>)$this$invoke_u24lambda_u240, it);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv.setPrivateValue(oldContext$iv);
                }
            }
        }, 1, null);
        DB dbAfter = change2.getDbAfter().selectPartitions(SetsKt.setOf((Object)2));
        return TuplesKt.to((Object)dbAfter, (Object)new EffectsAndNovelty((List<InstructionEffect>)effects, change2.getNovelty()));
    }

    @NotNull
    public static final Pair<RebaseLog, List<RebaseLogEntry>> skipLocalChanges(@NotNull RebaseLog $this$skipLocalChanges) {
        Intrinsics.checkNotNullParameter((Object)$this$skipLocalChanges, (String)"<this>");
        List ackChanges = new ArrayList();
        RebaseLog l = $this$skipLocalChanges;
        while (!RebaseLogKt.isEmpty(l)) {
            RebaseLogEntry rebaseLogEntry = RebaseLogKt.firstOrNull(l);
            Intrinsics.checkNotNull((Object)rebaseLogEntry);
            if (rebaseLogEntry.getTransaction() != null) break;
            Pair<RebaseLog, RebaseLogEntry> pair = RebaseLogKt.advance(l);
            RebaseLog ll = (RebaseLog)pair.component1();
            RebaseLogEntry c = (RebaseLogEntry)pair.component2();
            ackChanges.add(c);
            l = ll;
        }
        return new Pair((Object)l, (Object)ackChanges);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<IntMap<UID>> speculativeIdMappings(@NotNull RebaseLog $this$speculativeIdMappings) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$speculativeIdMappings, (String)"<this>");
        Iterable $this$map$iv = $this$speculativeIdMappings.getSpeculation().getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entry;
            RebaseLogEntry rebaseLogEntry = (RebaseLogEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(entry.getIdMapping());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Pair<RebaseLog, Transaction> continueRebase(@NotNull RebaseLog $this$continueRebase, @NotNull InstructionEncoder encoder) {
        Transaction transaction;
        Intrinsics.checkNotNullParameter((Object)$this$continueRebase, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        RebaseLogEntry nearestFuture = (RebaseLogEntry)CollectionsKt.first((List)$this$continueRebase.getRebasing().getEntries());
        Pair<LogSegment, RebaseLogEntry> pair = RebaseLogKt.advance($this$continueRebase.getRebasing(), (Function2<? super DB, ? super RebaseLogEntry, RebaseLogEntry>)((Function2)new Function2<DB, RebaseLogEntry, RebaseLogEntry>(encoder, $this$continueRebase){
            final /* synthetic */ InstructionEncoder $encoder;
            final /* synthetic */ RebaseLog $this_continueRebase;
            {
                this.$encoder = $encoder;
                this.$this_continueRebase = $receiver;
                super(2);
            }

            public final RebaseLogEntry invoke(DB base, RebaseLogEntry rebaseLogEntry) {
                Intrinsics.checkNotNullParameter((Object)base, (String)"base");
                Intrinsics.checkNotNullParameter((Object)rebaseLogEntry, (String)"rebaseLogEntry");
                RebaseLogEntry rebaseLogEntry2 = RebaseLogKt.replay(rebaseLogEntry, base);
                if (rebaseLogEntry2 == null) {
                    rebaseLogEntry2 = RebaseLogKt.reconsider(rebaseLogEntry, base, this.$encoder, RebaseLogKt.speculativeIdMappings(this.$this_continueRebase));
                }
                return rebaseLogEntry2;
            }
        }));
        LogSegment rebasingPrime = (LogSegment)pair.component1();
        RebaseLogEntry rebasedEntry = (RebaseLogEntry)pair.component2();
        boolean hadTransaction = nearestFuture.getTransaction() != null;
        boolean hasTransaction = rebasedEntry.getTransaction() != null;
        if (!(hasTransaction == hadTransaction)) {
            boolean bl = false;
            String string = "rebase loop invariant broken, call jetzajac";
            throw new IllegalArgumentException(string.toString());
        }
        Transaction transaction2 = nearestFuture.getTransaction();
        Transaction transaction3 = rebasedEntry.getTransaction();
        long newSendEpoch = !Intrinsics.areEqual((Object)(transaction2 != null ? transaction2.getId() : null), (Object)(transaction3 != null ? transaction3.getId() : null)) ? $this$continueRebase.getSendEpoch() + 1L : $this$continueRebase.getSendEpoch();
        RebaseLog rebaseLogPrime = $this$continueRebase.copy(RebaseLogKt.append($this$continueRebase.getSpeculation(), RebaseLogEntry.copy$default(rebasedEntry, null, null, null, null, null, newSendEpoch, false, 95, null)), rebasingPrime, newSendEpoch);
        Transaction transaction4 = transaction = rebasedEntry.getTransaction();
        RebaseLog rebaseLog = rebaseLogPrime;
        boolean bl = false;
        boolean bl2 = newSendEpoch != rebasedEntry.getSendEpoch();
        return TuplesKt.to((Object)rebaseLog, (Object)(bl2 ? transaction : null));
    }

    public static final boolean isRebasing(@NotNull RebaseLog $this$isRebasing) {
        Intrinsics.checkNotNullParameter((Object)$this$isRebasing, (String)"<this>");
        return !RebaseLogKt.isEmpty($this$isRebasing.getRebasing());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Novelty getSharedNovelty(@NotNull SharedBlock $this$sharedNovelty) {
        Novelty novelty2;
        Intrinsics.checkNotNullParameter((Object)$this$sharedNovelty, (String)"<this>");
        SharedBlock sharedBlock = $this$sharedNovelty;
        if (sharedBlock instanceof InstructionsPair) {
            novelty2 = ((InstructionsPair)$this$sharedNovelty).getSharedNovelty();
        } else if (sharedBlock instanceof ReconsiderableBlock) {
            void $this$fold$iv;
            Novelty p0;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((ReconsiderableBlock)$this$sharedNovelty).getItems();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                InstructionsPair instructionsPair = (InstructionsPair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((InstructionsPair)((Object)p0)).getSharedNovelty());
            }
            $this$map$iv = (List)destination$iv$iv;
            Novelty initial$iv = Novelty.Companion.getEmpty();
            boolean $i$f$fold = false;
            Novelty accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void p1;
                Object item$iv$iv;
                item$iv$iv = (Novelty)element$iv;
                p0 = accumulator$iv;
                boolean bl = false;
                accumulator$iv = p0.plus((Novelty)p1);
            }
            novelty2 = accumulator$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return novelty2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Novelty getSharedNovelty(@NotNull RebaseLogEntry $this$sharedNovelty) {
        void $this$fold$iv;
        Novelty p0;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sharedNovelty, (String)"<this>");
        Iterable $this$map$iv = $this$sharedNovelty.getSharedBlocks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SharedBlock sharedBlock = (SharedBlock)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(RebaseLogKt.getSharedNovelty((SharedBlock)((Object)p0)));
        }
        $this$map$iv = (List)destination$iv$iv;
        Novelty initial$iv = Novelty.Companion.getEmpty();
        boolean $i$f$fold = false;
        Novelty accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            Object item$iv$iv;
            item$iv$iv = (Novelty)element$iv;
            p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0.plus((Novelty)p1);
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SharedInstruction> sharedInstructions(@NotNull List<? extends SharedBlock> sharedBlocks) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sharedBlocks, (String)"sharedBlocks");
        Iterable $this$flatMap$iv = sharedBlocks;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            SharedBlock block = (SharedBlock)element$iv$iv;
            boolean bl = false;
            SharedBlock sharedBlock = block;
            if (sharedBlock instanceof InstructionsPair) {
                list2 = CollectionsKt.listOfNotNull((Object)((InstructionsPair)block).getSharedInstruction());
            } else if (sharedBlock instanceof ReconsiderableBlock) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = ((ReconsiderableBlock)block).getItems();
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    SharedInstruction it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    InstructionsPair i2 = (InstructionsPair)element$iv$iv2;
                    boolean bl3 = false;
                    if (i2.getSharedInstruction() == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final InstructionsPair playInstructionPair(@NotNull DbContext<? extends Mut> $this$playInstructionPair, @NotNull InstructionsPair instructionPair) {
        void $this$filterTo$iv$iv;
        Novelty $this$playInstructionPair_u24lambda_u240_u240;
        void this_$iv;
        Intrinsics.checkNotNullParameter($this$playInstructionPair, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)instructionPair, (String)"instructionPair");
        DbContext<? extends Mut> $this$playInstructionPair_u24lambda_u240 = $this$playInstructionPair;
        boolean bl = false;
        ArrayList effects = new ArrayList();
        DbContext<? extends Mut> dbContext = $this$playInstructionPair_u24lambda_u240;
        Q dbContextPrime$iv = DBUtilKt.delayingEffects(QueryCodingKt.expandingWithReadTracking($this$playInstructionPair_u24lambda_u240.getImpl()), (Function1<? super InstructionEffect, Unit>)((Function1)new Function1<InstructionEffect, Unit>(effects){

            public final void invoke(InstructionEffect p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ArrayList)this.receiver).add(p0);
            }
        }));
        boolean $i$f$alter = false;
        Object oldContext$iv = this_$iv.getPrivateValue();
        this_$iv.setPrivateValue(dbContextPrime$iv);
        try {
            $this$playInstructionPair_u24lambda_u240_u240 = this_$iv;
            boolean bl2 = false;
            $this$playInstructionPair_u24lambda_u240_u240 = DBUtilKt.mutate((DbContext<? extends Mut>)((Object)$this$playInstructionPair_u24lambda_u240_u240), instructionPair.getLocalInstruction());
        }
        finally {
            this_$iv.setPrivateValue(oldContext$iv);
        }
        Novelty novelty2 = $this$playInstructionPair_u24lambda_u240_u240;
        Iterable $this$filter$iv = novelty2;
        boolean $i$f$filter = false;
        oldContext$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Datom it = (Datom)element$iv$iv;
            boolean bl3 = false;
            if (!(APIKt.partition(it.getEid()) == 2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Novelty sharedNovelty = NoveltyKt.toNovelty((List)destination$iv$iv);
        return new InstructionsPair(instructionPair.getSharedInstruction(), instructionPair.getLocalInstruction(), effects, sharedNovelty);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RebaseLogEntry replay(@NotNull RebaseLogEntry $this$replay, @NotNull DB base) {
        RebaseLogEntry rebaseLogEntry;
        Intrinsics.checkNotNullParameter((Object)$this$replay, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        RebaseLogEntry logEntry = $this$replay;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)base, (Object)$this$replay.getDbBefore())) {
            rebaseLogEntry = logEntry;
        } else {
            RebaseLogEntry rebaseLogEntry2;
            try {
                Int2ObjectOpenHashMap<UID> mutableIdMapping = new Int2ObjectOpenHashMap<UID>();
                Pair pair = ChangeKt.changeAndReturn$default(base, 0, (Function1)new Function1<ChangeScope, List<? extends SharedBlock>>(mutableIdMapping, logEntry){
                    final /* synthetic */ Int2ObjectOpenHashMap<UID> $mutableIdMapping;
                    final /* synthetic */ RebaseLogEntry $logEntry;
                    {
                        this.$mutableIdMapping = $mutableIdMapping;
                        this.$logEntry = $logEntry;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public final List<SharedBlock> invoke(ChangeScope $this$changeAndReturn) {
                        List list2;
                        void dbContextPrime$iv;
                        void this_$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$changeAndReturn, (String)"$this$changeAndReturn");
                        DbContext<Mut> dbContext = $this$changeAndReturn.getContext();
                        Q q = DBUtilKt.collectingNovelty($this$changeAndReturn.getContext().getImpl(), (Function1<? super Datom, Unit>)((Function1)new Function1<Datom, Unit>(this.$mutableIdMapping){
                            final /* synthetic */ Int2ObjectOpenHashMap<UID> $mutableIdMapping;
                            {
                                this.$mutableIdMapping = $mutableIdMapping;
                                super(1);
                            }

                            public final void invoke(Datom datom) {
                                Intrinsics.checkNotNullParameter((Object)datom, (String)"datom");
                                if (Attribute.equals-impl0(datom.getAttr-dkwPBow(), DurableEntityKt.uidAttribute())) {
                                    int n = datom.getEid();
                                    Object object = datom.getValue();
                                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type fleet.util.UID");
                                    this.$mutableIdMapping.set(n, (UID)object);
                                }
                            }
                        }));
                        RebaseLogEntry rebaseLogEntry = this.$logEntry;
                        boolean $i$f$alter = false;
                        Object oldContext$iv = this_$iv.getPrivateValue();
                        this_$iv.setPrivateValue(dbContextPrime$iv);
                        try {
                            void $this$mapTo$iv$iv;
                            Intrinsics.checkNotNull((Object)this_$iv, (String)"null cannot be cast to non-null type com.jetbrains.rhizomedb.DbContext<U of com.jetbrains.rhizomedb.DbContext.alter>");
                            void $this$invoke_u24lambda_u240 = this_$iv;
                            boolean bl = false;
                            Iterable $this$map$iv = rebaseLogEntry.getSharedBlocks();
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                SharedBlock sharedBlock;
                                void block;
                                SharedBlock sharedBlock2 = (SharedBlock)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl2 = false;
                                void var19_20 = block;
                                if (var19_20 instanceof InstructionsPair) {
                                    sharedBlock = RebaseLogKt.playInstructionPair((DbContext<? extends Mut>)$this$invoke_u24lambda_u240, (InstructionsPair)block);
                                } else if (var19_20 instanceof ReconsiderableBlock) {
                                    void $this$mapTo$iv$iv2;
                                    void $this$map$iv2;
                                    Iterable iterable2 = ((ReconsiderableBlock)block).getItems();
                                    ReconsiderableBlock reconsiderableBlock = (ReconsiderableBlock)block;
                                    boolean $i$f$map2 = false;
                                    void var23_24 = $this$map$iv2;
                                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                                    boolean $i$f$mapTo2 = false;
                                    for (T item$iv$iv2 : $this$mapTo$iv$iv2) {
                                        void item2;
                                        InstructionsPair instructionsPair = (InstructionsPair)item$iv$iv2;
                                        Collection collection2 = destination$iv$iv2;
                                        boolean bl3 = false;
                                        collection2.add(RebaseLogKt.playInstructionPair((DbContext<? extends Mut>)$this$invoke_u24lambda_u240, (InstructionsPair)item2));
                                    }
                                    sharedBlock = ReconsiderableBlock.copy$default(reconsiderableBlock, (List)destination$iv$iv2, null, null, null, 14, null);
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                                collection.add(sharedBlock);
                            }
                            list2 = (List)destination$iv$iv;
                        }
                        finally {
                            this_$iv.setPrivateValue(oldContext$iv);
                        }
                        return list2;
                    }
                }, 1, null);
                List sharedBlocksPrime = (List)pair.component1();
                Change change2 = (Change)pair.component2();
                DB dB = change2.getDbAfter().selectPartitions(SetsKt.setOf((Object)2));
                rebaseLogEntry2 = RebaseLogEntry.copy$default(logEntry, sharedBlocksPrime, mutableIdMapping, base, dB, null, 0L, false, 48, null);
            }
            catch (AssumptionsViolatedException assumptionsViolatedException) {
                rebaseLogEntry2 = null;
            }
            catch (Throwable x) {
                void this_$iv;
                KLogger sharedBlocksPrime = RebaseLogger.INSTANCE.getLogger();
                Throwable t$iv = x;
                boolean $i$f$error = false;
                if (this_$iv.isErrorEnabled()) {
                    Throwable throwable = t$iv;
                    void var10_15 = this_$iv;
                    boolean bl2 = false;
                    String string = "failed to replay: " + $this$replay.getSharedBlocks();
                    var10_15.error(throwable, string);
                }
                rebaseLogEntry2 = RebaseLogEntry.copy$default(logEntry, null, null, base, base, null, 0L, true, 51, null);
            }
            rebaseLogEntry = rebaseLogEntry2;
        }
        return rebaseLogEntry;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RebaseLogEntry reconsider(@NotNull RebaseLogEntry $this$reconsider, @NotNull DB base, @NotNull InstructionEncoder encoder, @NotNull List<? extends IntMap<UID>> speculativeIdMappings) {
        RebaseLogEntry rebaseLogEntry;
        Intrinsics.checkNotNullParameter((Object)$this$reconsider, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(speculativeIdMappings, (String)"speculativeIdMappings");
        try {
            Int2ObjectOpenHashMap<UID> mutableIdMapping = new Int2ObjectOpenHashMap<UID>();
            int uidAttribute = DurableEntityKt.uidAttribute();
            List idMappings = CollectionsKt.plus((Collection)speculativeIdMappings, mutableIdMapping);
            Pair pair = ChangeKt.changeAndReturn$default(base, 0, (Function1)new Function1<ChangeScope, List<? extends SharedBlock>>($this$reconsider, encoder, (List<? extends IntMap<UID>>)idMappings, uidAttribute, mutableIdMapping){
                final /* synthetic */ RebaseLogEntry $this_reconsider;
                final /* synthetic */ InstructionEncoder $encoder;
                final /* synthetic */ List<IntMap<UID>> $idMappings;
                final /* synthetic */ int $uidAttribute;
                final /* synthetic */ Int2ObjectOpenHashMap<UID> $mutableIdMapping;
                {
                    this.$this_reconsider = $receiver;
                    this.$encoder = $encoder;
                    this.$idMappings = $idMappings;
                    this.$uidAttribute = $uidAttribute;
                    this.$mutableIdMapping = $mutableIdMapping;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final List<SharedBlock> invoke(ChangeScope $this$changeAndReturn) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter((Object)$this$changeAndReturn, (String)"$this$changeAndReturn");
                    Iterable iterable = this.$this_reconsider.getSharedBlocks();
                    InstructionEncoder instructionEncoder = this.$encoder;
                    List<IntMap<UID>> list2 = this.$idMappings;
                    int n = this.$uidAttribute;
                    Int2ObjectOpenHashMap<UID> int2ObjectOpenHashMap = this.$mutableIdMapping;
                    boolean $i$f$map = false;
                    void var8_8 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        SharedBlock sharedBlock;
                        void block;
                        SharedBlock sharedBlock2 = (SharedBlock)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        void var15_15 = block;
                        if (var15_15 instanceof InstructionsPair) {
                            InstructionsPair instructionsPair;
                            void this_$iv;
                            var16_16 = $this$changeAndReturn.getContext();
                            Q dbContextPrime$iv = DBUtilKt.collectingNovelty($this$changeAndReturn.getContext().getImpl(), (Function1<? super Datom, Unit>)((Function1)new Function1<Datom, Unit>(n, int2ObjectOpenHashMap){
                                final /* synthetic */ int $uidAttribute;
                                final /* synthetic */ Int2ObjectOpenHashMap<UID> $mutableIdMapping;
                                {
                                    this.$uidAttribute = $uidAttribute;
                                    this.$mutableIdMapping = $mutableIdMapping;
                                    super(1, Intrinsics.Kotlin.class, "updateIdMapping", "reconsider$updateIdMapping(ILfleet/fastutil/ints/Int2ObjectOpenHashMap;Lcom/jetbrains/rhizomedb/Datom;)V", 0);
                                }

                                public final void invoke(Datom p0) {
                                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                    RebaseLogKt.access$reconsider$updateIdMapping(this.$uidAttribute, this.$mutableIdMapping, p0);
                                }
                            }));
                            boolean $i$f$alter = false;
                            Object oldContext$iv = this_$iv.getPrivateValue();
                            this_$iv.setPrivateValue(dbContextPrime$iv);
                            try {
                                Intrinsics.checkNotNull((Object)this_$iv, (String)"null cannot be cast to non-null type com.jetbrains.rhizomedb.DbContext<U of com.jetbrains.rhizomedb.DbContext.alter>");
                                void $this$invoke_u24lambda_u240_u240 = this_$iv;
                                boolean bl2 = false;
                                instructionsPair = RebaseLogKt.playInstructionPair((DbContext<? extends Mut>)$this$invoke_u24lambda_u240_u240, (InstructionsPair)block);
                            }
                            finally {
                                this_$iv.setPrivateValue(oldContext$iv);
                            }
                            sharedBlock = instructionsPair;
                        } else if (var15_15 instanceof ReconsiderableBlock) {
                            var16_16 = ((ReconsiderableBlock)block).getEidMemoizer();
                            Memoizer<UID> memoizer = ((ReconsiderableBlock)block).getUidMemoizer();
                            Function1<SharedChangeScope, Object> function1 = ((ReconsiderableBlock)block).getReconsider();
                            sharedBlock = ReconsiderableBlock.copy$default((ReconsiderableBlock)block, (List)InstructionsRecordingKt.sharedImpl($this$changeAndReturn, (Memoizer<Integer>)var16_16, memoizer, (Function1<? super Datom, Unit>)((Function1)new Function1<Datom, Unit>(n, int2ObjectOpenHashMap){
                                final /* synthetic */ int $uidAttribute;
                                final /* synthetic */ Int2ObjectOpenHashMap<UID> $mutableIdMapping;
                                {
                                    this.$uidAttribute = $uidAttribute;
                                    this.$mutableIdMapping = $mutableIdMapping;
                                    super(1, Intrinsics.Kotlin.class, "updateIdMapping", "reconsider$updateIdMapping(ILfleet/fastutil/ints/Int2ObjectOpenHashMap;Lcom/jetbrains/rhizomedb/Datom;)V", 0);
                                }

                                public final void invoke(Datom p0) {
                                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                    RebaseLogKt.access$reconsider$updateIdMapping(this.$uidAttribute, this.$mutableIdMapping, p0);
                                }
                            }), instructionEncoder, list2, function1).getSecond(), null, null, null, 14, null);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        collection.add(sharedBlock);
                    }
                    return (List)destination$iv$iv;
                }
            }, 1, null);
            List newSharedBlocks = (List)pair.component1();
            Change change2 = (Change)pair.component2();
            DB dB = change2.getDbAfter().selectPartitions(SetsKt.setOf((Object)2));
            rebaseLogEntry = RebaseLogKt.reconsidered($this$reconsider, newSharedBlocks, base, dB, (IntMap<UID>)mutableIdMapping);
        }
        catch (Throwable e) {
            void this_$iv;
            KLogger idMappings = RebaseLogger.INSTANCE.getLogger();
            Throwable t$iv = e;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                Throwable throwable = t$iv;
                void var11_17 = this_$iv;
                boolean bl = false;
                String string = "failed to reconsider shared transaction. rebaseLogEntry: \n" + $this$reconsider;
                var11_17.error(throwable, string);
            }
            Int2ObjectOpenHashMap int2ObjectOpenHashMap = new Int2ObjectOpenHashMap();
            List list2 = CollectionsKt.emptyList();
            rebaseLogEntry = RebaseLogKt.reconsidered($this$reconsider, list2, base, base, int2ObjectOpenHashMap);
        }
        return rebaseLogEntry;
    }

    @NotNull
    public static final RebaseLogEntry reconsidered(@NotNull RebaseLogEntry $this$reconsidered, @NotNull List<? extends SharedBlock> newSharedBlocks, @NotNull DB dbBefore, @NotNull DB dbAfter, @NotNull IntMap<UID> idMapping) {
        Intrinsics.checkNotNullParameter((Object)$this$reconsidered, (String)"<this>");
        Intrinsics.checkNotNullParameter(newSharedBlocks, (String)"newSharedBlocks");
        Intrinsics.checkNotNullParameter((Object)dbBefore, (String)"dbBefore");
        Intrinsics.checkNotNullParameter((Object)dbAfter, (String)"dbAfter");
        Intrinsics.checkNotNullParameter(idMapping, (String)"idMapping");
        if ($this$reconsidered.getTransaction() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        List<SharedInstruction> list2 = RebaseLogKt.sharedInstructions(newSharedBlocks);
        UID uID = $this$reconsidered.getTransaction().getOrigin();
        long l = $this$reconsidered.getTransaction().getIndex();
        UID uID2 = UID.Companion.random();
        Transaction transaction = new Transaction(uID2, list2, uID, l);
        return RebaseLogEntry.copy$default($this$reconsidered, newSharedBlocks, idMapping, dbBefore, dbAfter, transaction, 0L, false, 32, null);
    }

    private static final void reconsider$updateIdMapping(int uidAttribute, Int2ObjectOpenHashMap<UID> mutableIdMapping, Datom datom) {
        if (Attribute.equals-impl0(datom.getAttr-dkwPBow(), uidAttribute)) {
            int n = datom.getEid();
            Object object = datom.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type fleet.util.UID");
            mutableIdMapping.put(n, (UID)object);
        }
    }

    public static final /* synthetic */ void access$reconsider$updateIdMapping(int uidAttribute, Int2ObjectOpenHashMap mutableIdMapping, Datom datom) {
        RebaseLogKt.reconsider$updateIdMapping(uidAttribute, mutableIdMapping, datom);
    }
}

