/*
 * Decompiled with CFR 0.152.
 */
package fleet.kernel.rebase;

import fleet.util.UID;
import fleet.util.VectorClock;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClientClock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VectorClock vectorClock;
    @NotNull
    private final UID clientId;

    public ClientClock(@NotNull VectorClock vectorClock2, @NotNull UID clientId) {
        Intrinsics.checkNotNullParameter((Object)vectorClock2, (String)"vectorClock");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        this.vectorClock = vectorClock2;
        this.clientId = clientId;
    }

    @NotNull
    public final VectorClock getVectorClock() {
        return this.vectorClock;
    }

    @NotNull
    public final UID getClientId() {
        return this.clientId;
    }

    @NotNull
    public final ClientClock tick() {
        return ClientClock.copy$default(this, this.vectorClock.tick(this.clientId), null, 2, null);
    }

    @NotNull
    public final ClientClock tick(@NotNull UID origin) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        return ClientClock.copy$default(this, this.vectorClock.tick(origin), null, 2, null);
    }

    public final long index() {
        Long l = (Long)this.vectorClock.getClock().get(this.clientId);
        return l != null ? l : 0L;
    }

    @NotNull
    public final ClientClock copy(@NotNull VectorClock vectorClock2, @NotNull UID clientId) {
        Intrinsics.checkNotNullParameter((Object)vectorClock2, (String)"vectorClock");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        return new ClientClock(vectorClock2, clientId);
    }

    public static /* synthetic */ ClientClock copy$default(ClientClock clientClock, VectorClock vectorClock2, UID uID, int n, Object object) {
        if ((n & 1) != 0) {
            vectorClock2 = clientClock.vectorClock;
        }
        if ((n & 2) != 0) {
            uID = clientClock.clientId;
        }
        return clientClock.copy(vectorClock2, uID);
    }

    @NotNull
    public String toString() {
        return "ClientClock(vectorClock=" + this.vectorClock + ", clientId=" + this.clientId + ")";
    }

    public int hashCode() {
        int result2 = this.vectorClock.hashCode();
        result2 = result2 * 31 + this.clientId.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClientClock)) {
            return false;
        }
        ClientClock clientClock = (ClientClock)other;
        if (!Intrinsics.areEqual((Object)this.vectorClock, (Object)clientClock.vectorClock)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.clientId, (Object)clientClock.clientId);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClientClock initial(@NotNull UID clientId) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            return new ClientClock(VectorClock.Companion.getZero(), clientId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

