/*
 * Decompiled with CFR 0.152.
 */
package fleet.kernel;

import com.jetbrains.rhizomedb.Change;
import com.jetbrains.rhizomedb.DB;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

sealed interface TransactorEvent {

    public static final class Init
    implements TransactorEvent {
        private final long timestamp;
        @NotNull
        private final DB db;

        public Init(long timestamp2, @NotNull DB db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            this.timestamp = timestamp2;
            this.db = db;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final DB getDb() {
            return this.db;
        }

        @NotNull
        public String toString() {
            return "Init(timestamp=" + this.timestamp + ", db=" + this.db + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.timestamp);
            result2 = result2 * 31 + this.db.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Init)) {
                return false;
            }
            Init init2 = (Init)other;
            if (this.timestamp != init2.timestamp) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.db, (Object)init2.db);
        }
    }

    public static final class SequentialChange
    implements TransactorEvent {
        private final long timestamp;
        @NotNull
        private final Change change;

        public SequentialChange(long timestamp2, @NotNull Change change2) {
            Intrinsics.checkNotNullParameter((Object)change2, (String)"change");
            this.timestamp = timestamp2;
            this.change = change2;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final Change getChange() {
            return this.change;
        }

        @NotNull
        public String toString() {
            return "SequentialChange(timestamp=" + this.timestamp + ", change=" + this.change + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.timestamp);
            result2 = result2 * 31 + this.change.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SequentialChange)) {
                return false;
            }
            SequentialChange sequentialChange = (SequentialChange)other;
            if (this.timestamp != sequentialChange.timestamp) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.change, (Object)sequentialChange.change);
        }
    }

    public static final class TheEnd
    implements TransactorEvent {
        @Nullable
        private final Throwable reason;

        public TheEnd(@Nullable Throwable reason) {
            this.reason = reason;
        }

        @Nullable
        public final Throwable getReason() {
            return this.reason;
        }

        @NotNull
        public String toString() {
            return "TheEnd(reason=" + this.reason + ")";
        }

        public int hashCode() {
            return this.reason == null ? 0 : this.reason.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TheEnd)) {
                return false;
            }
            TheEnd theEnd = (TheEnd)other;
            return Intrinsics.areEqual((Object)this.reason, (Object)theEnd.reason);
        }
    }
}

