/*
 * Decompiled with CFR 0.152.
 */
package fleet.kernel;

import com.jetbrains.rhizomedb.DB;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.Q;
import fleet.kernel.rete.CancellationReason;
import fleet.kernel.rete.ContextMatches;
import fleet.kernel.rete.Match;
import fleet.kernel.rete.UnsatisfiedMatchException;
import fleet.kernel.rete.impl.ObservableMatch;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.ThreadContextElement;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DbSource {
    @NotNull
    public Flow<DB> getFlow();

    @NotNull
    public DB getLatest();

    @NotNull
    public String getDebugName();

    @SourceDebugExtension(value={"SMAP\nDbSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbSource.kt\nfleet/kernel/DbSource$ContextElement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1#2:141\n295#3,2:142\n*S KotlinDebug\n*F\n+ 1 DbSource.kt\nfleet/kernel/DbSource$ContextElement\n*L\n36#1:142,2\n*E\n"})
    public static final class ContextElement
    implements ThreadContextElement<DbContext<?>> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final DbSource dbSource;
        @NotNull
        private final CoroutineContext.Key<?> key;

        public ContextElement(@NotNull DbSource dbSource) {
            Intrinsics.checkNotNullParameter((Object)dbSource, (String)"dbSource");
            this.dbSource = dbSource;
            this.key = Companion;
        }

        @NotNull
        public final DbSource getDbSource() {
            return this.dbSource;
        }

        @NotNull
        public CoroutineContext.Key<?> getKey() {
            return this.key;
        }

        @Nullable
        public DbContext<?> updateThreadContext(@NotNull CoroutineContext context2) {
            DbContext<Q> oldState;
            block7: {
                Throwable throwable;
                Object $this$updateThreadContext_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                oldState = DbContext.Companion.getThreadBoundOrNull();
                Object object = this;
                try {
                    $this$updateThreadContext_u24lambda_u240 = object;
                    boolean bl = false;
                    $this$updateThreadContext_u24lambda_u240 = Result.constructor-impl((Object)((ContextElement)$this$updateThreadContext_u24lambda_u240).dbSource.getLatest());
                }
                catch (Throwable bl) {
                    $this$updateThreadContext_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object = $this$updateThreadContext_u24lambda_u240;
                if (Result.isSuccess-impl((Object)object)) {
                    DB latest = (DB)object;
                    boolean bl = false;
                    DbContext ctx = new DbContext(latest, this.dbSource);
                    DbContext.Companion.getThreadLocal().set(ctx);
                    Object object2 = (ContextMatches)context2.get((CoroutineContext.Key)ContextMatches.Companion);
                    if (object2 != null && (object2 = ((ContextMatches)object2).getMatches$fleet_kernel()) != null) {
                        Object v1;
                        block6: {
                            Iterable $this$firstOrNull$iv = (Iterable)object2;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                ObservableMatch m = (ObservableMatch)element$iv;
                                boolean bl2 = false;
                                if (!m.getWasInvalidated()) continue;
                                v1 = element$iv;
                                break block6;
                            }
                            v1 = null;
                        }
                        if ((object2 = (ObservableMatch)v1) != null) {
                            Object cancelledMatch = object2;
                            boolean bl3 = false;
                            ctx.setPoison(new UnsatisfiedMatchException(new CancellationReason("match invalidated by rete", (Match)cancelledMatch)));
                        }
                    }
                }
                Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
                if (throwable2 == null) break block7;
                Throwable ex = throwable = throwable2;
                boolean bl = false;
                DbContext ctx = new DbContext(new RuntimeException("Failed to obtain latest db snapshot", ex), this.dbSource);
                DbContext.Companion.getThreadLocal().set(ctx);
            }
            return oldState;
        }

        public void restoreThreadContext(@NotNull CoroutineContext context2, @Nullable DbContext<?> oldState) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            DbContext<?> dbContext = oldState;
            if (dbContext != null) {
                DbContext<?> it = dbContext;
                boolean bl = false;
                DbSource dbSource = (DbSource)oldState.getDbSource();
                if (dbSource != null) {
                    Object $this$restoreThreadContext_u24lambda_u240_u240_u240;
                    DbSource dbSource2 = dbSource;
                    boolean bl2 = false;
                    Object object = this;
                    try {
                        $this$restoreThreadContext_u24lambda_u240_u240_u240 = object;
                        boolean bl3 = false;
                        $this$restoreThreadContext_u24lambda_u240_u240_u240 = Result.constructor-impl((Object)dbSource2.getLatest());
                    }
                    catch (Throwable bl3) {
                        $this$restoreThreadContext_u24lambda_u240_u240_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                    }
                    object = $this$restoreThreadContext_u24lambda_u240_u240_u240;
                    if (Result.isSuccess-impl((Object)object)) {
                        DB latest = (DB)object;
                        boolean bl4 = false;
                        oldState.set(latest);
                    }
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable != null) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = throwable;
                        boolean bl5 = false;
                        oldState.setPoison(new RuntimeException("Failed to obtain latest db snapshot", ex));
                    }
                    Result.box-impl((Object)object);
                }
            }
            DbContext.Companion.getThreadLocal().set(oldState);
        }

        @NotNull
        public String toString() {
            return "DbSourceContextElement(" + this.dbSource.getDebugName() + ")";
        }

        public static final class Companion
        implements CoroutineContext.Key<ContextElement> {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

