/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.longs;

import fleet.fastutil.longs.LongIterator;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class LongArrays {
    @NotNull
    public static final LongArrays INSTANCE = new LongArrays();
    @NotNull
    private static final long[] EMPTY_ARRAY = new long[0];
    @NotNull
    private static final long[] DEFAULT_EMPTY_ARRAY = new long[0];

    private LongArrays() {
    }

    @NotNull
    public final long[] getEMPTY_ARRAY() {
        return EMPTY_ARRAY;
    }

    @NotNull
    public final long[] getDEFAULT_EMPTY_ARRAY() {
        return DEFAULT_EMPTY_ARRAY;
    }

    @NotNull
    public final long[] forceCapacity(@NotNull long[] array, int length, int preserve) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        long[] t2 = new long[length];
        ArraysKt.copyInto((long[])array, (long[])t2, (int)0, (int)0, (int)preserve);
        return t2;
    }

    public final int unwrap(@NotNull LongIterator i2, @NotNull long[] array, int offset, int max) {
        Intrinsics.checkNotNullParameter((Object)i2, (String)"i");
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int offset2 = offset;
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset2 < 0 || offset2 + max > array.length) {
            throw new IllegalArgumentException();
        }
        int j = max;
        while (j-- != 0 && i2.hasNext()) {
            array[offset2++] = i2.next();
        }
        return max - j - 1;
    }

    public final int unwrap(@NotNull LongIterator i2, @NotNull long[] array) {
        Intrinsics.checkNotNullParameter((Object)i2, (String)"i");
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return this.unwrap(i2, array, 0, array.length);
    }
}

