/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.longs;

import fleet.fastutil.HashCommon;
import fleet.fastutil.longs.LongArrayList;
import fleet.fastutil.longs.LongEntry;
import fleet.fastutil.longs.LongMap;
import fleet.fastutil.longs.MutableLongMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nLong2ObjectOpenHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Long2ObjectOpenHashMap.kt\nfleet/fastutil/longs/Long2ObjectOpenHashMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,582:1\n1#2:583\n*E\n"})
public final class Long2ObjectOpenHashMap<V>
implements MutableLongMap<V> {
    @NotNull
    private long[] key;
    @NotNull
    private V[] value;
    private int mask;
    private boolean containsNullKey;
    private int n;
    private int maxFill;
    private int minN;
    private int size;
    private float f;
    @Nullable
    private V defaultValue;

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @NotNull
    public Iterator<LongEntry<V>> getEntries() {
        return new EntryIterator();
    }

    public Long2ObjectOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = HashCommon.INSTANCE.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, f);
        this.key = new long[this.n + 1];
        this.value = new Object[this.n + 1];
    }

    public Long2ObjectOpenHashMap() {
        this(16, 0.75f);
    }

    private final int realSize() {
        return this.containsNullKey ? this.getSize() - 1 : this.getSize();
    }

    private final V removeEntry(int pos) {
        V oldValue = this.value[pos];
        this.value[pos] = null;
        int n = this.getSize();
        this.setSize(n + -1);
        this.shiftKeys(pos);
        if (this.n > this.minN && this.getSize() < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private final V removeNullEntry() {
        this.containsNullKey = false;
        V oldValue = this.value[this.n];
        this.value[this.n] = null;
        int n = this.getSize();
        this.setSize(n + -1);
        if (this.n > this.minN && this.getSize() < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        V v = oldValue;
        Intrinsics.checkNotNull(v);
        return v;
    }

    /*
     * WARNING - void declaration
     */
    private final int find(long k) {
        long l;
        void it;
        int n;
        if (k == 0L) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        long curr = 0L;
        long[] key = this.key;
        int pos = 0;
        int n2 = n = (int)HashCommon.INSTANCE.mix(k) & this.mask;
        long[] lArray = key;
        boolean bl = false;
        pos = it;
        long it32 = l = lArray[n];
        boolean bl2 = false;
        curr = it32;
        if (l == 0L) {
            return -(pos + 1);
        }
        if (k == curr) {
            return pos;
        }
        do {
            int n3;
            int it32 = n3 = pos + 1 & this.mask;
            lArray = key;
            boolean bl3 = false;
            pos = it32;
            it32 = l = lArray[n3];
            boolean bl4 = false;
            curr = it32;
            if (l != 0L) continue;
            return -(pos + 1);
        } while (k != curr);
        return pos;
    }

    private final void insert(int pos, long k, V v) {
        if (pos == this.n) {
            this.containsNullKey = true;
        }
        this.key[pos] = k;
        this.value[pos] = v;
        int n = this.getSize();
        this.setSize(n + 1);
        if (n >= this.maxFill) {
            this.rehash(HashCommon.INSTANCE.arraySize(this.getSize() + 1, this.f));
        }
    }

    @Override
    @Nullable
    public V put(long key, V value2) {
        int pos = this.find(key);
        if (pos < 0) {
            this.insert(-pos - 1, key, value2);
            return this.defaultReturnValue();
        }
        V oldValue = this.value[pos];
        this.value[pos] = value2;
        this.key[pos] = key;
        return oldValue;
    }

    private final void shiftKeys(int pos) {
        int pos2 = pos;
        int last = 0;
        int slot = 0;
        long curr = 0L;
        long[] key = this.key;
        V[] value2 = this.value;
        while (true) {
            int n;
            int it = n = pos2;
            boolean bl = false;
            last = it;
            pos2 = n + 1 & this.mask;
            while (true) {
                long l;
                long it2 = l = key[pos2];
                boolean bl2 = false;
                curr = it2;
                if (l == 0L) {
                    key[last] = 0L;
                    value2[last] = null;
                    return;
                }
                slot = (int)HashCommon.INSTANCE.mix(curr) & this.mask;
                if (last <= pos2 ? last >= slot || slot > pos2 : (pos2 + 1 <= slot ? slot <= last : false)) break;
                pos2 = pos2 + 1 & this.mask;
            }
            key[last] = curr;
            value2[last] = value2[pos2];
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public V remove(long k) {
        long l;
        void it;
        int n;
        if (k == 0L) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defaultReturnValue();
        }
        long curr = 0L;
        long[] key = this.key;
        int pos = 0;
        int n2 = n = (int)HashCommon.INSTANCE.mix(k) & this.mask;
        long[] lArray = key;
        boolean bl = false;
        pos = it;
        long it32 = l = lArray[n];
        boolean bl2 = false;
        curr = it32;
        if (l == 0L) {
            return this.defaultReturnValue();
        }
        if (k == curr) {
            return this.removeEntry(pos);
        }
        do {
            int n3;
            int it32 = n3 = pos + 1 & this.mask;
            lArray = key;
            boolean bl3 = false;
            pos = it32;
            it32 = l = lArray[n3];
            boolean bl4 = false;
            curr = it32;
            if (l != 0L) continue;
            return this.defaultReturnValue();
        } while (k != curr);
        return this.removeEntry(pos);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public V get(long k) {
        long l;
        void it;
        int n;
        if (k == 0L) {
            return this.containsNullKey ? this.value[this.n] : this.defaultReturnValue();
        }
        long curr = 0L;
        long[] key = this.key;
        int pos = 0;
        int n2 = n = (int)HashCommon.INSTANCE.mix(k) & this.mask;
        long[] lArray = key;
        boolean bl = false;
        pos = it;
        long it32 = l = lArray[n];
        boolean bl2 = false;
        curr = it32;
        if (l == 0L) {
            return this.defaultReturnValue();
        }
        if (k == curr) {
            return this.value[pos];
        }
        do {
            int n3;
            int it32 = n3 = pos + 1 & this.mask;
            lArray = key;
            boolean bl3 = false;
            pos = it32;
            it32 = l = lArray[n3];
            boolean bl4 = false;
            curr = it32;
            if (l != 0L) continue;
            return this.defaultReturnValue();
        } while (k != curr);
        return this.value[pos];
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsKey(long k) {
        long l;
        void it;
        int n;
        if (k == 0L) {
            return this.containsNullKey;
        }
        long curr = 0L;
        long[] key = this.key;
        int pos = 0;
        int n2 = n = (int)HashCommon.INSTANCE.mix(k) & this.mask;
        long[] lArray = key;
        boolean bl = false;
        pos = it;
        long it32 = l = lArray[n];
        boolean bl2 = false;
        curr = it32;
        if (l == 0L) {
            return false;
        }
        if (k == curr) {
            return true;
        }
        do {
            int n3;
            int it32 = n3 = pos + 1 & this.mask;
            lArray = key;
            boolean bl3 = false;
            pos = it32;
            it32 = l = lArray[n3];
            boolean bl4 = false;
            curr = it32;
            if (l != 0L) continue;
            return false;
        } while (k != curr);
        return true;
    }

    @Nullable
    public final V defaultReturnValue() {
        return this.defaultValue;
    }

    private final void rehash(int newN) {
        long[] key = this.key;
        V[] value2 = this.value;
        int mask = newN - 1;
        long[] newKey = new long[newN + 1];
        Object[] newValue = new Object[newN + 1];
        int i2 = this.n;
        int pos = 0;
        int j = this.realSize();
        while (j-- != 0) {
            int it;
            int n;
            while (key[--i2] == 0L) {
            }
            int n2 = n = (int)HashCommon.INSTANCE.mix(key[i2]) & mask;
            long[] lArray = newKey;
            boolean bl = false;
            pos = it;
            if (lArray[n] != 0L) {
                do {
                    it = n = pos + 1 & mask;
                    lArray = newKey;
                    boolean bl2 = false;
                    pos = it;
                } while (lArray[n] != 0L);
            }
            newKey[pos] = key[i2];
            newValue[pos] = value2[i2];
        }
        newValue[newN] = value2[this.n];
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongMap)) {
            return false;
        }
        if (this.getSize() != ((LongMap)o).getSize()) {
            return false;
        }
        Iterator<LongEntry<V>> iterator2 = this.getEntries();
        while (iterator2.hasNext()) {
            LongEntry<V> longEntry = iterator2.next();
            long key = longEntry.component1();
            V value2 = longEntry.component2();
            if (Intrinsics.areEqual(((LongMap)o).get(key), value2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        long[] key = this.key;
        V[] value2 = this.value;
        int j = this.realSize();
        int i2 = 0;
        int t2 = 0;
        while (j-- != 0) {
            while (key[i2] == 0L) {
                ++i2;
            }
            t2 = (int)key[i2];
            if (this != value2[i2]) {
                int n;
                if (value2[i2] == null) {
                    n = 0;
                } else {
                    V v = value2[i2];
                    n = v != null ? v.hashCode() : 0;
                }
                t2 ^= n;
            }
            h += t2;
            ++i2;
        }
        if (this.containsNullKey) {
            int n;
            if (value2[this.n] == null) {
                n = 0;
            } else {
                V v = value2[this.n];
                n = v != null ? v.hashCode() : 0;
            }
            h += n;
        }
        return h;
    }

    private final class EntryIterator
    extends MapIterator
    implements Iterator,
    KMappedMarker {
        @NotNull
        public LongEntry<V> next() {
            int nextIndex = this.nextEntry();
            long l = Long2ObjectOpenHashMap.this.key[nextIndex];
            Object object = Long2ObjectOpenHashMap.this.value[nextIndex];
            Intrinsics.checkNotNull((Object)object);
            return new LongEntry<Object>(l, object);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @SourceDebugExtension(value={"SMAP\nLong2ObjectOpenHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Long2ObjectOpenHashMap.kt\nfleet/fastutil/longs/Long2ObjectOpenHashMap$MapIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,582:1\n1#2:583\n*E\n"})
    private abstract class MapIterator {
        private int pos;
        private int last;
        private int c;
        private boolean mustReturnNullKey;
        @Nullable
        private LongArrayList wrapped;

        public MapIterator() {
            this.pos = Long2ObjectOpenHashMap.this.n;
            this.last = -1;
            this.c = Long2ObjectOpenHashMap.this.getSize();
            this.mustReturnNullKey = Long2ObjectOpenHashMap.this.containsNullKey;
        }

        public final boolean hasNext() {
            return this.c != 0;
        }

        public final int nextEntry() {
            int n;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n2 = this.c;
            this.c = n2 + -1;
            if (this.mustReturnNullKey) {
                this.mustReturnNullKey = false;
                int it = n2 = Long2ObjectOpenHashMap.this.n;
                boolean bl = false;
                this.last = it;
                return n2;
            }
            long[] key = Long2ObjectOpenHashMap.this.key;
            do {
                this.pos += -1;
                if (this.pos >= 0) continue;
                this.last = Integer.MIN_VALUE;
                if (this.wrapped == null) {
                    throw new IllegalStateException();
                }
                LongArrayList longArrayList = this.wrapped;
                Intrinsics.checkNotNull((Object)longArrayList);
                long k = longArrayList.get(-this.pos - 1);
                int p = (int)HashCommon.INSTANCE.mix(k) & Long2ObjectOpenHashMap.this.mask;
                while (k != key[p]) {
                    p = p + 1 & Long2ObjectOpenHashMap.this.mask;
                }
                return p;
            } while (key[this.pos] == 0L);
            int it = n = this.pos;
            boolean bl = false;
            this.last = it;
            return n;
        }
    }
}

