/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.ints;

import fleet.fastutil.ints.IntList;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntListExtensionsKt {
    public static final boolean contains(@NotNull IntList $this$contains, int element) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        return IntListExtensionsKt.indexOf($this$contains, element) != -1;
    }

    public static final boolean isNotEmpty(@NotNull IntList $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmpty, (String)"<this>");
        return $this$isNotEmpty.getSize() != 0;
    }

    @NotNull
    public static final IntRange getIndices(@NotNull IntList $this$indices) {
        Intrinsics.checkNotNullParameter((Object)$this$indices, (String)"<this>");
        return RangesKt.until((int)0, (int)$this$indices.getSize());
    }

    public static final int length(@NotNull IntList $this$length) {
        Intrinsics.checkNotNullParameter((Object)$this$length, (String)"<this>");
        return $this$length.getSize();
    }

    public static final int indexOf(@NotNull IntList $this$indexOf, int element) {
        Intrinsics.checkNotNullParameter((Object)$this$indexOf, (String)"<this>");
        int n = $this$indexOf.getSize();
        for (int i2 = 0; i2 < n; ++i2) {
            if (element != $this$indexOf.get(i2)) continue;
            return i2;
        }
        return -1;
    }

    @Nullable
    public static final <R> R firstNotNullOfOrNull(@NotNull IntList $this$firstNotNullOfOrNull, @NotNull Function1<? super Integer, ? extends R> transform2) {
        Intrinsics.checkNotNullParameter((Object)$this$firstNotNullOfOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        IntRange intRange = IntListExtensionsKt.getIndices($this$firstNotNullOfOrNull);
        int index = intRange.getFirst();
        int n = intRange.getLast();
        if (index <= n) {
            while (true) {
                Object result2;
                if ((result2 = transform2.invoke((Object)$this$firstNotNullOfOrNull.get(index))) != null) {
                    return (R)result2;
                }
                if (index == n) break;
                ++index;
            }
        }
        return null;
    }
}

