/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.tools.impl;

import com.jetbrains.toolbox.BuildNumber;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.LocalDateTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nToolsListViewModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolsListViewModelImpl.kt\ncom/jetbrains/toolbox/viewmodel/tools/impl/Release\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,618:1\n1#2:619\n*E\n"})
public final class Release {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String version;
    @NotNull
    private final String build;
    @Nullable
    private final LocalDateTime releaseDate;
    @Nullable
    private final Release update;

    private Release(String version, String build2, LocalDateTime releaseDate, Release update2) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        this.version = version;
        this.build = build2;
        this.releaseDate = releaseDate;
        this.update = update2;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @Nullable
    public final Release getUpdate() {
        return this.update;
    }

    @NotNull
    public final String getFormattedVersion(boolean appendBuild) {
        Object object;
        block3: {
            String currentVersion;
            block2: {
                String currentBuild = appendBuild ? " (" + BuildNumber.toString-impl(this.build) + ")" : "";
                currentVersion = this.version + currentBuild;
                object = this.update;
                if (object == null) break block2;
                Release it = object;
                boolean bl = false;
                String string = currentVersion + " \u2192 " + it.getFormattedVersion(appendBuild);
                object = string;
                if (string != null) break block3;
            }
            object = currentVersion;
        }
        return object;
    }

    @NotNull
    public final String getFormattedBuild(@NotNull Function1<? super LocalDateTime, String> dateFormatter) {
        Object object;
        block7: {
            String currentBuild;
            block6: {
                Object object2;
                block5: {
                    block4: {
                        Intrinsics.checkNotNullParameter(dateFormatter, (String)"dateFormatter");
                        object2 = this.releaseDate;
                        if (object2 == null) break block4;
                        LocalDateTime it = object2;
                        boolean bl = false;
                        String string = " (" + dateFormatter.invoke((Object)it) + ")";
                        object2 = string;
                        if (string != null) break block5;
                    }
                    object2 = "";
                }
                Object currentReleaseDate = object2;
                currentBuild = BuildNumber.toString-impl(this.build) + (String)currentReleaseDate;
                object = this.update;
                if (object == null) break block6;
                Release it = object;
                boolean bl = false;
                String string = currentBuild + " \u2192 " + it.getFormattedBuild(dateFormatter);
                object = string;
                if (string != null) break block7;
            }
            object = currentBuild;
        }
        return object;
    }

    @NotNull
    public String toString() {
        return "Release(version=" + this.version + ", build=" + BuildNumber.toString-impl(this.build) + ", releaseDate=" + this.releaseDate + ", update=" + this.update + ")";
    }

    public int hashCode() {
        int result2 = this.version.hashCode();
        result2 = result2 * 31 + BuildNumber.hashCode-impl(this.build);
        result2 = result2 * 31 + (this.releaseDate == null ? 0 : this.releaseDate.hashCode());
        result2 = result2 * 31 + (this.update == null ? 0 : this.update.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Release)) {
            return false;
        }
        Release release2 = (Release)other;
        if (!Intrinsics.areEqual((Object)this.version, (Object)release2.version)) {
            return false;
        }
        if (!BuildNumber.equals-impl0(this.build, release2.build)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.releaseDate, (Object)release2.releaseDate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.update, (Object)release2.update);
    }

    public /* synthetic */ Release(String version, String build2, LocalDateTime releaseDate, Release update2, DefaultConstructorMarker $constructor_marker) {
        this(version, build2, releaseDate, update2);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

