/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.tools;

import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.tools.model.ToolDescription;
import com.jetbrains.toolbox.viewmodel.DistributionId;
import com.jetbrains.toolbox.viewmodel.tools.AvailableToolViewState;
import com.jetbrains.toolbox.viewmodel.tools.InstalledToolViewState;
import com.jetbrains.toolbox.viewmodel.tools.impl.Release;
import com.jetbrains.toolbox.viewmodel.tools.impl.ToolsListViewModelImplKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyCharmRenaming {
    @NotNull
    public static final PyCharmRenaming INSTANCE = new PyCharmRenaming();
    @NotNull
    private static final String pycharmCommunity = ApplicationType.constructor-impl("PyCharm-C");
    @NotNull
    private static final String pycharmProfessional = ApplicationType.constructor-impl("PyCharm-P");

    private PyCharmRenaming() {
    }

    @NotNull
    public final String getAvailableToolTitleIconTooltipText(@NotNull I18n i18n) {
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        return i18n.tr("PyCharm is now a single product! Switch manually to keep using all Community features for free \u2013 now with Jupyter support included \u2013 or wait for the smooth migration path in 2025.2");
    }

    public final boolean isToolTitleIconVisible(@NotNull AvailableToolViewState availableTool2) {
        Intrinsics.checkNotNullParameter((Object)availableTool2, (String)"availableTool");
        return ApplicationType.equals-impl0(availableTool2.getToolId-UtVBrGo(), pycharmCommunity) && this.isRenameVersion(availableTool2.getStableVersionName());
    }

    public final boolean isRenamed(@NotNull AvailableToolViewState availableTool2) {
        Intrinsics.checkNotNullParameter((Object)availableTool2, (String)"availableTool");
        return ApplicationType.equals-impl0(availableTool2.getToolId-UtVBrGo(), pycharmProfessional) && this.isRenameVersion(availableTool2.getStableVersionName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getAdditionalVersionInfo(@NotNull ToolDescription tool, @NotNull I18n i18n) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        if (!ApplicationType.equals-impl0(tool.getToolId-UtVBrGo(), pycharmProfessional)) return null;
        Release release2 = ToolsListViewModelImplKt.release(tool).getUpdate();
        Object object = release2;
        if (release2 == null) return null;
        String string = ((Release)object).getVersion();
        object = string;
        if (string == null) return null;
        if (!this.isRenameVersion((String)object)) return null;
        boolean bl = true;
        if (!bl) return null;
        String string2 = i18n.tr("PyCharm is now one unified product! Your Professional license gives you full access to PyCharm Pro. [url]https://jb.gg/phycharm-single-product|Learn more[/url]");
        return string2;
    }

    @NotNull
    public final String getInstalledToolTitleIconTooltipText(@NotNull InstalledToolViewState toolState, @NotNull I18n i18n) {
        Intrinsics.checkNotNullParameter((Object)toolState, (String)"toolState");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        return toolState.getUpdateItem() != null ? i18n.tr("PyCharm Community is now part of one unified PyCharm. Switch to the unified PyCharm and get all core Community features for free, now with built-in Jupyter support. You can upgrade to PyCharm Community 2025.1 as usual. A seamless migration will follow in the next release.") : i18n.tr("PyCharm is now one unified product! Switch manually to keep using all Community features for free \u2013 now with Jupyter support included \u2013 or wait for the smooth migration path in 2025.2.");
    }

    public final boolean isToolTitleIconVisible(@NotNull InstalledToolViewState toolState) {
        Intrinsics.checkNotNullParameter((Object)toolState, (String)"toolState");
        return ApplicationType.equals-impl0(toolState.getToolId-UtVBrGo(), pycharmCommunity) && (this.isCurrentVersionRenamed(toolState) || this.isUpdateVersionRenamed(toolState));
    }

    public final boolean isRenamed(@NotNull InstalledToolViewState installedTool2) {
        Intrinsics.checkNotNullParameter((Object)installedTool2, (String)"installedTool");
        return ApplicationType.equals-impl0(installedTool2.getToolId-UtVBrGo(), pycharmProfessional) && this.isCurrentVersionRenamed(installedTool2);
    }

    private final boolean isCurrentVersionRenamed(InstalledToolViewState $this$isCurrentVersionRenamed) {
        return this.isRenameVersion($this$isCurrentVersionRenamed.getVersion());
    }

    private final boolean isUpdateVersionRenamed(InstalledToolViewState $this$isUpdateVersionRenamed) {
        Object object = $this$isUpdateVersionRenamed.getUpdateItem();
        return object != null && (object = ((InstalledToolViewState.UpdateItem)object).getDistributionId()) != null && (object = ((DistributionId)object).getVersionName()) != null ? this.isRenameVersion((String)object) : false;
    }

    private final boolean isRenameVersion(String $this$isRenameVersion) {
        return StringsKt.startsWith$default((String)$this$isRenameVersion, (String)"2025.1", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)$this$isRenameVersion, (CharSequence)"EAP", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)$this$isRenameVersion, (CharSequence)"Nightly", (boolean)false, (int)2, null);
    }

    @NotNull
    public final String getBadgeTooltipText(@NotNull I18n i18n, boolean toolIsInstalled) {
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        return toolIsInstalled ? i18n.tr("PyCharm is now one unified product! Your Professional license gives you full access to PyCharm Pro. No subscription? Use the core features for free, now with Jupyter support included. [url]https://jb.gg/phycharm-single-product|Learn more[/url]") : i18n.tr("PyCharm is now one unified product! Start with a free one-month Pro trial, and then continue with a Pro subscription or use core features for free, including Jupyter support. [url]https://jb.gg/phycharm-single-product|Learn more[/url]");
    }
}

