/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.settings;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoreInfo {
    @NotNull
    private final String cpuArch;
    private final int cpuCores;
    @Nullable
    private final Long ramBytes;
    @Nullable
    private final String lowResourceWarning;

    public CoreInfo(@NotNull String cpuArch, int cpuCores, @Nullable Long ramBytes, @Nullable String lowResourceWarning) {
        Intrinsics.checkNotNullParameter((Object)cpuArch, (String)"cpuArch");
        this.cpuArch = cpuArch;
        this.cpuCores = cpuCores;
        this.ramBytes = ramBytes;
        this.lowResourceWarning = lowResourceWarning;
    }

    @NotNull
    public final String getCpuArch() {
        return this.cpuArch;
    }

    public final int getCpuCores() {
        return this.cpuCores;
    }

    @Nullable
    public final Long getRamBytes() {
        return this.ramBytes;
    }

    @Nullable
    public final String getLowResourceWarning() {
        return this.lowResourceWarning;
    }

    @NotNull
    public String toString() {
        return "CoreInfo(cpuArch=" + this.cpuArch + ", cpuCores=" + this.cpuCores + ", ramBytes=" + this.ramBytes + ", lowResourceWarning=" + this.lowResourceWarning + ")";
    }

    public int hashCode() {
        int result2 = this.cpuArch.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.cpuCores);
        result2 = result2 * 31 + (this.ramBytes == null ? 0 : ((Object)this.ramBytes).hashCode());
        result2 = result2 * 31 + (this.lowResourceWarning == null ? 0 : this.lowResourceWarning.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CoreInfo)) {
            return false;
        }
        CoreInfo coreInfo = (CoreInfo)other;
        if (!Intrinsics.areEqual((Object)this.cpuArch, (Object)coreInfo.cpuArch)) {
            return false;
        }
        if (this.cpuCores != coreInfo.cpuCores) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ramBytes, (Object)coreInfo.ramBytes)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.lowResourceWarning, (Object)coreInfo.lowResourceWarning);
    }
}

