/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.recents;

import com.jetbrains.toolbox.common.coroutines.flow.CreateFromSuspendingKt;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.common.coroutines.flow.SingleStateFlow;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.gateway.DevEnvironment;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.DevEnvironmentManager;
import com.jetbrains.toolbox.gateway.DevEnvironmentProvider;
import com.jetbrains.toolbox.gateway.project.RemoteProjectStatusAggregator;
import com.jetbrains.toolbox.gateway.tool.ToolStateAggregator;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.manager.tool.ToolManager;
import com.jetbrains.toolbox.platform.image.ImageResource;
import com.jetbrains.toolbox.platform.image.internal.Image;
import com.jetbrains.toolbox.platform.image.internal.ImagesKt;
import com.jetbrains.toolbox.project.AvailableToolInstallAndOpenProject;
import com.jetbrains.toolbox.project.CheckedOutProject;
import com.jetbrains.toolbox.project.FileSystemProject;
import com.jetbrains.toolbox.project.FleetWorkspace;
import com.jetbrains.toolbox.project.IconSet;
import com.jetbrains.toolbox.project.LaunchMethod;
import com.jetbrains.toolbox.project.ProjectManager;
import com.jetbrains.toolbox.project.ProjectManagerKt;
import com.jetbrains.toolbox.project.RemoteAvailableToolLaunchMethod;
import com.jetbrains.toolbox.project.RemoteProject;
import com.jetbrains.toolbox.project.RemoteToolLaunchMethod;
import com.jetbrains.toolbox.settings.ProjectSettings;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import com.jetbrains.toolbox.tools.ProjectStatus;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.ProjectId;
import com.jetbrains.toolbox.tools.model.ToolDescription;
import com.jetbrains.toolbox.util.GetPresentablePathKt;
import com.jetbrains.toolbox.viewmodel.projects.ProjectAvatarIconData;
import com.jetbrains.toolbox.viewmodel.projects.ProjectIconData;
import com.jetbrains.toolbox.viewmodel.projects.ProjectImageIconData;
import com.jetbrains.toolbox.viewmodel.projects.ProjectListViewModelImplKt;
import com.jetbrains.toolbox.viewmodel.projects.SafeProjectLauncher;
import com.jetbrains.toolbox.viewmodel.projects.UtilsKt;
import com.jetbrains.toolbox.viewmodel.recents.RecentProjectsState;
import com.jetbrains.toolbox.viewmodel.recents.RecentsViewModel;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.datetime.Instant;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nRecentsViewModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentsViewModelImpl.kt\ncom/jetbrains/toolbox/viewmodel/recents/RecentsViewModelImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,192:1\n1869#2:193\n1869#2,2:194\n1870#2:196\n808#2,11:197\n1068#2:208\n1617#2,9:209\n1869#2:218\n1617#2,9:220\n1869#2:229\n1870#2:231\n1626#2:232\n1870#2:234\n1626#2:235\n3301#2,10:236\n1208#2,2:253\n1236#2,4:255\n1#3:219\n1#3:230\n1#3:233\n488#4,7:246\n*S KotlinDebug\n*F\n+ 1 RecentsViewModelImpl.kt\ncom/jetbrains/toolbox/viewmodel/recents/RecentsViewModelImpl\n*L\n62#1:193\n63#1:194,2\n62#1:196\n125#1:197,11\n126#1:208\n127#1:209,9\n127#1:218\n172#1:220,9\n172#1:229\n172#1:231\n172#1:232\n127#1:234\n127#1:235\n178#1:236,10\n151#1:253,2\n151#1:255,4\n172#1:230\n127#1:233\n151#1:246,7\n*E\n"})
public final class RecentsViewModelImpl
implements RecentsViewModel {
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final SafeProjectLauncher safeProjectLauncher;
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final ToolManager toolManager;
    @NotNull
    private final ToolStateAggregator toolStateAggregator;
    @NotNull
    private final I18n i18n;
    @NotNull
    private final DevEnvironmentManager devEnvironmentManager;
    @NotNull
    private final StateFlow<Map<String, Instant>> hiddenProjects;
    @NotNull
    private final MutableStateFlow<Map<RemoteProject.EnvironmentId, Environment>> environments;
    @NotNull
    private final StateFlow<RecentProjectsState> state;

    /*
     * WARNING - void declaration
     */
    public RecentsViewModelImpl(@NotNull ProjectManager projectManager, @NotNull SafeProjectLauncher safeProjectLauncher, @NotNull SettingsManager settingsManager, @NotNull ToolManager toolManager, @NotNull ToolStateAggregator toolStateAggregator, @NotNull I18n i18n, @NotNull CoroutineScope coroutineScope, @NotNull CoroutineScope uiCoroutineScope, @NotNull DevEnvironmentManager devEnvironmentManager, @NotNull RemoteProjectStatusAggregator remoteStatusAggregator) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)safeProjectLauncher, (String)"safeProjectLauncher");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)toolManager, (String)"toolManager");
        Intrinsics.checkNotNullParameter((Object)toolStateAggregator, (String)"toolStateAggregator");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)uiCoroutineScope, (String)"uiCoroutineScope");
        Intrinsics.checkNotNullParameter((Object)devEnvironmentManager, (String)"devEnvironmentManager");
        Intrinsics.checkNotNullParameter((Object)remoteStatusAggregator, (String)"remoteStatusAggregator");
        this.projectManager = projectManager;
        this.safeProjectLauncher = safeProjectLauncher;
        this.settingsManager = settingsManager;
        this.toolManager = toolManager;
        this.toolStateAggregator = toolStateAggregator;
        this.i18n = i18n;
        this.devEnvironmentManager = devEnvironmentManager;
        this.hiddenProjects = FlowExtensionsKt.mapState(this.settingsManager.getSettings(), RecentsViewModelImpl::hiddenProjects$lambda$0);
        Map map3 = map2 = MapsKt.createMapBuilder();
        RecentsViewModelImpl recentsViewModelImpl = this;
        boolean bl = false;
        Iterable $this$forEach$iv = (Iterable)this.devEnvironmentManager.getProviders().getValue();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DevEnvironmentProvider provider2 = (DevEnvironmentProvider)element$iv;
            boolean bl2 = false;
            List list2 = (List)provider2.getEnvironments().getValue();
            if (list2 == null) continue;
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                void $this$environments_u24lambda_u240;
                DevEnvironment environment = (DevEnvironment)element$iv2;
                boolean bl3 = false;
                DevEnvironmentId id = environment.getId();
                ImageResource imageResource = provider2.getIcon();
                $this$environments_u24lambda_u240.put(RemoteProject.EnvironmentId.box-impl(com.jetbrains.toolbox.gateway.project.UtilsKt.toProjectEnvironmentId(id)), new Environment(id, (Image)(imageResource != null ? ImagesKt.getImage((ImageResource)imageResource) : null), (String)environment.getName().getValue()));
            }
        }
        recentsViewModelImpl.environments = StateFlowKt.MutableStateFlow((Object)MapsKt.build((Map)map2));
        BuildersKt.launch$default((CoroutineScope)uiCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RecentsViewModelImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.devEnvironmentManager.getProviders()), (Function2)((Function2)new Function2<List<? extends DevEnvironmentProvider>, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ RecentsViewModelImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                List list2 = (List)this.L$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void providers;
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)providers);
                                        this.label = 1;
                                        Object object2 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<? extends DevEnvironmentProvider>)providers, this.this$0, null){
                                            int label;
                                            private /* synthetic */ Object L$0;
                                            final /* synthetic */ List<DevEnvironmentProvider> $providers;
                                            final /* synthetic */ RecentsViewModelImpl this$0;
                                            {
                                                this.$providers = $providers;
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        for (DevEnvironmentProvider provider2 : this.$providers) {
                                                            void $this$coroutineScope;
                                                            BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(provider2, this.this$0, null){
                                                                int label;
                                                                final /* synthetic */ DevEnvironmentProvider $provider;
                                                                final /* synthetic */ RecentsViewModelImpl this$0;
                                                                {
                                                                    this.$provider = $provider;
                                                                    this.this$0 = $receiver;
                                                                    super(2, $completion);
                                                                }

                                                                /*
                                                                 * Enabled force condition propagation
                                                                 * Lifted jumps to return sites
                                                                 */
                                                                public final Object invokeSuspend(Object $result) {
                                                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                    switch (this.label) {
                                                                        case 0: {
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            this.label = 1;
                                                                            Object object2 = FlowKt.collectLatest((Flow)((Flow)this.$provider.getEnvironments()), (Function2)((Function2)new Function2<List<? extends DevEnvironment>, Continuation<? super Unit>, Object>(this.this$0, this.$provider, null){
                                                                                int label;
                                                                                /* synthetic */ Object L$0;
                                                                                final /* synthetic */ RecentsViewModelImpl this$0;
                                                                                final /* synthetic */ DevEnvironmentProvider $provider;
                                                                                {
                                                                                    this.this$0 = $receiver;
                                                                                    this.$provider = $provider;
                                                                                    super(2, $completion);
                                                                                }

                                                                                /*
                                                                                 * WARNING - void declaration
                                                                                 * Enabled force condition propagation
                                                                                 * Lifted jumps to return sites
                                                                                 */
                                                                                public final Object invokeSuspend(Object $result) {
                                                                                    List list2 = (List)this.L$0;
                                                                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                                    switch (this.label) {
                                                                                        case 0: {
                                                                                            void environments;
                                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                                            if (environments == null) {
                                                                                                return Unit.INSTANCE;
                                                                                            }
                                                                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)environments);
                                                                                            this.label = 1;
                                                                                            Object object2 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<? extends DevEnvironment>)environments, this.this$0, this.$provider, null){
                                                                                                int label;
                                                                                                private /* synthetic */ Object L$0;
                                                                                                final /* synthetic */ List<DevEnvironment> $environments;
                                                                                                final /* synthetic */ RecentsViewModelImpl this$0;
                                                                                                final /* synthetic */ DevEnvironmentProvider $provider;
                                                                                                {
                                                                                                    this.$environments = $environments;
                                                                                                    this.this$0 = $receiver;
                                                                                                    this.$provider = $provider;
                                                                                                    super(2, $completion);
                                                                                                }

                                                                                                /*
                                                                                                 * WARNING - void declaration
                                                                                                 */
                                                                                                public final Object invokeSuspend(Object $result) {
                                                                                                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                                                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                                                    switch (this.label) {
                                                                                                        case 0: {
                                                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                                                            for (DevEnvironment environment : this.$environments) {
                                                                                                                void $this$coroutineScope;
                                                                                                                String environmentId = com.jetbrains.toolbox.gateway.project.UtilsKt.toProjectEnvironmentId(environment.getId());
                                                                                                                BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(environment, this.this$0, environmentId, this.$provider, null){
                                                                                                                    int label;
                                                                                                                    final /* synthetic */ DevEnvironment $environment;
                                                                                                                    final /* synthetic */ RecentsViewModelImpl this$0;
                                                                                                                    final /* synthetic */ String $environmentId;
                                                                                                                    final /* synthetic */ DevEnvironmentProvider $provider;
                                                                                                                    {
                                                                                                                        this.$environment = $environment;
                                                                                                                        this.this$0 = $receiver;
                                                                                                                        this.$environmentId = $environmentId;
                                                                                                                        this.$provider = $provider;
                                                                                                                        super(2, $completion);
                                                                                                                    }

                                                                                                                    /*
                                                                                                                     * Enabled force condition propagation
                                                                                                                     * Lifted jumps to return sites
                                                                                                                     */
                                                                                                                    public final Object invokeSuspend(Object $result) {
                                                                                                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                                                                        switch (this.label) {
                                                                                                                            case 0: {
                                                                                                                                ResultKt.throwOnFailure((Object)$result);
                                                                                                                                this.label = 1;
                                                                                                                                Object object2 = FlowKt.collectLatest((Flow)((Flow)this.$environment.getName()), (Function2)((Function2)new Function2<String, Continuation<? super Unit>, Object>(this.this$0, this.$environmentId, this.$environment, this.$provider, null){
                                                                                                                                    int label;
                                                                                                                                    /* synthetic */ Object L$0;
                                                                                                                                    final /* synthetic */ RecentsViewModelImpl this$0;
                                                                                                                                    final /* synthetic */ String $environmentId;
                                                                                                                                    final /* synthetic */ DevEnvironment $environment;
                                                                                                                                    final /* synthetic */ DevEnvironmentProvider $provider;
                                                                                                                                    {
                                                                                                                                        this.this$0 = $receiver;
                                                                                                                                        this.$environmentId = $environmentId;
                                                                                                                                        this.$environment = $environment;
                                                                                                                                        this.$provider = $provider;
                                                                                                                                        super(2, $completion);
                                                                                                                                    }

                                                                                                                                    /*
                                                                                                                                     * WARNING - void declaration
                                                                                                                                     */
                                                                                                                                    public final Object invokeSuspend(Object $result) {
                                                                                                                                        String string = (String)this.L$0;
                                                                                                                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                                                                                        switch (this.label) {
                                                                                                                                            case 0: {
                                                                                                                                                void name2;
                                                                                                                                                ImageResource imageResource;
                                                                                                                                                Image image;
                                                                                                                                                DevEnvironmentId devEnvironmentId;
                                                                                                                                                Map it;
                                                                                                                                                Map nextValue$iv;
                                                                                                                                                Object prevValue$iv;
                                                                                                                                                void $this$update$iv;
                                                                                                                                                ResultKt.throwOnFailure((Object)$result);
                                                                                                                                                MutableStateFlow mutableStateFlow = this.this$0.environments;
                                                                                                                                                String string2 = this.$environmentId;
                                                                                                                                                DevEnvironment devEnvironment = this.$environment;
                                                                                                                                                DevEnvironmentProvider devEnvironmentProvider = this.$provider;
                                                                                                                                                boolean $i$f$update = false;
                                                                                                                                                do {
                                                                                                                                                    prevValue$iv = $this$update$iv.getValue();
                                                                                                                                                    it = (Map)prevValue$iv;
                                                                                                                                                    boolean bl = false;
                                                                                                                                                    devEnvironmentId = devEnvironment.getId();
                                                                                                                                                    imageResource = devEnvironmentProvider.getIcon();
                                                                                                                                                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = MapsKt.plus((Map)it, (Pair)TuplesKt.to((Object)RemoteProject.EnvironmentId.box-impl(string2), (Object)new Environment(devEnvironmentId, image = imageResource != null ? ImagesKt.getImage((ImageResource)imageResource) : null, (String)name2))))));
                                                                                                                                                return Unit.INSTANCE;
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                                                                                    }

                                                                                                                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                                                                                                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                                                                                                        var3_3.L$0 = value2;
                                                                                                                                        return (Continuation)var3_3;
                                                                                                                                    }

                                                                                                                                    public final Object invoke(String p1, Continuation<? super Unit> p2) {
                                                                                                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                                                                                                    }
                                                                                                                                }), (Continuation)((Continuation)this));
                                                                                                                                if (object2 != object) return Unit.INSTANCE;
                                                                                                                                return object;
                                                                                                                            }
                                                                                                                            case 1: {
                                                                                                                                ResultKt.throwOnFailure((Object)$result);
                                                                                                                                Object object2 = $result;
                                                                                                                                return Unit.INSTANCE;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                                                                    }

                                                                                                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                                                                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                                                                                    }

                                                                                                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                                                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                                                                                    }
                                                                                                                }), (int)3, null);
                                                                                                            }
                                                                                                            return Unit.INSTANCE;
                                                                                                        }
                                                                                                    }
                                                                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                                                }

                                                                                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                                                                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                                                                    var3_3.L$0 = value2;
                                                                                                    return (Continuation)var3_3;
                                                                                                }

                                                                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                                                                }
                                                                                            }), (Continuation)((Continuation)this));
                                                                                            if (object2 != object) return Unit.INSTANCE;
                                                                                            return object;
                                                                                        }
                                                                                        case 1: {
                                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                                            Object object2 = $result;
                                                                                            return Unit.INSTANCE;
                                                                                        }
                                                                                    }
                                                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                                }

                                                                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                                                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                                                    var3_3.L$0 = value2;
                                                                                    return (Continuation)var3_3;
                                                                                }

                                                                                public final Object invoke(List<? extends DevEnvironment> p1, Continuation<? super Unit> p2) {
                                                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                                                }
                                                                            }), (Continuation)((Continuation)this));
                                                                            if (object2 != object) return Unit.INSTANCE;
                                                                            return object;
                                                                        }
                                                                        case 1: {
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            Object object2 = $result;
                                                                            return Unit.INSTANCE;
                                                                        }
                                                                    }
                                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                }

                                                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                                }

                                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                                }
                                                            }), (int)3, null);
                                                        }
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                var3_3.L$0 = value2;
                                                return (Continuation)var3_3;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(List<? extends DevEnvironmentProvider> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.state = CreateFromSuspendingKt.createFromSuspending(coroutineScope, this.viewState((ProjectManager.Model)this.projectManager.getState().getValue(), MapsKt.emptyMap(), MapsKt.emptyMap(), (Map)this.hiddenProjects.getValue(), (Map)this.environments.getValue()), (Function1)new Function1<Continuation<? super StateFlow<? extends RecentProjectsState>>, Object>(this, remoteStatusAggregator, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ RecentsViewModelImpl this$0;
            final /* synthetic */ RemoteProjectStatusAggregator $remoteStatusAggregator;
            {
                this.this$0 = $receiver;
                this.$remoteStatusAggregator = $remoteStatusAggregator;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var3_3 = this.$remoteStatusAggregator.getStatusPerProject();
                        this.L$0 = var2_4 = RecentsViewModelImpl.access$getProjectManager$p(this.this$0).getState();
                        this.L$1 = var3_3;
                        this.label = 1;
                        v0 = RecentsViewModelImpl.access$getToolStateAggregator$p(this.this$0).getTools((Continuation<? super StateFlow<? extends Map<Pair<DevEnvironmentId, ChannelId>, ToolDescription>>>)((Continuation)this));
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        var3_3 = (StateFlow<Map<ProjectId, ProjectStatus>>)this.L$1;
                        var2_4 = (StateFlow<ProjectManager.Model>)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        var4_5 = v0;
                        return FlowExtensionsKt.combineStates(var2_4, var3_3, (StateFlow)var4_5, RecentsViewModelImpl.access$getHiddenProjects$p(this.this$0), (StateFlow)RecentsViewModelImpl.access$getEnvironments$p(this.this$0), (Function5)new Function5<ProjectManager.Model, Map<ProjectId, ? extends ProjectStatus>, Map<Pair<? extends DevEnvironmentId, ? extends ChannelId>, ? extends ToolDescription>, Map<String, ? extends Instant>, Map<RemoteProject.EnvironmentId, ? extends Environment>, RecentProjectsState>((Object)this.this$0){

                            public final RecentProjectsState invoke(ProjectManager.Model p0, Map<ProjectId, ? extends ProjectStatus> p1, Map<Pair<DevEnvironmentId, ChannelId>, ToolDescription> p2, Map<String, Instant> p3, Map<RemoteProject.EnvironmentId, Environment> p4) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                                Intrinsics.checkNotNullParameter(p3, (String)"p3");
                                Intrinsics.checkNotNullParameter(p4, (String)"p4");
                                return RecentsViewModelImpl.access$viewState((RecentsViewModelImpl)this.receiver, p0, p1, p2, p3, p4);
                            }
                        });
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super StateFlow<RecentProjectsState>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    @NotNull
    public StateFlow<RecentProjectsState> getState() {
        return this.state;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final RecentProjectsState viewState(ProjectManager.Model projectModel, Map<ProjectId, ? extends ProjectStatus> statusPerProject, Map<Pair<DevEnvironmentId, ChannelId>, ToolDescription> toolDescriptions, Map<String, Instant> hidden, Map<RemoteProject.EnvironmentId, Environment> environments) {
        $this$filterIsInstance$iv = projectModel.getProjects();
        $i$f$filterIsInstance = false;
        var9_9 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CheckedOutProject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                CheckedOutProject it = (CheckedOutProject)b;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getLastModified();
                it = (CheckedOutProject)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getLastModified()));
            }
        });
        $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var14_19 = $this$forEach$iv$iv$iv.iterator();
        while (var14_19.hasNext()) {
            block23: {
                block22: {
                    element$iv$iv = element$iv$iv$iv = var14_19.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (CheckedOutProject)element$iv$iv;
                    $i$a$-mapNotNull-RecentsViewModelImpl$viewState$projects$2 = false;
                    hiddenAt = hidden.get(it.getId-kZr3Ip4());
                    if (hiddenAt == null || hiddenAt.compareTo(it.getLastModified()) < 0) break block22;
                    v0 = null;
                    break block23;
                }
                environment = it instanceof RemoteProject != false ? environments.get(RemoteProject.EnvironmentId.box-impl(((RemoteProject)it).getEnvironmentId-U8Tzcn4())) : null;
                v1 = environment;
                if (v1 == null || (v1 = v1.getId()) == null) {
                    v1 = environmentId = DevEnvironmentId.Companion.getLocal();
                }
                if ((var23_29 = it) instanceof FileSystemProject) {
                    v2 = GetPresentablePathKt.getPresentablePath$default(((FileSystemProject)it).getPath(), null, null, 6, null);
                } else if (var23_29 instanceof RemoteProject) {
                    v2 = ((RemoteProject)it).getLocation();
                } else if (var23_29 instanceof FleetWorkspace) {
                    v2 = CollectionsKt.joinToString$default((Iterable)((FleetWorkspace)it).getPaths(), null, null, null, (int)0, null, null, (int)63, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                location = v2;
                launchMethods = projectModel.sortedLaunchMethods-CD0_5dk(it.getId-kZr3Ip4());
                v3 = var25_31 = new RecentProjectsState.Project.Action[3];
                v4 = 0;
                v5 = it instanceof FileSystemProject != false ? (FileSystemProject)it : null;
                if (v5 != null && (v5 = v5.getDirectory()) != null) {
                    var26_32 = v5;
                    var27_34 = v4;
                    var28_35 = v3;
                    $i$a$-let-RecentsViewModelImpl$viewState$projects$2$actions$1 = false;
                    var30_38 /* !! */  = new RecentProjectsState.Project.Action.OpenInFileManager((Path)p0);
                    v3 = var28_35;
                    v4 = var27_34;
                    v6 = var30_38 /* !! */ ;
                } else {
                    v6 = null;
                }
                v3[v4] = v6;
                v7 = var25_31;
                v8 = 1;
                if (environment != null) {
                    var27_34 = v8;
                    var28_35 = v7;
                    $i$a$-let-RecentsViewModelImpl$viewState$projects$2$actions$2 = false;
                    var30_38 /* !! */  = new RecentProjectsState.Project.Action.GoToEnvironment(e.getId(), e.getName());
                    v7 = var28_35;
                    v8 = var27_34;
                    v9 /* !! */  = var30_38 /* !! */ ;
                } else {
                    v9 /* !! */  = null;
                }
                v7[v8] = v9 /* !! */ ;
                var25_31[2] = RecentProjectsState.Project.Action.Hide.INSTANCE;
                actions = CollectionsKt.listOfNotNull((Object[])var25_31);
                v10 = statusPerProject.get(ProjectId.box-impl(it.getId-kZr3Ip4()));
                if (v10 == null) {
                    v10 = ProjectStatus.UNKNOWN;
                }
                status = v10;
                it = e = it.getIconSet();
                $i$a$-takeUnless-RecentsViewModelImpl$viewState$projects$2$icon$1 = false;
                icon = Intrinsics.areEqual((Object)it, (Object)IconSet.Companion.getEMPTY()) == false ? e : null;
                iconData = icon != null ? (ProjectIconData)new ProjectImageIconData(icon) : (ProjectIconData)new ProjectAvatarIconData(it.getName(), location);
                toolDescriptionsByToolId$delegate = LazyKt.lazy((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, viewState$lambda$1$2(java.util.Map com.jetbrains.toolbox.gateway.DevEnvironmentId ), ()Ljava/util/Map;)(toolDescriptions, (DevEnvironmentId)environmentId));
                var29_36 = ProjectManagerKt.preferredLaunchMethod-P5GpHtk(projectModel, it.getId-kZr3Ip4());
                if (var29_36 == null) ** GOTO lbl-1000
                method = var29_36;
                $i$a$-let-RecentsViewModelImpl$viewState$projects$2$linkedToolDescription$1 = false;
                var37_48 = method;
                if (var37_48 instanceof RemoteToolLaunchMethod) {
                    v11 = toolDescriptions.get(TuplesKt.to((Object)environmentId, (Object)ChannelId.box-impl(((RemoteToolLaunchMethod)method).getRemoteChannelId-5CZByfs())));
                    if (v11 != null) {
                        var38_49 = v11;
                        it = var38_49;
                        $i$a$-takeIf-RecentsViewModelImpl$viewState$projects$2$linkedToolDescription$1$1 = false;
                        v12 = it.getCounterpartStatus().isMissing() ? var38_49 : null;
                    } else {
                        v12 = null;
                    }
                } else {
                    v12 = var37_48 instanceof AvailableToolInstallAndOpenProject ? RecentsViewModelImpl.viewState$lambda$1$3((Lazy<? extends Map<ApplicationType, ToolDescription>>)toolDescriptionsByToolId$delegate).get(ApplicationType.box-impl(((AvailableToolInstallAndOpenProject)method).getToolId-UtVBrGo())) : (var37_48 instanceof RemoteAvailableToolLaunchMethod ? RecentsViewModelImpl.viewState$lambda$1$3((Lazy<? extends Map<ApplicationType, ToolDescription>>)toolDescriptionsByToolId$delegate).get(ApplicationType.box-impl(((RemoteAvailableToolLaunchMethod)method).getToolId-UtVBrGo())) : null);
                }
                if ((var41_52 = v12) != null) {
                    v13 = ProjectListViewModelImplKt.toViewState((ToolDescription)var41_52, (StateFlow<? extends I18n>)new SingleStateFlow<I18n>(this.i18n));
                } else lbl-1000:
                // 2 sources

                {
                    v13 = null;
                }
                linkedToolDescription = v13;
                var29_36 = it.getId-kZr3Ip4();
                var41_52 = it.getName();
                var42_53 = it.getDeleted();
                v14 = environment;
                var35_44 = v14 != null ? v14.getIcon() : null;
                v15 = environment;
                var36_45 = v15 != null ? v15.getName() : null;
                var37_47 = status.getActive();
                $this$mapNotNull$iv = launchMethods;
                $i$f$mapNotNull = false;
                var43_54 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var48_59 = $this$forEach$iv$iv$iv.iterator();
                while (var48_59.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var48_59.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    method = (LaunchMethod)element$iv$iv;
                    $i$a$-mapNotNull-RecentsViewModelImpl$viewState$projects$2$1 = false;
                    if (UtilsKt.toViewState(method, this.toolManager) == null) continue;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                var38_49 = (List)destination$iv$iv;
                v0 = new RecentProjectsState.Project((String)var29_36, var41_52, location, var42_53, var36_45, var35_44, iconData, status, var37_47, actions, (List)var38_49, linkedToolDescription, null);
            }
            if (v0 == null) continue;
            it$iv$iv = v0;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        projects = (List)destination$iv$iv;
        $this$partition$iv = projects;
        $i$f$partition = false;
        first$iv = new ArrayList<T>();
        second$iv = new ArrayList<T>();
        for (T element$iv : $this$partition$iv) {
            it = (RecentProjectsState.Project)element$iv;
            $i$a$-partition-RecentsViewModelImpl$viewState$1 = false;
            v16 = it.getActive() != false ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        var7_6 = new Pair(first$iv, second$iv);
        active = (List)var7_6.component1();
        closed = (List)var7_6.component2();
        return new RecentProjectsState(active, closed);
    }

    @Override
    public void markHidden-PTX8w5I(@NotNull String string, boolean value2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$com-jetbrains-toolbox-tools-model-ProjectId$-id$0");
        this.settingsManager.updateSettings((Function1<? super SelfSettings, SelfSettings>)((Function1)arg_0 -> RecentsViewModelImpl.markHidden_PTX8w5I$lambda$0(string, value2, arg_0)));
    }

    @Override
    @NotNull
    public StateFlow<List<ProjectId>> getCurrentlyOpening() {
        return this.safeProjectLauncher.getCurrentlyOpening();
    }

    @Override
    @Nullable
    public Object launchProjectWithDefaultMethod-PTX8w5I(@NotNull String string, @NotNull Continuation<? super SafeProjectLauncher.Result> $completion) {
        return this.safeProjectLauncher.launchProjectWithDefaultMethod-PTX8w5I(string, $completion);
    }

    @Override
    public void setCustomLaunchMethod-3yHvwFg(@NotNull String string, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$com-jetbrains-toolbox-tools-model-ProjectId$-projectId$0");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"$v$c$com-jetbrains-toolbox-project-LaunchMethodId$-launchMethodId$0");
        this.safeProjectLauncher.setCustomLaunchMethod-3yHvwFg(string, string2);
    }

    private static final Map hiddenProjects$lambda$0(SelfSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getHiddenProjects(ProjectSettings.HiddenFrom.Recents);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map viewState$lambda$1$2(Map $toolDescriptions, DevEnvironmentId $environmentId) {
        void $this$associateByTo$iv$iv;
        Map $this$filterKeys$iv = $toolDescriptions;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            Pair it = (Pair)entry$iv.getKey();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)$environmentId)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$associateBy$iv = ((Map)result$iv).values();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ToolDescription toolDescription = (ToolDescription)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(ApplicationType.box-impl(it.getToolId-UtVBrGo()), element$iv$iv);
        }
        return destination$iv$iv;
    }

    private static final Map<ApplicationType, ToolDescription> viewState$lambda$1$3(Lazy<? extends Map<ApplicationType, ToolDescription>> $toolDescriptionsByToolId$delegate) {
        Lazy<? extends Map<ApplicationType, ToolDescription>> lazy = $toolDescriptionsByToolId$delegate;
        return (Map)lazy.getValue();
    }

    private static final SelfSettings markHidden_PTX8w5I$lambda$0(String string, boolean $value, SelfSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.markProjectHidden(string, $value, ProjectSettings.HiddenFrom.Recents);
    }

    public static final /* synthetic */ ProjectManager access$getProjectManager$p(RecentsViewModelImpl $this) {
        return $this.projectManager;
    }

    public static final /* synthetic */ ToolStateAggregator access$getToolStateAggregator$p(RecentsViewModelImpl $this) {
        return $this.toolStateAggregator;
    }

    public static final /* synthetic */ StateFlow access$getHiddenProjects$p(RecentsViewModelImpl $this) {
        return $this.hiddenProjects;
    }

    public static final /* synthetic */ RecentProjectsState access$viewState(RecentsViewModelImpl $this, ProjectManager.Model projectModel, Map statusPerProject, Map toolDescriptions, Map hidden, Map environments) {
        return $this.viewState(projectModel, statusPerProject, toolDescriptions, hidden, environments);
    }

    public static final class Environment {
        @NotNull
        private final DevEnvironmentId id;
        @Nullable
        private final Image icon;
        @NotNull
        private final String name;

        public Environment(@NotNull DevEnvironmentId id, @Nullable Image icon2, @NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.id = id;
            this.icon = icon2;
            this.name = name2;
        }

        @NotNull
        public final DevEnvironmentId getId() {
            return this.id;
        }

        @Nullable
        public final Image getIcon() {
            return this.icon;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public String toString() {
            return "Environment(id=" + this.id + ", icon=" + this.icon + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + (this.icon == null ? 0 : this.icon.hashCode());
            result2 = result2 * 31 + this.name.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Environment)) {
                return false;
            }
            Environment environment = (Environment)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)environment.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.icon, (Object)environment.icon)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)environment.name);
        }
    }
}

