/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.projects;

import com.jetbrains.toolbox.project.devcontainers.DevcontainersManager;
import com.jetbrains.toolbox.tools.model.ProjectId;
import com.jetbrains.toolbox.viewmodel.projects.FileSystemProjectViewState;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectListViewState {
    @NotNull
    private final List<FileSystemProjectViewState> favoriteProjects;
    @NotNull
    private final List<FileSystemProjectViewState> fileSystemProjects;
    @NotNull
    private final DevcontainersManager.State devcontainersState;
    @NotNull
    private final List<ProjectId> currentlyOpening;

    public ProjectListViewState(@NotNull List<FileSystemProjectViewState> favoriteProjects, @NotNull List<FileSystemProjectViewState> fileSystemProjects, @NotNull DevcontainersManager.State devcontainersState, @NotNull List<ProjectId> currentlyOpening) {
        Intrinsics.checkNotNullParameter(favoriteProjects, (String)"favoriteProjects");
        Intrinsics.checkNotNullParameter(fileSystemProjects, (String)"fileSystemProjects");
        Intrinsics.checkNotNullParameter((Object)devcontainersState, (String)"devcontainersState");
        Intrinsics.checkNotNullParameter(currentlyOpening, (String)"currentlyOpening");
        this.favoriteProjects = favoriteProjects;
        this.fileSystemProjects = fileSystemProjects;
        this.devcontainersState = devcontainersState;
        this.currentlyOpening = currentlyOpening;
    }

    @NotNull
    public final List<FileSystemProjectViewState> getFavoriteProjects() {
        return this.favoriteProjects;
    }

    @NotNull
    public final List<FileSystemProjectViewState> getFileSystemProjects() {
        return this.fileSystemProjects;
    }

    @NotNull
    public final DevcontainersManager.State getDevcontainersState() {
        return this.devcontainersState;
    }

    @NotNull
    public final List<ProjectId> getCurrentlyOpening() {
        return this.currentlyOpening;
    }

    @NotNull
    public final List<FileSystemProjectViewState> environmentViewProjects() {
        return CollectionsKt.plus((Collection)this.favoriteProjects, (Iterable)this.fileSystemProjects);
    }

    public final boolean isEmpty() {
        return this.favoriteProjects.isEmpty() && this.fileSystemProjects.isEmpty();
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @NotNull
    public String toString() {
        return "ProjectListViewState(favoriteProjects=" + this.favoriteProjects + ", fileSystemProjects=" + this.fileSystemProjects + ", devcontainersState=" + this.devcontainersState + ", currentlyOpening=" + this.currentlyOpening + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.favoriteProjects).hashCode();
        result2 = result2 * 31 + ((Object)this.fileSystemProjects).hashCode();
        result2 = result2 * 31 + this.devcontainersState.hashCode();
        result2 = result2 * 31 + ((Object)this.currentlyOpening).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProjectListViewState)) {
            return false;
        }
        ProjectListViewState projectListViewState = (ProjectListViewState)other;
        if (!Intrinsics.areEqual(this.favoriteProjects, projectListViewState.favoriteProjects)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fileSystemProjects, projectListViewState.fileSystemProjects)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.devcontainersState, (Object)projectListViewState.devcontainersState)) {
            return false;
        }
        return Intrinsics.areEqual(this.currentlyOpening, projectListViewState.currentlyOpening);
    }
}

