/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.progress.impl;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.common.Progress;
import com.jetbrains.toolbox.common.ProgressState;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.viewmodel.progress.ActionProgressViewModel;
import com.jetbrains.toolbox.viewmodel.progress.ActionProgressViewState;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

public final class ActionProgressViewModelImpl
implements ActionProgressViewModel {
    @NotNull
    private final Progress actionProgress;
    @NotNull
    private final StateFlow<Float> value;
    @NotNull
    private final StateFlow<ActionProgressViewState> state;

    public ActionProgressViewModelImpl(@NotNull Progress actionProgress, @NotNull StateFlow<? extends I18n> i18nState) {
        Intrinsics.checkNotNullParameter((Object)actionProgress, (String)"actionProgress");
        Intrinsics.checkNotNullParameter(i18nState, (String)"i18nState");
        this.actionProgress = actionProgress;
        this.value = this.actionProgress.getValue();
        this.state = FlowExtensionsKt.combineStates(this.actionProgress.getState(), i18nState, ActionProgressViewModelImpl::state$lambda$0);
    }

    @Override
    @NotNull
    public StateFlow<Float> getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public StateFlow<ActionProgressViewState> getState() {
        return this.state;
    }

    @Override
    public void cancel(@NotNull LocalizableString title2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        this.actionProgress.cancel(title2);
    }

    private static final ActionProgressViewState state$lambda$0(ProgressState state2, I18n i18n) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        LocalizableString localizableString = state2.getError();
        return new ActionProgressViewState(LocalizableStringExKt.localize(state2.getTitle(), i18n), state2.getType(), state2.getTotalSteps(), state2.isCancelable(), state2.isCanceled(), localizableString != null ? LocalizableStringExKt.localize(localizableString, i18n) : null, state2.isFinished());
    }
}

