/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.diskUsage;

import com.jetbrains.toolbox.common.io.FileSize;
import com.jetbrains.toolbox.diskUsage.LeftoverTool;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LeftoverIDEDirectoriesViewState {
    @Nullable
    private final String fileManagerName;
    @NotNull
    private final List<ToolWithInfo> tools;

    public LeftoverIDEDirectoriesViewState(@Nullable String fileManagerName, @NotNull List<ToolWithInfo> tools2) {
        Intrinsics.checkNotNullParameter(tools2, (String)"tools");
        this.fileManagerName = fileManagerName;
        this.tools = tools2;
    }

    @Nullable
    public final String getFileManagerName() {
        return this.fileManagerName;
    }

    @NotNull
    public final List<ToolWithInfo> getTools() {
        return this.tools;
    }

    @NotNull
    public String toString() {
        return "LeftoverIDEDirectoriesViewState(fileManagerName=" + this.fileManagerName + ", tools=" + this.tools + ")";
    }

    public int hashCode() {
        int result2 = this.fileManagerName == null ? 0 : this.fileManagerName.hashCode();
        result2 = result2 * 31 + ((Object)this.tools).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LeftoverIDEDirectoriesViewState)) {
            return false;
        }
        LeftoverIDEDirectoriesViewState leftoverIDEDirectoriesViewState = (LeftoverIDEDirectoriesViewState)other;
        if (!Intrinsics.areEqual((Object)this.fileManagerName, (Object)leftoverIDEDirectoriesViewState.fileManagerName)) {
            return false;
        }
        return Intrinsics.areEqual(this.tools, leftoverIDEDirectoriesViewState.tools);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class ToolWithInfo {
        @NotNull
        private final LeftoverTool tool;
        @NotNull
        private final List<String> paths;
        private final long totalSize;
        @NotNull
        private final Instant lastModifiedAt;

        private ToolWithInfo(LeftoverTool tool, List<String> paths, long totalSize, Instant lastModifiedAt) {
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            Intrinsics.checkNotNullParameter((Object)lastModifiedAt, (String)"lastModifiedAt");
            this.tool = tool;
            this.paths = paths;
            this.totalSize = totalSize;
            this.lastModifiedAt = lastModifiedAt;
        }

        @NotNull
        public final LeftoverTool getTool() {
            return this.tool;
        }

        @NotNull
        public final List<String> getPaths() {
            return this.paths;
        }

        public final long getTotalSize-WN0b6rc() {
            return this.totalSize;
        }

        @NotNull
        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        @NotNull
        public String toString() {
            return "ToolWithInfo(tool=" + this.tool + ", paths=" + this.paths + ", totalSize=" + FileSize.toString-impl(this.totalSize) + ", lastModifiedAt=" + this.lastModifiedAt + ")";
        }

        public int hashCode() {
            int result2 = this.tool.hashCode();
            result2 = result2 * 31 + ((Object)this.paths).hashCode();
            result2 = result2 * 31 + FileSize.hashCode-impl(this.totalSize);
            result2 = result2 * 31 + this.lastModifiedAt.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ToolWithInfo)) {
                return false;
            }
            ToolWithInfo toolWithInfo = (ToolWithInfo)other;
            if (!Intrinsics.areEqual((Object)this.tool, (Object)toolWithInfo.tool)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.paths, toolWithInfo.paths)) {
                return false;
            }
            if (!FileSize.equals-impl0(this.totalSize, toolWithInfo.totalSize)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lastModifiedAt, (Object)toolWithInfo.lastModifiedAt);
        }

        public /* synthetic */ ToolWithInfo(LeftoverTool tool, List paths, long totalSize, Instant lastModifiedAt, DefaultConstructorMarker $constructor_marker) {
            this(tool, paths, totalSize, lastModifiedAt);
        }
    }
}

