/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel;

import com.jetbrains.toolbox.api.remoteDev.states.EnvironmentDescription;
import com.jetbrains.toolbox.api.remoteDev.states.RemoteEnvironmentState;
import com.jetbrains.toolbox.api.remoteDev.states.StandardRemoteEnvironmentState;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.DevEnvironmentProviderId;
import com.jetbrains.toolbox.gateway.states.AgentState;
import com.jetbrains.toolbox.gateway.states.StandardAgentState;
import com.jetbrains.toolbox.gateway.ui.LowResourceWarning;
import com.jetbrains.toolbox.platform.image.internal.Image;
import com.jetbrains.toolbox.theme.BackgroundColors;
import com.jetbrains.toolbox.theme.ThemeColor;
import com.jetbrains.toolbox.viewmodel.ActionModel;
import com.jetbrains.toolbox.viewmodel.RemoteEnvironmentBandwidthUsageViewState;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteEnvironmentViewState {
    @NotNull
    private final DevEnvironmentId id;
    @NotNull
    private final String devEnvironmentProviderId;
    @NotNull
    private final String name;
    @Nullable
    private final Image icon;
    @NotNull
    private final RemoteEnvironmentState environmentState;
    @NotNull
    private final Flow<RemoteEnvironmentBandwidthUsageViewState> bandwidthUsage;
    @NotNull
    private final AgentState agentState;
    @NotNull
    private final EnvironmentDescription description;
    @NotNull
    private final StateFlow<List<ActionModel>> actions;
    @NotNull
    private final BackgroundColors backgroundColors;
    @Nullable
    private final String secondaryInformation;
    @Nullable
    private final LowResourceWarning lowResourcesWarning;
    @NotNull
    private final ThemeColor islandColors;
    private final boolean inErrorState;
    private final boolean isConnected;

    private RemoteEnvironmentViewState(DevEnvironmentId id, String devEnvironmentProviderId, String name2, Image icon2, RemoteEnvironmentState environmentState, Flow<RemoteEnvironmentBandwidthUsageViewState> bandwidthUsage, AgentState agentState, EnvironmentDescription description2, StateFlow<? extends List<ActionModel>> actions2, BackgroundColors backgroundColors, String secondaryInformation, LowResourceWarning lowResourcesWarning, ThemeColor islandColors) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)devEnvironmentProviderId, (String)"devEnvironmentProviderId");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)environmentState, (String)"environmentState");
        Intrinsics.checkNotNullParameter(bandwidthUsage, (String)"bandwidthUsage");
        Intrinsics.checkNotNullParameter((Object)agentState, (String)"agentState");
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)backgroundColors, (String)"backgroundColors");
        Intrinsics.checkNotNullParameter((Object)islandColors, (String)"islandColors");
        this.id = id;
        this.devEnvironmentProviderId = devEnvironmentProviderId;
        this.name = name2;
        this.icon = icon2;
        this.environmentState = environmentState;
        this.bandwidthUsage = bandwidthUsage;
        this.agentState = agentState;
        this.description = description2;
        this.actions = actions2;
        this.backgroundColors = backgroundColors;
        this.secondaryInformation = secondaryInformation;
        this.lowResourcesWarning = lowResourcesWarning;
        this.islandColors = islandColors;
        this.inErrorState = this.environmentState == StandardRemoteEnvironmentState.Error || this.agentState == StandardAgentState.Error;
        this.isConnected = this.agentState == StandardAgentState.Connected;
    }

    public /* synthetic */ RemoteEnvironmentViewState(DevEnvironmentId devEnvironmentId, String string, String string2, Image image, RemoteEnvironmentState remoteEnvironmentState, Flow flow2, AgentState agentState, EnvironmentDescription environmentDescription, StateFlow stateFlow, BackgroundColors backgroundColors, String string3, LowResourceWarning lowResourceWarning, ThemeColor themeColor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x400) != 0) {
            string3 = null;
        }
        if ((n & 0x800) != 0) {
            lowResourceWarning = null;
        }
        this(devEnvironmentId, string, string2, image, remoteEnvironmentState, flow2, agentState, environmentDescription, stateFlow, backgroundColors, string3, lowResourceWarning, themeColor, null);
    }

    @NotNull
    public final DevEnvironmentId getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final Image getIcon() {
        return this.icon;
    }

    @NotNull
    public final RemoteEnvironmentState getEnvironmentState() {
        return this.environmentState;
    }

    @NotNull
    public final Flow<RemoteEnvironmentBandwidthUsageViewState> getBandwidthUsage() {
        return this.bandwidthUsage;
    }

    @NotNull
    public final AgentState getAgentState() {
        return this.agentState;
    }

    @NotNull
    public final EnvironmentDescription getDescription() {
        return this.description;
    }

    @NotNull
    public final StateFlow<List<ActionModel>> getActions() {
        return this.actions;
    }

    @NotNull
    public final BackgroundColors getBackgroundColors() {
        return this.backgroundColors;
    }

    @Nullable
    public final String getSecondaryInformation() {
        return this.secondaryInformation;
    }

    @Nullable
    public final LowResourceWarning getLowResourcesWarning() {
        return this.lowResourcesWarning;
    }

    @NotNull
    public final ThemeColor getIslandColors() {
        return this.islandColors;
    }

    public final boolean getInErrorState() {
        return this.inErrorState;
    }

    @NotNull
    public String toString() {
        return "RemoteEnvironmentViewState(id=" + this.id + ", devEnvironmentProviderId=" + DevEnvironmentProviderId.toString-impl(this.devEnvironmentProviderId) + ", name=" + this.name + ", icon=" + this.icon + ", environmentState=" + this.environmentState + ", bandwidthUsage=" + this.bandwidthUsage + ", agentState=" + this.agentState + ", description=" + this.description + ", actions=" + this.actions + ", backgroundColors=" + this.backgroundColors + ", secondaryInformation=" + this.secondaryInformation + ", lowResourcesWarning=" + this.lowResourcesWarning + ", islandColors=" + this.islandColors + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + DevEnvironmentProviderId.hashCode-impl(this.devEnvironmentProviderId);
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + (this.icon == null ? 0 : this.icon.hashCode());
        result2 = result2 * 31 + this.environmentState.hashCode();
        result2 = result2 * 31 + this.bandwidthUsage.hashCode();
        result2 = result2 * 31 + this.agentState.hashCode();
        result2 = result2 * 31 + this.description.hashCode();
        result2 = result2 * 31 + this.actions.hashCode();
        result2 = result2 * 31 + this.backgroundColors.hashCode();
        result2 = result2 * 31 + (this.secondaryInformation == null ? 0 : this.secondaryInformation.hashCode());
        result2 = result2 * 31 + (this.lowResourcesWarning == null ? 0 : this.lowResourcesWarning.hashCode());
        result2 = result2 * 31 + this.islandColors.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RemoteEnvironmentViewState)) {
            return false;
        }
        RemoteEnvironmentViewState remoteEnvironmentViewState = (RemoteEnvironmentViewState)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)remoteEnvironmentViewState.id)) {
            return false;
        }
        if (!DevEnvironmentProviderId.equals-impl0(this.devEnvironmentProviderId, remoteEnvironmentViewState.devEnvironmentProviderId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)remoteEnvironmentViewState.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.icon, (Object)remoteEnvironmentViewState.icon)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.environmentState, (Object)remoteEnvironmentViewState.environmentState)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.bandwidthUsage, remoteEnvironmentViewState.bandwidthUsage)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.agentState, (Object)remoteEnvironmentViewState.agentState)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)remoteEnvironmentViewState.description)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.actions, remoteEnvironmentViewState.actions)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.backgroundColors, (Object)remoteEnvironmentViewState.backgroundColors)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.secondaryInformation, (Object)remoteEnvironmentViewState.secondaryInformation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lowResourcesWarning, (Object)remoteEnvironmentViewState.lowResourcesWarning)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.islandColors, (Object)remoteEnvironmentViewState.islandColors);
    }

    public /* synthetic */ RemoteEnvironmentViewState(DevEnvironmentId id, String devEnvironmentProviderId, String name2, Image icon2, RemoteEnvironmentState environmentState, Flow bandwidthUsage, AgentState agentState, EnvironmentDescription description2, StateFlow actions2, BackgroundColors backgroundColors, String secondaryInformation, LowResourceWarning lowResourcesWarning, ThemeColor islandColors, DefaultConstructorMarker $constructor_marker) {
        this(id, devEnvironmentProviderId, name2, icon2, environmentState, (Flow<RemoteEnvironmentBandwidthUsageViewState>)bandwidthUsage, agentState, description2, (StateFlow<? extends List<ActionModel>>)actions2, backgroundColors, secondaryInformation, lowResourcesWarning, islandColors);
    }
}

