/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel;

import com.jetbrains.toolbox.ExtensionsKt;
import com.jetbrains.toolbox.ProviderViewManager;
import com.jetbrains.toolbox.agentNetworkApi.settings.dto.EnvironmentDto;
import com.jetbrains.toolbox.agentNetworkApi.tools.ToolManipulationService;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.remoteDev.states.EnvironmentDescription;
import com.jetbrains.toolbox.api.remoteDev.states.RemoteEnvironmentState;
import com.jetbrains.toolbox.api.ui.actions.ActionDescription;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.common.platform.SystemRequirements;
import com.jetbrains.toolbox.gateway.DevEnvironment;
import com.jetbrains.toolbox.gateway.DevEnvironmentFeature;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.DevEnvironmentProvider;
import com.jetbrains.toolbox.gateway.DevEnvironmentSnapshot;
import com.jetbrains.toolbox.gateway.RawInterfaces;
import com.jetbrains.toolbox.gateway.ViewContentConfig;
import com.jetbrains.toolbox.gateway.log.RemoteDevLogArchiveCollector;
import com.jetbrains.toolbox.gateway.states.AgentState;
import com.jetbrains.toolbox.gateway.ui.LowResourceWarning;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.platform.image.ImageResource;
import com.jetbrains.toolbox.platform.image.internal.Image;
import com.jetbrains.toolbox.platform.image.internal.ImagesKt;
import com.jetbrains.toolbox.theme.BackgroundColors;
import com.jetbrains.toolbox.theme.ThemeColor;
import com.jetbrains.toolbox.viewmodel.ActionModel;
import com.jetbrains.toolbox.viewmodel.DevEnvironmentViewModel;
import com.jetbrains.toolbox.viewmodel.RemoteEnvironmentBandwidthUsageViewState;
import com.jetbrains.toolbox.viewmodel.RemoteEnvironmentViewState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nDevEnvironmentViewModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevEnvironmentViewModelImpl.kt\ncom/jetbrains/toolbox/viewmodel/DevEnvironmentViewModelImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1563#2:103\n1634#2,3:104\n*S KotlinDebug\n*F\n+ 1 DevEnvironmentViewModelImpl.kt\ncom/jetbrains/toolbox/viewmodel/DevEnvironmentViewModelImpl\n*L\n78#1:103\n78#1:104,3\n*E\n"})
public final class DevEnvironmentViewModelImpl
implements DevEnvironmentViewModel {
    @NotNull
    private final DevEnvironmentProvider provider;
    @NotNull
    private final DevEnvironment environment;
    @NotNull
    private final RemoteDevLogArchiveCollector logArchiveCollector;
    @NotNull
    private final ProviderViewManager providerViewManager;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final I18n i18n;
    @NotNull
    private final MutableStateFlow<EnvironmentDto> environmentInfo;
    @NotNull
    private final MutableStateFlow<Integer> environmentInstalledToolsNumber;
    @NotNull
    private final StateFlow<RemoteEnvironmentViewState> state;
    @Nullable
    private final ViewContentConfig viewConfig;
    @Nullable
    private final Map<LocalizableString, String> additionalInformation;

    public DevEnvironmentViewModelImpl(@NotNull DevEnvironmentProvider provider2, @NotNull DevEnvironment environment, @NotNull RemoteDevLogArchiveCollector logArchiveCollector, @NotNull ProviderViewManager providerViewManager, @NotNull CoroutineScope coroutineScope, @NotNull I18n i18n) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)logArchiveCollector, (String)"logArchiveCollector");
        Intrinsics.checkNotNullParameter((Object)providerViewManager, (String)"providerViewManager");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        this.provider = provider2;
        this.environment = environment;
        this.logArchiveCollector = logArchiveCollector;
        this.providerViewManager = providerViewManager;
        this.coroutineScope = coroutineScope;
        this.i18n = i18n;
        this.environmentInfo = StateFlowKt.MutableStateFlow(null);
        this.environmentInstalledToolsNumber = StateFlowKt.MutableStateFlow(null);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DevEnvironmentViewModelImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.environment.getRawInterfaces()), (Function2)((Function2)new Function2<RawInterfaces, Continuation<? super Unit>, Object>(this.this$0, null){
                            Object L$1;
                            Object L$2;
                            int I$0;
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ DevEnvironmentViewModelImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                block9: {
                                    block8: {
                                        var2_2 = (RawInterfaces)this.L$0;
                                        var8_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = DevEnvironmentViewModelImpl.access$getEnvironmentInfo$p(this.this$0);
                                                if (rawInterfaces == null || (var3_4 = rawInterfaces.getSettingsService()) == null) break;
                                                var7_6 = v0;
                                                this.L$0 = rawInterfaces;
                                                this.L$1 = var7_6;
                                                this.label = 1;
                                                v1 = var3_4.getEnvironmentInfo((Continuation)this);
                                                if (v1 == var8_3) {
                                                    return var8_3;
                                                }
                                                ** GOTO lbl20
                                            }
                                            case 1: {
                                                var7_6 = (MutableStateFlow)this.L$1;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v1 = $result;
lbl20:
                                                // 2 sources

                                                v0 = var7_6;
                                                v2 = (EnvironmentDto)v1;
                                                break block8;
                                            }
                                        }
                                        v2 = null;
                                    }
                                    v0.setValue(v2);
                                    v3 = rawInterfaces;
                                    if (v3 != null) {
                                        var3_4 = v3;
                                        var4_7 = this.this$0;
                                        $this$invokeSuspend_u24lambda_u240 = var3_4;
                                        $i$a$-apply-DevEnvironmentViewModelImpl$1$1$1 = 0;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)rawInterfaces);
                                        this.L$1 = var3_4;
                                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u240);
                                        this.I$0 = $i$a$-apply-DevEnvironmentViewModelImpl$1$1$1;
                                        this.label = 2;
                                        v4 = ToolManipulationService.getInstalledToolsNumber-sDA0F08$default((ToolManipulationService)$this$invokeSuspend_u24lambda_u240.getRemoteToolService(), null, (int)1, null).collect(new FlowCollector(var4_7){
                                            final /* synthetic */ DevEnvironmentViewModelImpl this$0;
                                            {
                                                this.this$0 = $receiver;
                                            }

                                            public final Object emit(Integer toolsNumber, Continuation<? super Unit> $completion) {
                                                DevEnvironmentViewModelImpl.access$getEnvironmentInstalledToolsNumber$p(this.this$0).setValue((Object)toolsNumber);
                                                return Unit.INSTANCE;
                                            }
                                        }, (Continuation)this);
                                        if (v4 == var8_3) {
                                            return var8_3;
                                        }
                                    }
                                    break block9;
                                    {
                                        case 2: {
                                            $i$a$-apply-DevEnvironmentViewModelImpl$1$1$1 = this.I$0;
                                            $this$invokeSuspend_u24lambda_u240 = (RawInterfaces)this.L$2;
                                            var3_5 = (RawInterfaces)this.L$1;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v4 = $result;
                                        }
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(RawInterfaces p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.state = FlowExtensionsKt.combineStates(this.environment.getState(), this.environment.getAgentState(), this.environment.getDescriptionState(), this.environment.getName(), (StateFlow)this.environmentInfo, (StateFlow)this.environmentInstalledToolsNumber, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> DevEnvironmentViewModelImpl.state$lambda$0(this, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5));
        this.viewConfig = this.environment.getViewContentConfig();
        this.additionalInformation = this.environment.getAdditionalInformation();
    }

    @Override
    @NotNull
    public StateFlow<RemoteEnvironmentViewState> getState() {
        return this.state;
    }

    private final RemoteEnvironmentViewState toViewState(DevEnvironmentSnapshot environmentSnapshot, EnvironmentDto environmentInfo, Integer installedToolsNumber) {
        LowResourceWarning lowResourceWarning;
        DevEnvironmentId devEnvironmentId = this.environment.getId();
        String string = this.provider.getId-rwbms5E();
        String string2 = environmentSnapshot.getName();
        ImageResource imageResource = this.provider.getIcon();
        Image image = imageResource != null ? ImagesKt.getImage((ImageResource)imageResource) : null;
        RemoteEnvironmentState remoteEnvironmentState = environmentSnapshot.getEnvironment();
        EnvironmentDescription environmentDescription = environmentSnapshot.getDescription();
        AgentState agentState = environmentSnapshot.getAgent();
        StateFlow stateFlow = FlowExtensionsKt.mapState(this.environment.getActions(), arg_0 -> DevEnvironmentViewModelImpl.toViewState$lambda$0(this, arg_0));
        BackgroundColors backgroundColors = this.provider.getBackgroundColors();
        ThemeColor themeColor = this.provider.getIslandColors();
        Integer n = installedToolsNumber;
        if (n != null) {
            int toolsNumber = ((Number)n).intValue();
            boolean bl = false;
            EnvironmentDto environmentDto = environmentInfo;
            lowResourceWarning = environmentDto != null && (environmentDto = environmentDto.getSystemInfo()) != null ? ExtensionsKt.checkAgainst((EnvironmentDto.SystemInfo)environmentDto, toolsNumber > 0, SystemRequirements.Remote.INSTANCE) : null;
        } else {
            lowResourceWarning = null;
        }
        LowResourceWarning lowResourceWarning2 = lowResourceWarning;
        Flow<RemoteEnvironmentBandwidthUsageViewState> flow2 = this.providerViewManager.settingsGatedBandwidthModel(this.environment.getTransportStats());
        return new RemoteEnvironmentViewState(devEnvironmentId, string, string2, image, remoteEnvironmentState, flow2, agentState, environmentDescription, stateFlow, backgroundColors, null, lowResourceWarning2, themeColor, 1024, null);
    }

    @Override
    @Nullable
    public Function1<String, Unit> getRenameCallback() {
        return this.environment.isRenameable() ? arg_0 -> DevEnvironmentViewModelImpl._get_renameCallback_$lambda$0(this, arg_0) : null;
    }

    @Override
    @Nullable
    public ViewContentConfig getViewConfig() {
        return this.viewConfig;
    }

    @Override
    @Nullable
    public Map<LocalizableString, String> getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Override
    @Nullable
    public Object getFeatures(@NotNull Continuation<? super List<? extends DevEnvironmentFeature>> $completion) {
        return this.environment.getFeatures($completion);
    }

    private static final RemoteEnvironmentViewState state$lambda$0(DevEnvironmentViewModelImpl this$0, RemoteEnvironmentState environment, AgentState agent, EnvironmentDescription description2, String name2, EnvironmentDto info, Integer environmentInstalledToolsNumber) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this$0.toViewState(new DevEnvironmentSnapshot(environment, agent, description2, name2), info, environmentInstalledToolsNumber);
    }

    /*
     * WARNING - void declaration
     */
    private static final List toViewState$lambda$0(DevEnvironmentViewModelImpl this$0, List it) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$map$iv = it;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void actionDescription;
            ActionDescription actionDescription2 = (ActionDescription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ActionModel.Companion.fromActionDescription((ActionDescription)actionDescription, this$0.i18n));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit _get_renameCallback_$lambda$0(DevEnvironmentViewModelImpl this$0, String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        this$0.environment.setName(newName);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MutableStateFlow access$getEnvironmentInfo$p(DevEnvironmentViewModelImpl $this) {
        return $this.environmentInfo;
    }

    public static final /* synthetic */ MutableStateFlow access$getEnvironmentInstalledToolsNumber$p(DevEnvironmentViewModelImpl $this) {
        return $this.environmentInstalledToolsNumber;
    }
}

