/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.validation;

import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import okio.FileHandle;
import okio.FileMetadata;
import okio.FileSystem;
import okio.ForwardingFileSystem;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileSystemWithThreadValidation
extends ForwardingFileSystem {
    public FileSystemWithThreadValidation(@NotNull FileSystem delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        super(delegate);
    }

    public void copy(@NotNull Path source, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        super.copy(source, target);
    }

    public void deleteRecursively(@NotNull Path fileOrDirectory, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)fileOrDirectory, (String)"fileOrDirectory");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        super.deleteRecursively(fileOrDirectory, mustExist);
    }

    @NotNull
    public Sink appendingSink(@NotNull Path file, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        return super.appendingSink(file, mustExist);
    }

    public void atomicMove(@NotNull Path source, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        super.atomicMove(source, target);
    }

    @NotNull
    public Path canonicalize(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        return super.canonicalize(path2);
    }

    public void createDirectory(@NotNull Path dir, boolean mustCreate) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        super.createDirectory(dir, mustCreate);
    }

    public void createSymlink(@NotNull Path source, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        super.createSymlink(source, target);
    }

    public void delete(@NotNull Path path2, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        super.delete(path2, mustExist);
    }

    @NotNull
    public List<Path> list(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        return super.list(dir);
    }

    @Nullable
    public List<Path> listOrNull(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        return super.listOrNull(dir);
    }

    @NotNull
    public Sequence<Path> listRecursively(@NotNull Path dir, boolean followSymlinks) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        return super.listRecursively(dir, followSymlinks);
    }

    @Nullable
    public FileMetadata metadataOrNull(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        return super.metadataOrNull(path2);
    }

    @NotNull
    public Path onPathParameter(@NotNull Path path2, @NotNull String functionName, @NotNull String parameterName) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        Intrinsics.checkNotNullParameter((Object)parameterName, (String)"parameterName");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        return super.onPathParameter(path2, functionName, parameterName);
    }

    @NotNull
    public Path onPathResult(@NotNull Path path2, @NotNull String functionName) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        return super.onPathResult(path2, functionName);
    }

    @NotNull
    public FileHandle openReadOnly(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        return super.openReadOnly(file);
    }

    @NotNull
    public FileHandle openReadWrite(@NotNull Path file, boolean mustCreate, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        return super.openReadWrite(file, mustCreate, mustExist);
    }

    @NotNull
    public Sink sink(@NotNull Path file, boolean mustCreate) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        return super.sink(file, mustCreate);
    }

    @NotNull
    public Source source(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        return super.source(file);
    }
}

