/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.window;

import androidx.compose.material.SwipeableState;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.DisposableEffectResult;
import androidx.compose.runtime.DisposableEffectScope;
import androidx.compose.runtime.EffectsKt;
import androidx.compose.runtime.ProvidableCompositionLocal;
import androidx.compose.runtime.ProvidedValue;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.saveable.RememberSaveableKt;
import androidx.compose.runtime.saveable.SaveableStateRegistry;
import androidx.compose.runtime.saveable.SaveableStateRegistryKt;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.unit.DpKt;
import androidx.compose.ui.window.WindowExceptionHandler;
import androidx.compose.ui.window.WindowPosition;
import androidx.compose.ui.window.WindowPosition_desktopKt;
import com.jetbrains.toolbox.desktop.UtilKt;
import com.jetbrains.toolbox.fus.Fus;
import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.lifecycle.AppLifecycleTracker;
import com.jetbrains.toolbox.manager.StatisticsManager;
import com.jetbrains.toolbox.ui.ConstantsKt;
import com.jetbrains.toolbox.ui.LocalsKt;
import com.jetbrains.toolbox.ui.SavedStateHolder;
import com.jetbrains.toolbox.ui.ScreenManager;
import com.jetbrains.toolbox.ui.SnackbarUtilsKt;
import com.jetbrains.toolbox.ui.ToolboxUi;
import com.jetbrains.toolbox.ui.navigation.Navigator;
import com.jetbrains.toolbox.ui.navigation.NavigatorFactory;
import com.jetbrains.toolbox.ui.navigation.NavigatorImplKt;
import com.jetbrains.toolbox.ui.navigation.Screen;
import com.jetbrains.toolbox.ui.window.ComposeWindowManager;
import com.jetbrains.toolbox.ui.window.MainWindowID;
import com.jetbrains.toolbox.ui.window.MainWindowManager;
import com.jetbrains.toolbox.ui.window.MainWindowManagerImpl;
import com.jetbrains.toolbox.ui.window.SnackbarItemsProvider;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.crystal.WindowDescriptor;
import org.jetbrains.crystal.geometry.UnitKt;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nMainWindowManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainWindowManagerImpl.kt\ncom/jetbrains/toolbox/ui/window/MainWindowManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class MainWindowManagerImpl
implements MainWindowManager {
    @NotNull
    private final ToolboxUi ui;
    @NotNull
    private final I18n i18n;
    @NotNull
    private final ComposeWindowManager composeWindowManager;
    @NotNull
    private final ScreenManager screenManager;
    @NotNull
    private final SnackbarItemsProvider snackbarItemsProvider;
    @NotNull
    private final NavigatorFactory navigatorFactory;
    @NotNull
    private final SavedStateHolder savedStateHolder;
    @NotNull
    private final StatisticsManager statisticsManager;
    @NotNull
    private final AppLifecycleTracker lifecycleTracker;
    @NotNull
    private final MainWindowID id;
    @NotNull
    private MutableStateFlow<WindowDescriptor> _windowDescriptorState;
    @NotNull
    private final StateFlow<WindowDescriptor> windowDescriptorState;
    @Nullable
    private Navigator _navigator;
    public static final int $stable = 8;

    public MainWindowManagerImpl(@NotNull ToolboxUi ui, @NotNull I18n i18n, @NotNull ComposeWindowManager composeWindowManager, @NotNull ScreenManager screenManager, @NotNull SnackbarItemsProvider snackbarItemsProvider, @NotNull NavigatorFactory navigatorFactory, @NotNull SavedStateHolder savedStateHolder, @NotNull StatisticsManager statisticsManager, @NotNull AppLifecycleTracker lifecycleTracker) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        Intrinsics.checkNotNullParameter((Object)composeWindowManager, (String)"composeWindowManager");
        Intrinsics.checkNotNullParameter((Object)screenManager, (String)"screenManager");
        Intrinsics.checkNotNullParameter((Object)snackbarItemsProvider, (String)"snackbarItemsProvider");
        Intrinsics.checkNotNullParameter((Object)navigatorFactory, (String)"navigatorFactory");
        Intrinsics.checkNotNullParameter((Object)savedStateHolder, (String)"savedStateHolder");
        Intrinsics.checkNotNullParameter((Object)statisticsManager, (String)"statisticsManager");
        Intrinsics.checkNotNullParameter((Object)lifecycleTracker, (String)"lifecycleTracker");
        this.ui = ui;
        this.i18n = i18n;
        this.composeWindowManager = composeWindowManager;
        this.screenManager = screenManager;
        this.snackbarItemsProvider = snackbarItemsProvider;
        this.navigatorFactory = navigatorFactory;
        this.savedStateHolder = savedStateHolder;
        this.statisticsManager = statisticsManager;
        this.lifecycleTracker = lifecycleTracker;
        this.id = MainWindowID.INSTANCE;
        this._windowDescriptorState = StateFlowKt.MutableStateFlow(null);
        this.windowDescriptorState = FlowKt.asStateFlow(this._windowDescriptorState);
    }

    @Override
    @NotNull
    public MainWindowID getId() {
        return this.id;
    }

    @Override
    @NotNull
    public StateFlow<WindowDescriptor> getWindowDescriptorState() {
        return this.windowDescriptorState;
    }

    private final WindowDescriptor getWindowDescriptor() {
        return (WindowDescriptor)this._windowDescriptorState.getValue();
    }

    @Override
    @Nullable
    public Navigator getNavigator() {
        Navigator navigator;
        Navigator navigator2 = this._navigator;
        if (navigator2 != null) {
            Navigator navigator3;
            Navigator it = navigator3 = navigator2;
            boolean bl = false;
            navigator = this.getWindowDescriptor() != null ? navigator3 : null;
        } else {
            navigator = null;
        }
        return navigator;
    }

    @Override
    public void showMainWindow(@Nullable Screen screen, boolean minimized) {
        UtilKt.invokeLaterIfNeeded((Function0<Unit>)((Function0)() -> MainWindowManagerImpl.showMainWindow$lambda$0(this, screen, minimized)));
    }

    @Override
    public void showWindow(boolean minimized) {
        MainWindowManager.showMainWindow$default(this, null, minimized, 1, null);
    }

    private static final Unit showMainWindow$lambda$0(MainWindowManagerImpl this$0, Screen $screen, boolean $minimized) {
        Navigator localNavigator;
        WindowDescriptor windowDescriptor = this$0.getWindowDescriptor();
        boolean bl = windowDescriptor != null ? windowDescriptor.isVisible() : false;
        if (bl) {
            Navigator navigator = this$0._navigator;
            if (navigator != null) {
                Navigator it = navigator;
                boolean bl2 = false;
                if ($screen != null) {
                    Navigator.navigate$default(it, $screen, false, null, 6, null);
                }
            }
            WindowDescriptor windowDescriptor2 = this$0.getWindowDescriptor();
            if (windowDescriptor2 != null) {
                windowDescriptor2.toFront();
            }
            return Unit.INSTANCE;
        }
        if (!((Boolean)this$0.lifecycleTracker.getAllowGeneralUi().getValue()).booleanValue()) {
            Logger.INSTANCE.error("Showing UI not allowed");
            return Unit.INSTANCE;
        }
        long size = DpKt.DpSize-YgX7TsA(ConstantsKt.getAPP_FULL_WINDOW_WIDTH(), ConstantsKt.getAPP_FULL_WINDOW_HEIGHT());
        SaveableStateRegistry widgetRegistry = SaveableStateRegistryKt.SaveableStateRegistry(this$0.savedStateHolder.restoreState(MainWindowID.INSTANCE), (Function1<Object, Boolean>)((Function1)MainWindowManagerImpl::showMainWindow$lambda$0$1));
        this$0._navigator = localNavigator = this$0.navigatorFactory.createNavigator(MainWindowID.INSTANCE, $screen, (Function0<Unit>)((Function0)() -> MainWindowManagerImpl.showMainWindow$lambda$0$2(this$0, widgetRegistry)));
        ComposeWindowManager composeWindowManager = this$0.composeWindowManager;
        WindowPosition.Aligned aligned = WindowPosition_desktopKt.WindowPosition(Alignment.Companion.getCenter());
        float f = UnitKt.getUnit(5);
        WindowExceptionHandler windowExceptionHandler = NavigatorImplKt.resetNavigatorExceptionHandler(localNavigator);
        ComposeWindowManager.showWindow-sabGvuc$default(composeWindowManager, size, null, size, aligned, null, false, $minimized, "Toolbox App", false, false, false, false, f, windowExceptionHandler, ComposableLambdaKt.composableLambdaInstance(-778107431, true, new Function3<WindowDescriptor, Composer, Integer, Unit>(widgetRegistry, localNavigator, this$0, $screen){
            final /* synthetic */ SaveableStateRegistry $widgetRegistry;
            final /* synthetic */ Navigator $localNavigator;
            final /* synthetic */ MainWindowManagerImpl this$0;
            final /* synthetic */ Screen $screen;
            {
                this.$widgetRegistry = $widgetRegistry;
                this.$localNavigator = $localNavigator;
                this.this$0 = $receiver;
                this.$screen = $screen;
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(WindowDescriptor descriptor, Composer $composer, int $changed) {
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                ComposerKt.sourceInformation($composer, "C91@4071L18,91@4054L35,93@4145L75,89@3936L284,97@4257L135,97@4228L164,104@4400L60,106@4489L131,106@4468L152:MainWindowManagerImpl.kt#87n3yi");
                int $dirty = $changed;
                if (($changed & 6) == 0) {
                    $dirty |= $composer.changed(descriptor) ? 4 : 2;
                }
                if ($composer.shouldExecute(($dirty & 0x13) != 18, $dirty & 1)) {
                    Object object;
                    Object object2;
                    boolean invalid$iv;
                    Composer $this$cache$iv;
                    Object object3;
                    Object object4;
                    void invalid$iv2;
                    void $this$cache$iv22;
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventStart(-778107431, $dirty, -1, "com.jetbrains.toolbox.ui.window.MainWindowManagerImpl.showMainWindow.<anonymous>.<anonymous> (MainWindowManagerImpl.kt:89)");
                    }
                    Function1 function1 = new ProvidedValue[3];
                    function1[0] = SaveableStateRegistryKt.getLocalSaveableStateRegistry().provides(this.$widgetRegistry);
                    Function1 function12 = function1;
                    int n = 1;
                    ProvidableCompositionLocal<Navigator> providableCompositionLocal = NavigatorImplKt.getLocalNavigator();
                    Object[] objectArray = new Object[]{};
                    Saver<T, ? extends Object> saver = null;
                    String string = null;
                    ComposerKt.sourceInformationMarkerStart($composer, -436926645, "CC(remember):MainWindowManagerImpl.kt#9igjgp");
                    Composer composer = $composer;
                    boolean bl = $composer.changedInstance(this.$localNavigator);
                    Navigator navigator = this.$localNavigator;
                    boolean $i$f$cache = false;
                    Object it$iv = $this$cache$iv22.rememberedValue();
                    boolean bl2 = false;
                    if (invalid$iv2 != false || it$iv == Composer.Companion.getEmpty()) {
                        String string2 = string;
                        Saver<T, ? extends Object> saver2 = saver;
                        Object[] objectArray2 = objectArray;
                        ProvidableCompositionLocal<Navigator> providableCompositionLocal2 = providableCompositionLocal;
                        int n2 = n;
                        object4 = function12;
                        boolean bl3 = false;
                        Function0 function0 = () -> showMainWindow.1.2.invoke$lambda$0$0(navigator);
                        function12 = object4;
                        n = n2;
                        providableCompositionLocal = providableCompositionLocal2;
                        objectArray = objectArray2;
                        saver = saver2;
                        string = string2;
                        Function0 value$iv = function0;
                        $this$cache$iv22.updateRememberedValue(value$iv);
                        object3 = value$iv;
                    } else {
                        object3 = it$iv;
                    }
                    Object object5 = (Function0)object3;
                    ComposerKt.sourceInformationMarkerEnd($composer);
                    function12[n] = providableCompositionLocal.provides((Navigator)RememberSaveableKt.rememberSaveable(objectArray, saver, string, object5, $composer, 0, 6));
                    function1[2] = LocalsKt.getLocalMainWindowManager().provides(this.this$0);
                    CompositionLocalKt.CompositionLocalProvider(function1, (Function2<? super Composer, ? super Integer, Unit>)((Function2)ComposableLambdaKt.rememberComposableLambda(1206667545, true, new Function2<Composer, Integer, Unit>(this.this$0, this.$screen){
                        final /* synthetic */ MainWindowManagerImpl this$0;
                        final /* synthetic */ Screen $screen;
                        {
                            this.this$0 = $receiver;
                            this.$screen = $screen;
                        }

                        public final void invoke(Composer $composer, int $changed) {
                            ComposerKt.sourceInformation($composer, "C94@4158L54:MainWindowManagerImpl.kt#87n3yi");
                            if ($composer.shouldExecute(($changed & 3) != 2, $changed & 1)) {
                                if (ComposerKt.isTraceInProgress()) {
                                    ComposerKt.traceEventStart(1206667545, $changed, -1, "com.jetbrains.toolbox.ui.window.MainWindowManagerImpl.showMainWindow.<anonymous>.<anonymous>.<anonymous> (MainWindowManagerImpl.kt:94)");
                                }
                                MainWindowManagerImpl.access$getUi$p(this.this$0).FullWindowContent(MainWindowManagerImpl.access$getScreenManager$p(this.this$0).initialScreen(this.$screen), $composer, 0);
                                if (ComposerKt.isTraceInProgress()) {
                                    ComposerKt.traceEventEnd();
                                }
                            } else {
                                $composer.skipToGroupEnd();
                            }
                        }
                    }, $composer, 54)), $composer, 0x30 | ProvidedValue.$stable);
                    Object object6 = descriptor;
                    ComposerKt.sourceInformationMarkerStart($composer, -436920576, "CC(remember):MainWindowManagerImpl.kt#9igjgp");
                    object5 = $composer;
                    boolean $this$cache$iv22 = $composer.changedInstance(this.this$0) | ($dirty & 0xE) == 4;
                    MainWindowManagerImpl mainWindowManagerImpl = this.this$0;
                    boolean $i$f$cache2 = false;
                    Object it$iv2 = $this$cache$iv.rememberedValue();
                    $i$a$-let-ComposerKt$cache$1$iv = false;
                    if (invalid$iv || it$iv2 == Composer.Companion.getEmpty()) {
                        object4 = object6;
                        boolean bl4 = false;
                        object6 = object4;
                        Function1 value$iv = arg_0 -> showMainWindow.1.2.invoke$lambda$1$0(mainWindowManagerImpl, descriptor, arg_0);
                        $this$cache$iv.updateRememberedValue(value$iv);
                        object2 = value$iv;
                    } else {
                        object2 = it$iv2;
                    }
                    function1 = (Function1)object2;
                    ComposerKt.sourceInformationMarkerEnd($composer);
                    EffectsKt.DisposableEffect(object6, (Function1<? super DisposableEffectScope, ? extends DisposableEffectResult>)function1, $composer, 0xE & $dirty);
                    SnackbarUtilsKt.SubscribeToSnackbarEvents(descriptor, MainWindowManagerImpl.access$getSnackbarItemsProvider$p(this.this$0), $composer, 0xE & $dirty);
                    Unit unit = Unit.INSTANCE;
                    ComposerKt.sourceInformationMarkerStart($composer, -436913156, "CC(remember):MainWindowManagerImpl.kt#9igjgp");
                    $this$cache$iv = $composer;
                    invalid$iv = $composer.changedInstance(this.this$0);
                    mainWindowManagerImpl = this.this$0;
                    $i$f$cache2 = false;
                    it$iv2 = $this$cache$iv.rememberedValue();
                    $i$a$-let-ComposerKt$cache$1$iv = false;
                    if (invalid$iv || it$iv2 == Composer.Companion.getEmpty()) {
                        object4 = unit;
                        boolean bl5 = false;
                        unit = object4;
                        Function2 value$iv = (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(mainWindowManagerImpl, null){
                            int label;
                            final /* synthetic */ MainWindowManagerImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        MainWindowManagerImpl.access$getStatisticsManager$p(this.this$0).getLogger().log(Fus.Counters.WindowManagement.INSTANCE.getWindowShownEvent(), FusEnums.ReportedWindow.MAIN_WINDOW);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        };
                        $this$cache$iv.updateRememberedValue(value$iv);
                        object = value$iv;
                    } else {
                        object = it$iv2;
                    }
                    function1 = (Function2)object;
                    ComposerKt.sourceInformationMarkerEnd($composer);
                    EffectsKt.LaunchedEffect(unit, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)function1, $composer, 6);
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventEnd();
                    }
                } else {
                    $composer.skipToGroupEnd();
                }
            }

            private static final Navigator invoke$lambda$0$0(Navigator $localNavigator) {
                return $localNavigator;
            }

            private static final DisposableEffectResult invoke$lambda$1$0(MainWindowManagerImpl this$0, WindowDescriptor $descriptor, DisposableEffectScope $this$DisposableEffect) {
                Intrinsics.checkNotNullParameter((Object)$this$DisposableEffect, (String)"$this$DisposableEffect");
                MainWindowManagerImpl.access$get_windowDescriptorState$p(this$0).setValue((Object)$descriptor);
                DisposableEffectScope this_$iv = $this$DisposableEffect;
                boolean $i$f$onDispose = false;
                return new DisposableEffectResult(this$0){
                    final /* synthetic */ MainWindowManagerImpl this$0;
                    {
                        this.this$0 = mainWindowManagerImpl;
                    }

                    public void dispose() {
                        boolean bl = false;
                        MainWindowManagerImpl.access$get_windowDescriptorState$p(this.this$0).setValue(null);
                    }
                };
            }
        }), 3890, null);
        return Unit.INSTANCE;
    }

    private static final boolean showMainWindow$lambda$0$1(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof SwipeableState);
    }

    private static final Unit showMainWindow$lambda$0$2(MainWindowManagerImpl this$0, SaveableStateRegistry $widgetRegistry) {
        this$0.savedStateHolder.saveState(MainWindowID.INSTANCE, $widgetRegistry.performSave());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ToolboxUi access$getUi$p(MainWindowManagerImpl $this) {
        return $this.ui;
    }

    public static final /* synthetic */ ScreenManager access$getScreenManager$p(MainWindowManagerImpl $this) {
        return $this.screenManager;
    }

    public static final /* synthetic */ SnackbarItemsProvider access$getSnackbarItemsProvider$p(MainWindowManagerImpl $this) {
        return $this.snackbarItemsProvider;
    }

    public static final /* synthetic */ MutableStateFlow access$get_windowDescriptorState$p(MainWindowManagerImpl $this) {
        return $this._windowDescriptorState;
    }

    public static final /* synthetic */ StatisticsManager access$getStatisticsManager$p(MainWindowManagerImpl $this) {
        return $this.statisticsManager;
    }
}

