/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.window;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpKt;
import androidx.compose.ui.unit.DpOffset;
import androidx.compose.ui.unit.DpRect;
import androidx.compose.ui.window.DialogState;
import androidx.compose.ui.window.DialogWindowScope;
import androidx.compose.ui.window.FrameWindowScope;
import androidx.compose.ui.window.WindowState;
import com.jetbrains.toolbox.ui.window.DescriptorsKt;
import com.jetbrains.toolbox.ui.window.DialogDescriptorImpl;
import com.jetbrains.toolbox.ui.window.WindowDescriptorImpl;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.crystal.WindowDescriptor;
import org.tinylog.kotlin.Logger;

public final class DescriptorsKt {
    @NotNull
    public static final WindowDescriptor createWindowDescriptor(@NotNull WindowState state2, @NotNull FrameWindowScope scope2, @NotNull MutableState<Boolean> visibilityState, @NotNull CoroutineScope coroutineScope, @NotNull Function0<Unit> closeCallback) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(visibilityState, (String)"visibilityState");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(closeCallback, (String)"closeCallback");
        return new WindowDescriptorImpl(state2, scope2, visibilityState, coroutineScope, closeCallback);
    }

    @NotNull
    public static final WindowDescriptor createDialogDescriptor(@NotNull DialogState state2, @NotNull DialogWindowScope scope2, @NotNull MutableState<Boolean> visibilityState, @NotNull CoroutineScope coroutineScope, @NotNull Function0<Unit> closeCallback) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(visibilityState, (String)"visibilityState");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(closeCallback, (String)"closeCallback");
        return new DialogDescriptorImpl(state2, scope2, visibilityState, coroutineScope, closeCallback);
    }

    private static final MutableState<Boolean> createFocusedState(Window window, Function0<String> winTitleSupplier) {
        MutableState state2 = SnapshotStateKt.mutableStateOf$default(true, null, 2, null);
        window.addWindowFocusListener(new WindowFocusListener(state2, winTitleSupplier){
            final /* synthetic */ MutableState<Boolean> $state;
            final /* synthetic */ Function0<String> $winTitleSupplier;
            {
                this.$state = $state;
                this.$winTitleSupplier = $winTitleSupplier;
            }

            public void windowGainedFocus(WindowEvent e) {
                this.$state.setValue(true);
                Logger.INSTANCE.trace("Window " + this.$winTitleSupplier.invoke() + " gained focus");
            }

            public void windowLostFocus(WindowEvent e) {
                this.$state.setValue(false);
                Logger.INSTANCE.trace("Window " + this.$winTitleSupplier.invoke() + " lost focus");
            }
        });
        return state2;
    }

    private static final MutableState<DpRect> createBoundsState(Window window, DpRect initRect, CoroutineScope listenerScope, Function0<String> winTitleSupplier) {
        MutableState state2 = SnapshotStateKt.mutableStateOf$default(initRect, null, 2, null);
        window.addComponentListener(new ComponentAdapter(state2, window, winTitleSupplier){
            final /* synthetic */ MutableState<DpRect> $state;
            final /* synthetic */ Window $window;
            final /* synthetic */ Function0<String> $winTitleSupplier;
            {
                this.$state = $state;
                this.$window = $window;
                this.$winTitleSupplier = $winTitleSupplier;
            }

            public void componentResized(ComponentEvent e) {
                Rectangle rectangle = this.$window.getBounds();
                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
                this.$state.setValue(this.toDpRect(rectangle));
                Logger.INSTANCE.trace(() -> createBoundsState.1.componentResized$lambda$0(this.$winTitleSupplier, this.$state));
            }

            public void componentMoved(ComponentEvent e) {
                Rectangle rectangle = this.$window.getBounds();
                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
                this.$state.setValue(this.toDpRect(rectangle));
                Logger.INSTANCE.trace(() -> createBoundsState.1.componentMoved$lambda$1(this.$winTitleSupplier, this.$state));
            }

            /*
             * WARNING - void declaration
             */
            private final DpRect toDpRect(Rectangle rect) {
                void val1$iv$iv;
                void y$iv;
                void x$iv;
                int $this$dp$iv22 = rect.x;
                boolean $i$f$getDp = false;
                float $this$dp$iv22 = Dp.constructor-impl($this$dp$iv22);
                int $this$dp$iv32 = rect.y;
                boolean $i$f$getDp2 = false;
                float $this$dp$iv32 = Dp.constructor-impl($this$dp$iv32);
                boolean bl = false;
                void var7_8 = x$iv;
                void val2$iv$iv = y$iv;
                boolean $i$f$packFloats = false;
                long v1$iv$iv = Float.floatToRawIntBits((float)val1$iv$iv);
                long v2$iv$iv = Float.floatToRawIntBits((float)val2$iv$iv);
                long position = DpOffset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
                int $this$dp$iv = rect.width;
                boolean $i$f$getDp3 = false;
                float f = Dp.constructor-impl($this$dp$iv);
                $this$dp$iv = rect.height;
                $i$f$getDp3 = false;
                long size = DpKt.DpSize-YgX7TsA(f, Dp.constructor-impl($this$dp$iv));
                return new DpRect(position, size, null);
            }

            private static final String componentResized$lambda$0(Function0 $winTitleSupplier, MutableState $state) {
                return "Window " + $winTitleSupplier.invoke() + " resized. WindowDescriptor.bounds changed to " + $state.getValue();
            }

            private static final String componentMoved$lambda$1(Function0 $winTitleSupplier, MutableState $state) {
                return "Window " + $winTitleSupplier.invoke() + " moved. WindowDescriptor.bounds changed to " + $state.getValue();
            }
        });
        BuildersKt.launch$default((CoroutineScope)listenerScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((MutableState<DpRect>)state2, window, winTitleSupplier, null){
            int label;
            final /* synthetic */ MutableState<DpRect> $state;
            final /* synthetic */ Window $window;
            final /* synthetic */ Function0<String> $winTitleSupplier;
            {
                this.$state = $state;
                this.$window = $window;
                this.$winTitleSupplier = $winTitleSupplier;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.drop(SnapshotStateKt.snapshotFlow(() -> createBoundsState.2.invokeSuspend$lambda$0(this.$state)), (int)1).collect(new FlowCollector(this.$window, this.$winTitleSupplier){
                            final /* synthetic */ Window $window;
                            final /* synthetic */ Function0<String> $winTitleSupplier;
                            {
                                this.$window = $window;
                                this.$winTitleSupplier = $winTitleSupplier;
                            }

                            public final Object emit(DpRect newBounds, Continuation<? super Unit> $completion) {
                                float arg0$iv$iv;
                                DpRect $this$width$iv = newBounds;
                                boolean $i$f$getWidth = false;
                                float f = $this$width$iv.getRight-D9Ej5fM();
                                float other$iv$iv = $this$width$iv.getLeft-D9Ej5fM();
                                boolean bl = false;
                                int n = (int)Dp.constructor-impl((float)(arg0$iv$iv - other$iv$iv));
                                DpRect $this$height$iv = newBounds;
                                boolean $i$f$getHeight = false;
                                arg0$iv$iv = $this$height$iv.getBottom-D9Ej5fM();
                                other$iv$iv = $this$height$iv.getTop-D9Ej5fM();
                                bl = false;
                                Rectangle rect = new Rectangle((int)newBounds.getLeft-D9Ej5fM(), (int)newBounds.getTop-D9Ej5fM(), n, (int)Dp.constructor-impl(arg0$iv$iv - other$iv$iv));
                                if (!Intrinsics.areEqual((Object)rect, (Object)this.$window.getBounds())) {
                                    this.$window.setBounds(rect);
                                    Logger.INSTANCE.trace(() -> createBoundsState.2.emit$lambda$0(this.$winTitleSupplier, rect));
                                }
                                return Unit.INSTANCE;
                            }

                            private static final String emit$lambda$0(Function0 $winTitleSupplier, Rectangle $rect) {
                                return "WindowDescriptor.bounds for window " + $winTitleSupplier.invoke() + " has changed. Window bounds changed to " + $rect;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final DpRect invokeSuspend$lambda$0(MutableState $state) {
                return (DpRect)$state.getValue();
            }
        }), (int)3, null);
        return state2;
    }

    public static final /* synthetic */ MutableState access$createFocusedState(Window window, Function0 winTitleSupplier) {
        return DescriptorsKt.createFocusedState(window, (Function0<String>)winTitleSupplier);
    }

    public static final /* synthetic */ MutableState access$createBoundsState(Window window, DpRect initRect, CoroutineScope listenerScope, Function0 winTitleSupplier) {
        return DescriptorsKt.createBoundsState(window, initRect, listenerScope, (Function0<String>)winTitleSupplier);
    }
}

