/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.views;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

sealed interface Account {

    public static final class Anonymous
    implements Account {
        @NotNull
        public static final Anonymous INSTANCE = new Anonymous();

        private Anonymous() {
        }

        @NotNull
        public final LocalizableString getText() {
            return LocalizableStringExKt.trl("Log in");
        }

        @NotNull
        public String toString() {
            return "Anonymous";
        }

        public int hashCode() {
            return 49744530;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Anonymous)) {
                return false;
            }
            Anonymous cfr_ignored_0 = (Anonymous)other;
            return true;
        }
    }

    public static final class Enterprise
    implements Account {
        @NotNull
        private final String name;
        @Nullable
        private final String email;

        public Enterprise(@NotNull String name2, @Nullable String email) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
            this.email = email;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getEmail() {
            return this.email;
        }

        @NotNull
        public String toString() {
            return "Enterprise(name=" + this.name + ", email=" + this.email + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.email == null ? 0 : this.email.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Enterprise)) {
                return false;
            }
            Enterprise enterprise = (Enterprise)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)enterprise.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.email, (Object)enterprise.email);
        }
    }

    public static final class JetBrains
    implements Account {
        @NotNull
        private final String name;
        @NotNull
        private final String email;

        public JetBrains(@NotNull String name2, @NotNull String email) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            this.name = name2;
            this.email = email;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getEmail() {
            return this.email;
        }

        @NotNull
        public String toString() {
            return "JetBrains(name=" + this.name + ", email=" + this.email + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.email.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JetBrains)) {
                return false;
            }
            JetBrains jetBrains = (JetBrains)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)jetBrains.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.email, (Object)jetBrains.email);
        }
    }
}

