/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.navigation;

import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.ui.navigation.Screen;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NavigationContext {
    @NotNull
    private final Screen from;
    @NotNull
    private final Screen to;
    @NotNull
    private final FusEnums.UIGenerator generator;

    public NavigationContext(@NotNull Screen from, @NotNull Screen to, @NotNull FusEnums.UIGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)((Object)generator), (String)"generator");
        this.from = from;
        this.to = to;
        this.generator = generator;
    }

    @NotNull
    public final Screen getFrom() {
        return this.from;
    }

    @NotNull
    public final FusEnums.UIGenerator getGenerator() {
        return this.generator;
    }

    @NotNull
    public String toString() {
        return "NavigationContext(from=" + this.from + ", to=" + this.to + ", generator=" + this.generator + ")";
    }

    public int hashCode() {
        int result2 = this.from.hashCode();
        result2 = result2 * 31 + this.to.hashCode();
        result2 = result2 * 31 + this.generator.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NavigationContext)) {
            return false;
        }
        NavigationContext navigationContext = (NavigationContext)other;
        if (!Intrinsics.areEqual((Object)this.from, (Object)navigationContext.from)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.to, (Object)navigationContext.to)) {
            return false;
        }
        return this.generator == navigationContext.generator;
    }
}

