/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.navigation;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.settings.Tab;
import com.jetbrains.toolbox.ui.navigation.Navigator;
import com.jetbrains.toolbox.ui.navigation.Screen;
import com.jetbrains.toolbox.ui.navigation.ScreenWithTitle;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmptyNavigator
implements Navigator {
    @NotNull
    public static final EmptyNavigator INSTANCE = new EmptyNavigator();
    @NotNull
    private static final StateFlow<Screen> current = (StateFlow)StateFlowKt.MutableStateFlow((Object)Screen.Main.INSTANCE);
    @Nullable
    private static final ScreenWithTitle previousScreen;
    @NotNull
    private static final LocalizableString backLabel;
    @NotNull
    private static final LocalizableString forwardLabel;
    @NotNull
    private static LocalizableString currentScreenTitle;
    @NotNull
    private static final MutableStateFlow<LocalizableString> currentScreenTitleState;
    public static final int $stable;

    private EmptyNavigator() {
    }

    @Override
    @NotNull
    public StateFlow<Screen> getCurrent() {
        return current;
    }

    @Override
    @Nullable
    public ScreenWithTitle getPreviousScreen() {
        return previousScreen;
    }

    @Override
    @NotNull
    public StateFlow<ScreenWithTitle> getPreviousScreenState() {
        return (StateFlow)StateFlowKt.MutableStateFlow(null);
    }

    @Override
    @NotNull
    public StateFlow<ScreenWithTitle> getNextScreenState() {
        return (StateFlow)StateFlowKt.MutableStateFlow(null);
    }

    @Override
    @NotNull
    public LocalizableString getBackLabel() {
        return backLabel;
    }

    @Override
    @NotNull
    public LocalizableString getForwardLabel() {
        return forwardLabel;
    }

    @Override
    public void navigate(@NotNull Screen screen, boolean force, @NotNull FusEnums.UIGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        Intrinsics.checkNotNullParameter((Object)((Object)generator), (String)"generator");
    }

    @Override
    public void back(boolean force, @NotNull FusEnums.UIGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)((Object)generator), (String)"generator");
    }

    @Override
    public void forward(@NotNull FusEnums.UIGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)((Object)generator), (String)"generator");
    }

    @Override
    public void changeTab(@NotNull Tab tab) {
        Intrinsics.checkNotNullParameter((Object)((Object)tab), (String)"tab");
    }

    @Override
    public void setCurrentScreenTitle(@NotNull LocalizableString localizableString) {
        Intrinsics.checkNotNullParameter((Object)localizableString, (String)"<set-?>");
        currentScreenTitle = localizableString;
    }

    @Override
    @NotNull
    public MutableStateFlow<LocalizableString> getCurrentScreenTitleState() {
        return currentScreenTitleState;
    }

    static {
        backLabel = LocalizableStringExKt.notr("");
        forwardLabel = LocalizableStringExKt.notr("");
        currentScreenTitle = LocalizableStringExKt.notr("");
        currentScreenTitleState = StateFlowKt.MutableStateFlow((Object)LocalizableStringExKt.notr(""));
        $stable = 8;
    }
}

