/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.components.gateway;

import com.jetbrains.toolbox.ui.components.gateway.Divider;
import com.jetbrains.toolbox.ui.components.gateway.SelectableComboboxItem;
import com.jetbrains.toolbox.viewmodel.ActionModel;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface ComboboxItem
permits Action, Group, Value, Divider {
    @NotNull
    public String getText();

    public static final class Action
    implements ComboboxItem,
    SelectableComboboxItem {
        @NotNull
        private final String text;
        @NotNull
        private final Function0<Unit> onClick;

        public Action(@NotNull String text2, @NotNull Function0<Unit> onClick2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(onClick2, (String)"onClick");
            this.text = text2;
            this.onClick = onClick2;
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @NotNull
        public final Function0<Unit> getOnClick() {
            return this.onClick;
        }

        public int hashCode() {
            return this.getText().hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Object object2 = other;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.ui.components.gateway.ComboboxItem.Action");
            Action cfr_ignored_0 = (Action)object2;
            return Intrinsics.areEqual((Object)this.getText(), (Object)((Action)other).getText());
        }

        @NotNull
        public String toString() {
            return "Action(text=" + this.text + ", onClick=" + this.onClick + ")";
        }
    }

    public static final class Group
    implements ComboboxItem {
        @NotNull
        private final String text;
        @Nullable
        private final ActionModel action;

        public Group(@NotNull String text2, @Nullable ActionModel action) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
            this.action = action;
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Nullable
        public final ActionModel getAction() {
            return this.action;
        }

        public int hashCode() {
            return this.getText().hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Object object2 = other;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.ui.components.gateway.ComboboxItem.Group");
            Group cfr_ignored_0 = (Group)object2;
            return Intrinsics.areEqual((Object)this.getText(), (Object)((Group)other).getText());
        }

        @NotNull
        public String toString() {
            return "Group(text=" + this.text + ", action=" + this.action + ")";
        }
    }

    public static final class Value
    implements ComboboxItem,
    SelectableComboboxItem {
        @NotNull
        private final String text;
        @Nullable
        private final Group group;
        @Nullable
        private final Function0<Unit> onDelete;

        public Value(@NotNull String text2, @Nullable Group group, @Nullable Function0<Unit> onDelete) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
            this.group = group;
            this.onDelete = onDelete;
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Nullable
        public final Group getGroup() {
            return this.group;
        }

        @Nullable
        public final Function0<Unit> getOnDelete() {
            return this.onDelete;
        }

        public final boolean matches(@NotNull String filter2) {
            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
            return !StringsKt.equals((String)this.getText(), (String)filter2, (boolean)true) && StringsKt.contains((CharSequence)this.getText(), (CharSequence)filter2, (boolean)true);
        }

        public int hashCode() {
            Group group = this.group;
            return this.getText().hashCode() + (group != null ? group.hashCode() : 0);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Object object2 = other;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.ui.components.gateway.ComboboxItem.Value");
            Value cfr_ignored_0 = (Value)object2;
            if (!Intrinsics.areEqual((Object)this.getText(), (Object)((Value)other).getText())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.group, (Object)((Value)other).group);
        }

        @NotNull
        public String toString() {
            return "Value(text=" + this.text + ", group=" + this.group + ", onDelete=" + this.onDelete + ")";
        }
    }
}

