/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui;

import com.jetbrains.toolbox.UIGlobalState;
import com.jetbrains.toolbox.UIModalState;
import com.jetbrains.toolbox.manager.EndUserAgreementManager;
import com.jetbrains.toolbox.settings.Storage;
import com.jetbrains.toolbox.settings.StorageManager;
import com.jetbrains.toolbox.ui.navigation.Navigator;
import com.jetbrains.toolbox.ui.navigation.Screen;
import com.jetbrains.toolbox.ui.navigation.ScreenCategory;
import com.jetbrains.toolbox.ui.navigation.ScreenCategoryProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nScreenManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenManager.kt\ncom/jetbrains/toolbox/ui/ScreenManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class ScreenManager {
    @NotNull
    private final EndUserAgreementManager endUserAgreementManager;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final UIGlobalState uiGlobalStateManager;
    @NotNull
    private final List<ScreenCategoryProvider> screenCategories;
    @NotNull
    private final Map<Screen, ScreenCategory> cachedScreenCategories;
    public static final int $stable = 8;

    public ScreenManager(@NotNull EndUserAgreementManager endUserAgreementManager, @NotNull StorageManager storageManager, @NotNull UIGlobalState uiGlobalStateManager, @NotNull List<? extends ScreenCategoryProvider> screenCategories) {
        Intrinsics.checkNotNullParameter((Object)endUserAgreementManager, (String)"endUserAgreementManager");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)uiGlobalStateManager, (String)"uiGlobalStateManager");
        Intrinsics.checkNotNullParameter(screenCategories, (String)"screenCategories");
        this.endUserAgreementManager = endUserAgreementManager;
        this.storageManager = storageManager;
        this.uiGlobalStateManager = uiGlobalStateManager;
        this.screenCategories = screenCategories;
        this.cachedScreenCategories = new LinkedHashMap();
    }

    @Nullable
    public final ScreenCategory resolveScreenCategory(@NotNull Screen screen) {
        ScreenCategory resolved;
        block3: {
            ScreenCategory screenCategory;
            ScreenCategory cached2;
            Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
            ScreenCategory screenCategory2 = cached2 = this.cachedScreenCategories.get(screen);
            if (screenCategory2 != null) {
                return screenCategory2;
            }
            for (ScreenCategoryProvider it : (Iterable)this.screenCategories) {
                boolean bl = false;
                ScreenCategory screenCategory3 = it.resolve(screen);
                if (screenCategory3 == null) continue;
                screenCategory = screenCategory3;
                break block3;
            }
            screenCategory = resolved = null;
        }
        if (resolved != null) {
            this.cachedScreenCategories.put(screen, resolved);
            return resolved;
        }
        return null;
    }

    @NotNull
    public final Screen initialScreen(@Nullable Screen initialScreen) {
        Screen screen = this.initialScreenOrNull(initialScreen);
        if (screen == null) {
            screen = Screen.Main.INSTANCE;
        }
        return screen;
    }

    @Nullable
    public final Screen initialScreenOrNull(@Nullable Screen initialScreen) {
        if (!((Storage)this.storageManager.getStorage().getValue()).getOnboarding().isTechnicalOnboardingFinished()) {
            return new Screen.Onboarding(((Storage)this.storageManager.getStorage().getValue()).getOnboarding().isEnterpriseBlockedScreen());
        }
        if (!this.endUserAgreementManager.getAccepted()) {
            return Screen.EndUserAgreement.INSTANCE;
        }
        Screen screen = initialScreen;
        if (screen == null) {
            screen = this.toModalScreenOrNull((UIModalState)this.uiGlobalStateManager.getState().getValue());
        }
        return screen;
    }

    @NotNull
    public final Screen toScreen(@NotNull UIModalState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Screen screen = this.toModalScreenOrNull(state2);
        if (screen == null) {
            screen = Screen.Main.INSTANCE;
        }
        return screen;
    }

    public final void resetBlockingScreen(@NotNull Navigator navigator) {
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        if (this.uiGlobalStateManager.getState().getValue() instanceof UIModalState.Normal && this.isBlockingScreen((Screen)navigator.getCurrent().getValue())) {
            Navigator.back$default(navigator, true, null, 2, null);
        }
    }

    private final boolean isBlockingScreen(Screen screen) {
        Screen screen2 = screen;
        return screen2 instanceof Screen.ProposeEnterpriseConfig || screen2 instanceof Screen.ProposeInstall || screen2 instanceof Screen.LicenseAgreement || screen2 instanceof Screen.ModalAction || screen2 instanceof Screen.UnhandledError;
    }

    private final Screen toModalScreenOrNull(UIModalState state2) {
        Screen screen;
        UIModalState uIModalState = state2;
        if (uIModalState instanceof UIModalState.CandidateEnterpriseConfig) {
            screen = new Screen.ProposeEnterpriseConfig(((UIModalState.CandidateEnterpriseConfig)state2).getConfigUrl(), ((UIModalState.CandidateEnterpriseConfig)state2).getCwmConnectionAfterJoin());
        } else if (uIModalState instanceof UIModalState.FeedjetItem) {
            screen = new Screen.ProposeInstall(((UIModalState.FeedjetItem)state2).getToolBuild());
        } else if (uIModalState instanceof UIModalState.LicenseAgreement) {
            screen = new Screen.LicenseAgreement(((UIModalState.LicenseAgreement)state2).getLicenseAgreement(), ((UIModalState.LicenseAgreement)state2).getToolName());
        } else if (uIModalState instanceof UIModalState.Progress) {
            screen = new Screen.ModalAction(((UIModalState.Progress)state2).getMessage());
        } else if (uIModalState instanceof UIModalState.UnhandledError) {
            screen = new Screen.UnhandledError(((UIModalState.UnhandledError)state2).getError());
        } else if (Intrinsics.areEqual((Object)uIModalState, (Object)UIModalState.Normal.INSTANCE)) {
            screen = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return screen;
    }
}

