/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui;

import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.desktop.AdjustEdtPriorityKt;
import com.jetbrains.toolbox.desktop.HotkeyNameLocalizerKt;
import com.jetbrains.toolbox.desktop.UtilKt;
import com.jetbrains.toolbox.i18n.UILanguage;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import com.jetbrains.toolbox.ui.Icons;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

public final class App {
    public App(@NotNull SettingsManager settingsManager, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        if (!UtilKt.isHeadless()) {
            HotkeyNameLocalizerKt.localizeHotKeyNames(FlowExtensionsKt.mapState(settingsManager.getSettings(), App::_init_$lambda$0), coroutineScope, OS.INSTANCE.getType());
            UtilKt.setAppIcon(Icons.INSTANCE.getAppIcon());
            AdjustEdtPriorityKt.keepEventQueue(coroutineScope);
        }
    }

    private static final UILanguage _init_$lambda$0(SelfSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUi().getLanguage();
    }
}

