/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.uninstaller;

import com.jetbrains.toolbox.FileUtils;
import com.jetbrains.toolbox.common.io.Copy_and_moveKt;
import com.jetbrains.toolbox.tools.UninstallResult;
import java.io.IOException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nremoveInstallDir.kt\nKotlin\n*S Kotlin\n*F\n+ 1 removeInstallDir.kt\ncom/jetbrains/toolbox/tools/uninstaller/RemoveInstallDirKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public final class RemoveInstallDirKt {
    @NotNull
    public static final UninstallResult removeInstallDir(@NotNull FileSystem $this$removeInstallDir, @NotNull Path installDir, @Nullable Path backupTo, @NotNull FileUtils fileUtils) {
        UninstallResult uninstallResult;
        Intrinsics.checkNotNullParameter((Object)$this$removeInstallDir, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
        Intrinsics.checkNotNullParameter((Object)fileUtils, (String)"fileUtils");
        Path path2 = backupTo;
        if (path2 == null) {
            path2 = fileUtils.newTempPath(installDir.name());
        }
        Path targetPath = path2;
        boolean deleteTarget = backupTo == null;
        String errorMessage = deleteTarget ? "Can't remove directory '" + installDir + "'" : "Can't backup '" + installDir + "' to '" + backupTo + "'";
        try {
            Path path3 = targetPath.parent();
            if (path3 != null) {
                Path it = path3;
                boolean bl = false;
                $this$removeInstallDir.createDirectories(it);
            }
            $this$removeInstallDir.deleteRecursively(targetPath);
            $this$removeInstallDir.atomicMove(installDir, targetPath);
            uninstallResult = UninstallResult.Success.INSTANCE;
        }
        catch (IOException e) {
            UninstallResult uninstallResult2;
            Logger.INSTANCE.info((Throwable)e, "Cannot move '" + installDir + "' to '" + targetPath + "', trying to delete it in-place now...");
            try {
                if (!deleteTarget) {
                    Copy_and_moveKt.copyRecursively$default($this$removeInstallDir, installDir, targetPath, null, false, 0, 28, null);
                }
                $this$removeInstallDir.deleteRecursively(installDir);
                uninstallResult2 = UninstallResult.Success.INSTANCE;
            }
            catch (IOException e2) {
                Logger.INSTANCE.error(errorMessage + ": " + e2.getMessage());
                uninstallResult2 = new UninstallResult.Blocked(Reflection.getOrCreateKotlinClass(e2.getClass()).getSimpleName() + ": " + e2.getMessage() + " (deleting '" + installDir + "' in-place failed)");
            }
            uninstallResult = uninstallResult2;
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, errorMessage);
            uninstallResult = new UninstallResult.Blocked(Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName() + ": " + e.getMessage() + " (deleting '" + installDir + "' failed)");
        }
        UninstallResult result2 = uninstallResult;
        if (deleteTarget) {
            fileUtils.asyncDelete(targetPath);
        }
        return result2;
    }

    public static /* synthetic */ UninstallResult removeInstallDir$default(FileSystem fileSystem, Path path2, Path path3, FileUtils fileUtils, int n, Object object) {
        if ((n & 2) != 0) {
            path3 = null;
        }
        return RemoveInstallDirKt.removeInstallDir(fileSystem, path2, path3, fileUtils);
    }
}

